/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.ttools.cone.Coverage;
import uk.ac.starlink.ttools.cone.MocCoverage;
import uk.ac.starlink.ttools.cone.UrlMocCoverage;
import uk.ac.starlink.util.URLUtils;

public class Coverage {
    private static final Map<String, MocCoverage> mocMap_ = new HashMap<String, MocCoverage>();
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.func");

    private Coverage() {
    }

    public static boolean inMoc(String mocLocation, double ra, double dec) {
        return Coverage.nearMoc(mocLocation, ra, dec, 0.0);
    }

    public static boolean nearMoc(String mocLocation, double ra, double dec, double distanceDeg) {
        MocCoverage cov = Coverage.getMocCoverage(mocLocation);
        return cov == null || cov.getAmount() == Coverage.Amount.NO_DATA ? false : cov.discOverlaps(ra, dec, distanceDeg);
    }

    private static MocCoverage getMocCoverage(String loc) {
        if (!mocMap_.containsKey(loc)) {
            mocMap_.put(loc, Coverage.createMocCoverage(loc));
        }
        return mocMap_.get(loc);
    }

    private static MocCoverage createMocCoverage(String loc) {
        try {
            URL url = URLUtils.makeURL((String)loc);
            UrlMocCoverage cov = new UrlMocCoverage(url);
            cov.initCoverage();
            if (cov.getAmount() != Coverage.Amount.NO_DATA) {
                return cov;
            }
            logger_.config("No MOC at location: " + loc);
        }
        catch (Exception e) {
            logger_.log(Level.INFO, "No MOC at location: " + loc, e);
        }
        try {
            UrlMocCoverage cov = UrlMocCoverage.getVizierMoc(loc, -1);
            cov.initCoverage();
            if (cov.getAmount() != Coverage.Amount.NO_DATA) {
                return cov;
            }
            logger_.config("No VizieR MOC: " + loc);
        }
        catch (IOException e) {
            logger_.log(Level.INFO, "No VizieR MOC: " + loc, e);
        }
        logger_.warning("Unknown MOC: " + loc + " - assume no coverage");
        return null;
    }
}

