/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import java.io.IOException;
import uk.ac.starlink.ttools.filter.QuantCalc;

public class Lists {
    private Lists() {
    }

    public static double sum(double ... values) {
        if (values == null) {
            return Double.NaN;
        }
        double sum = 0.0;
        for (double v : values) {
            if (Double.isNaN(v)) continue;
            sum += v;
        }
        return sum;
    }

    public static double mean(double ... values) {
        if (values == null) {
            return Double.NaN;
        }
        int n = values.length;
        double sum = 0.0;
        double count = 0.0;
        for (int i = 0; i < n; ++i) {
            double v = values[i];
            if (Double.isNaN(v)) continue;
            count += 1.0;
            sum += v;
        }
        return count == 0.0 ? Double.NaN : sum / count;
    }

    public static double variance(double ... values) {
        if (values == null) {
            return Double.NaN;
        }
        int n = values.length;
        double sum = 0.0;
        double sum2 = 0.0;
        int count = 0;
        for (int i = 0; i < n; ++i) {
            double v = values[i];
            if (Double.isNaN(v)) continue;
            sum += v;
            sum2 += v * v;
            ++count;
        }
        if (count == 0) {
            return Double.NaN;
        }
        double mean = sum / (double)count;
        return sum2 / (double)count - mean * mean;
    }

    public static double stdev(double ... values) {
        return Math.sqrt(Lists.variance(values));
    }

    public static double min(double ... values) {
        double min = Double.NaN;
        if (values != null) {
            for (double v : values) {
                if (!Double.isNaN(min) && !(v < min)) continue;
                min = v;
            }
        }
        return min;
    }

    public static double max(double ... values) {
        double max = Double.NaN;
        if (values != null) {
            for (double v : values) {
                if (!Double.isNaN(max) && !(v > max)) continue;
                max = v;
            }
        }
        return max;
    }

    public static double median(double ... values) {
        QuantCalc qc;
        if (values == null) {
            return Double.NaN;
        }
        try {
            qc = QuantCalc.createInstance(Double.class, values.length);
        }
        catch (IOException e) {
            assert (false);
            return Double.NaN;
        }
        for (double v : values) {
            qc.acceptDatum(new Double(v));
        }
        qc.ready();
        Number median = qc.getQuantile(0.5);
        return median instanceof Number ? median.doubleValue() : Double.NaN;
    }

    public static int countTrue(boolean ... values) {
        int count = 0;
        if (values != null) {
            for (boolean b : values) {
                if (!b) continue;
                ++count;
            }
        }
        return count;
    }
}

