/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

public class Maths {
    public static final double E = Math.E;
    public static final double PI = Math.PI;
    public static final double Infinity = Double.POSITIVE_INFINITY;
    public static final double NaN = Double.NaN;
    public static final double RANDOM = Double.NaN;
    private static double LOG10_FACTOR = 1.0 / Math.log(10.0);

    private Maths() {
    }

    public static double sin(double theta) {
        return Math.sin(theta);
    }

    public static double cos(double theta) {
        return Math.cos(theta);
    }

    public static double tan(double theta) {
        return Math.tan(theta);
    }

    public static double asin(double x) {
        return Math.asin(x);
    }

    public static double acos(double x) {
        return Math.acos(x);
    }

    public static double atan(double x) {
        return Math.atan(x);
    }

    public static double exp(double x) {
        return Math.exp(x);
    }

    public static double log10(double x) {
        return LOG10_FACTOR * Math.log(x);
    }

    public static double ln(double x) {
        return Math.log(x);
    }

    public static double sqrt(double x) {
        return Math.sqrt(x);
    }

    public static double hypot(double ... xs) {
        switch (xs.length) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return xs[0];
            }
            case 2: {
                return Math.hypot(xs[0], xs[1]);
            }
        }
        double s2 = 0.0;
        for (double x : xs) {
            s2 += x * x;
        }
        return Math.sqrt(s2);
    }

    public static double atan2(double y, double x) {
        return Math.atan2(y, x);
    }

    public static double pow(double a, double b) {
        return Math.pow(a, b);
    }

    public static double sinh(double x) {
        return 0.5 * (Math.exp(x) - Math.exp(-x));
    }

    public static double cosh(double x) {
        return 0.5 * (Math.exp(x) + Math.exp(-x));
    }

    public static double tanh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / (Math.exp(x) + Math.exp(-x));
    }

    public static double asinh(double x) {
        return Math.log(x + Math.sqrt(x * x + 1.0));
    }

    public static double acosh(double x) {
        return Math.log(x + Math.sqrt(x * x - 1.0));
    }

    public static double atanh(double x) {
        return 0.5 * Math.log((1.0 + x) / (1.0 - x));
    }
}

