/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.func;

import edu.jhu.htm.core.HTMException;
import edu.jhu.htm.core.HTMfunc;
import gov.fnal.eag.healpix.PixTools;
import javax.vecmath.Vector3d;

public class Tilings {
    private static final PixTools pixTools_ = PixTools.getInstance();
    public static final double SQDEG = 3.0461741978670857E-4;

    private Tilings() {
    }

    public static long htmIndex(int level, double lon, double lat) {
        try {
            return HTMfunc.lookupId((double)lon, (double)lat, (int)level);
        }
        catch (HTMException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static long healpixNestIndex(int k, double lon, double lat) {
        return pixTools_.vect2pix_nest(Tilings.kToNside(k), Tilings.toVector(lon, lat));
    }

    public static long healpixRingIndex(int k, double lon, double lat) {
        return pixTools_.vect2pix_ring(Tilings.kToNside(k), Tilings.toVector(lon, lat));
    }

    public static double healpixNestLon(int k, long index) {
        return Tilings.angToLon(pixTools_.pix2ang_nest(Tilings.kToNside(k), index));
    }

    public static double healpixNestLat(int k, long index) {
        return Tilings.angToLat(pixTools_.pix2ang_nest(Tilings.kToNside(k), index));
    }

    public static double healpixRingLon(int k, long index) {
        return Tilings.angToLon(pixTools_.pix2ang_ring(Tilings.kToNside(k), index));
    }

    public static double healpixRingLat(int k, long index) {
        return Tilings.angToLat(pixTools_.pix2ang_ring(Tilings.kToNside(k), index));
    }

    public static long healpixNestToRing(int k, long nestIndex) {
        return pixTools_.nest2ring(Tilings.kToNside(k), nestIndex);
    }

    public static long healpixRingToNest(int k, long ringIndex) {
        return pixTools_.ring2nest(Tilings.kToNside(k), ringIndex);
    }

    public static int healpixK(double pixelsize) {
        long nside = pixTools_.GetNSide(pixelsize * 60.0 * 60.0);
        return (int)(Math.log(nside) / Math.log(2.0));
    }

    public static double healpixResolution(int k) {
        return Math.sqrt(Tilings.healpixSqdeg(k));
    }

    public static double healpixSteradians(int k) {
        return Math.PI * 4 / (double)(12L << 2 * k);
    }

    public static double healpixSqdeg(int k) {
        return Tilings.steradiansToSqdeg(Tilings.healpixSteradians(k));
    }

    public static double steradiansToSqdeg(double sr) {
        return sr / 3.0461741978670857E-4;
    }

    public static double sqdegToSteradians(double sqdeg) {
        return sqdeg * 3.0461741978670857E-4;
    }

    public static int htmLevel(double pixelsize) {
        return (int)Math.ceil(5.0 - Math.log(pixelsize / 2.8125) / Math.log(2.0));
    }

    public static double htmResolution(int level) {
        return 2.8125 * Math.pow(2.0, 5 - level);
    }

    private static long kToNside(int k) {
        if (k >= 0 && k <= 29) {
            return 1L << k;
        }
        throw new IllegalArgumentException("HEALPix order " + k + " out of range 0..29");
    }

    private static double angToLon(double[] thetaPhi) {
        return Math.toDegrees(thetaPhi[1]);
    }

    private static double angToLat(double[] thetaPhi) {
        return Math.toDegrees(1.5707963267948966 - thetaPhi[0]);
    }

    private static Vector3d toVector(double lon, double lat) {
        double theta = 1.5707963267948966 - Math.toRadians(lat);
        return pixTools_.Ang2Vec(theta, Math.toRadians(lon));
    }
}

