/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.Styles;
import uk.ac.starlink.util.gui.RenderingComboBox;

public class DashComboBox
extends RenderingComboBox {
    private static final int LINE_LENGTH = 48;
    private static final int LINE_THICKNESS = 2;
    private static final float[] SOLID = new float[]{1.0f, 0.0f};

    public DashComboBox() {
        this(Styles.DASHES);
    }

    public DashComboBox(float[][] dashes) {
        dashes = (float[][])dashes.clone();
        this.setModel(new DefaultComboBoxModel((E[])dashes));
    }

    public float[] getSelectedDash() {
        return this.normaliseDash((float[])this.getSelectedItem());
    }

    public void setSelectedDash(float[] dash) {
        dash = this.normaliseDash(dash);
        int nitem = this.getItemCount();
        for (int i = 0; i < nitem; ++i) {
            if (!Arrays.equals(dash, this.normaliseDash((float[])this.getItemAt(i)))) continue;
            this.setSelectedIndex(i);
            return;
        }
        super.setSelectedItem((Object)dash);
    }

    protected String getRendererText(Object d) {
        return null;
    }

    protected Icon getRendererIcon(Object d) {
        final float[] dash = this.normaliseDash((float[])d);
        return new Icon(){

            @Override
            public int getIconHeight() {
                return 2;
            }

            @Override
            public int getIconWidth() {
                return 52;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g;
                Stroke oldStroke = g2.getStroke();
                Color oldColor = g2.getColor();
                g2.setColor(Color.BLACK);
                g2.setStroke(new BasicStroke(2.0f, 0, 0, 10.0f, dash, 0.0f));
                int ypos = y + 1;
                g2.drawLine(x + 4, ypos, y + x + 48, ypos);
                g2.setStroke(oldStroke);
                g2.setColor(oldColor);
            }
        };
    }

    private final float[] normaliseDash(float[] dash) {
        return dash == null ? SOLID : dash;
    }
}

