/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.ttools.plot.ErrorModeSelection;
import uk.ac.starlink.ttools.plot.ErrorRenderer;
import uk.ac.starlink.ttools.plot.MarkShape;
import uk.ac.starlink.ttools.plot.MarkStyle;
import uk.ac.starlink.util.IconUtils;

public class MarkStyleSelectors {
    private static final int MAX_SIZE = 5;
    private static final int MAX_THICK = 10;
    private static final MarkShape[] SHAPES = new MarkShape[]{MarkShape.FILLED_CIRCLE, MarkShape.OPEN_CIRCLE, MarkShape.CROSS, MarkShape.CROXX, MarkShape.OPEN_SQUARE, MarkShape.OPEN_DIAMOND, MarkShape.OPEN_TRIANGLE_UP, MarkShape.OPEN_TRIANGLE_DOWN, MarkShape.FILLED_SQUARE, MarkShape.FILLED_DIAMOND, MarkShape.FILLED_TRIANGLE_UP, MarkShape.FILLED_TRIANGLE_DOWN};

    private MarkStyleSelectors() {
    }

    public static JComboBox createShapeSelector() {
        final JComboBox<MarkShape> selector = new JComboBox<MarkShape>(SHAPES);
        selector.setRenderer(new MarkRenderer(){

            @Override
            public MarkShape getMarkShape(int index) {
                return (MarkShape)selector.getItemAt(index);
            }

            @Override
            public MarkShape getMarkShape() {
                return (MarkShape)selector.getSelectedItem();
            }

            @Override
            public Color getMarkColor() {
                return Color.BLACK;
            }

            @Override
            public int getMarkSize() {
                return 5;
            }
        });
        return selector;
    }

    public static JComboBox createSizeSelector() {
        final JComboBox<Object> selector = new JComboBox<Object>(MarkStyleSelectors.createNumberedModel(6));
        selector.setRenderer(new MarkRenderer(true){

            @Override
            public int getMarkSize(int index) {
                return index;
            }

            @Override
            public int getMarkSize() {
                return selector.getSelectedIndex();
            }

            @Override
            public Color getMarkColor() {
                return Color.BLACK;
            }

            @Override
            public MarkShape getMarkShape() {
                return MarkShape.OPEN_SQUARE;
            }
        });
        return selector;
    }

    public static JComboBox createErrorSelector(ErrorRenderer[] errorRenderers, ErrorRenderer defaultRenderer, ErrorModeSelection[] errorModeSelections) {
        ErrorRendererComboBoxModel model = new ErrorRendererComboBoxModel(errorRenderers, defaultRenderer, errorModeSelections);
        ErrorRendererRenderer renderer = new ErrorRendererRenderer(errorModeSelections);
        JComboBox<Object> errorSelector = new JComboBox<Object>(model);
        errorSelector.setRenderer(renderer);
        return errorSelector;
    }

    public static ComboBoxModel createNumberedModel(int count) {
        Object[] items = new Object[count];
        for (int i = 0; i < count; ++i) {
            items[i] = new Integer(i);
        }
        return new DefaultComboBoxModel<Object>(items);
    }

    public static MarkStyle getStyle(MarkShape shape, int size, Color color, int opaqueLimit, boolean hidePoints, ErrorRenderer errorRenderer, MarkStyle.Line line, int thick, float[] dash, ErrorModeSelection[] errModels) {
        MarkStyle style = size == 0 ? MarkShape.POINT.getStyle(color, 0) : shape.getStyle(color, size);
        style.setOpaqueLimit(opaqueLimit);
        style.setLine(line);
        style.setHidePoints(hidePoints);
        style.setErrorRenderer(errorRenderer);
        style.setLineWidth(thick);
        style.setDash(dash);
        style.setErrorModeModels(errModels);
        return style;
    }

    private static abstract class MarkRenderer
    extends BasicComboBoxRenderer {
        private boolean useText_;

        MarkRenderer() {
            this(false);
        }

        MarkRenderer(boolean useText) {
            this.useText_ = useText;
        }

        MarkShape getMarkShape(int itemIndex) {
            return this.getMarkShape();
        }

        abstract MarkShape getMarkShape();

        int getMarkSize(int itemIndex) {
            return this.getMarkSize();
        }

        abstract int getMarkSize();

        Color getMarkColor(int itemIndex) {
            return this.getMarkColor();
        }

        abstract Color getMarkColor();

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            if (c instanceof JLabel) {
                JLabel label = (JLabel)c;
                if (!this.useText_) {
                    this.setText(null);
                }
                MarkStyle style = index >= 0 ? MarkStyleSelectors.getStyle(this.getMarkShape(index), this.getMarkSize(index), this.getMarkColor(index), 1, false, ErrorRenderer.NONE, null, 1, null, new ErrorModeSelection[0]) : MarkStyleSelectors.getStyle(this.getMarkShape(), this.getMarkSize(), this.getMarkColor(), 1, false, ErrorRenderer.NONE, null, 1, null, new ErrorModeSelection[0]);
                label.setIcon(style.getLegendIcon());
            }
            return c;
        }
    }

    private static class ErrorRendererRenderer
    extends BasicComboBoxRenderer {
        private final ErrorModeSelection[] errModeSelections_;

        ErrorRendererRenderer(ErrorModeSelection[] errorModeSelections) {
            this.errModeSelections_ = errorModeSelections;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            if (c instanceof JLabel) {
                JLabel label = (JLabel)c;
                Icon icon = null;
                if (value instanceof ErrorRenderer) {
                    ErrorRenderer er = (ErrorRenderer)value;
                    ErrorMode[] modes = new ErrorMode[this.errModeSelections_.length];
                    for (int imode = 0; imode < modes.length; ++imode) {
                        modes[imode] = this.errModeSelections_[imode].getErrorMode();
                    }
                    icon = er.getLegendIcon(modes, 40, 15, 5, 1);
                    icon = IconUtils.colorIcon((Icon)icon, (Color)c.getForeground());
                }
                label.setText(icon == null ? "??" : null);
                label.setIcon(icon);
            }
            return c;
        }
    }

    private static class ErrorRendererComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    ActionListener {
        private final ErrorRenderer[] allRenderers_;
        private final ErrorRenderer defaultRenderer_;
        private final ErrorModeSelection[] modeSelections_;
        private List activeRendererList_;
        private ErrorRenderer selected_;

        ErrorRendererComboBoxModel(ErrorRenderer[] renderers, ErrorRenderer defaultRenderer, ErrorModeSelection[] modeSelections) {
            this.allRenderers_ = renderers;
            this.defaultRenderer_ = defaultRenderer;
            this.modeSelections_ = modeSelections;
            this.selected_ = defaultRenderer;
            this.updateState();
            for (int idim = 0; idim < modeSelections.length; ++idim) {
                modeSelections[idim].addActionListener(this);
            }
        }

        @Override
        public Object getElementAt(int index) {
            return (ErrorRenderer)this.activeRendererList_.get(index);
        }

        @Override
        public int getSize() {
            return this.activeRendererList_.size();
        }

        @Override
        public Object getSelectedItem() {
            return this.selected_;
        }

        @Override
        public void setSelectedItem(Object item) {
            if (!this.activeRendererList_.contains(item)) {
                throw new IllegalArgumentException("No such selection " + item);
            }
            this.selected_ = (ErrorRenderer)item;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.updateState();
        }

        private void updateState() {
            int ndim = 0;
            for (int idim = 0; idim < this.modeSelections_.length; ++idim) {
                if (ErrorMode.NONE.equals(this.modeSelections_[idim].getErrorMode())) continue;
                ++ndim;
            }
            ArrayList<ErrorRenderer> rendererList = new ArrayList<ErrorRenderer>();
            for (int ir = 0; ir < this.allRenderers_.length; ++ir) {
                ErrorRenderer renderer = this.allRenderers_[ir];
                if (!renderer.supportsDimensionality(ndim)) continue;
                rendererList.add(renderer);
            }
            if (!rendererList.contains(this.selected_)) {
                this.selected_ = this.defaultRenderer_;
            }
            this.activeRendererList_ = rendererList;
            this.fireContentsChanged(this, 0, this.activeRendererList_.size() - 1);
        }
    }
}

