/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.gui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.Shaders;
import uk.ac.starlink.util.IconUtils;

public class ShaderListCellRenderer
extends BasicComboBoxRenderer {
    private static final Map rendererIconMap_ = new HashMap();

    public ShaderListCellRenderer(final JComboBox comboBox) {
        comboBox.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    ShaderListCellRenderer.this.setEnabled(comboBox.isEnabled());
                }
            }
        });
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSel, boolean hasFocus) {
        Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSel, hasFocus);
        if (comp instanceof JLabel && value instanceof Shader) {
            JLabel label = (JLabel)comp;
            Shader shader = (Shader)value;
            String text = shader.getName();
            if (!shader.isAbsolute()) {
                text = "* " + text;
            }
            label.setText(text);
            label.setIcon(ShaderListCellRenderer.getRendererIcon(shader));
        }
        return comp;
    }

    private static Icon getRendererIcon(Shader shader) {
        if (!rendererIconMap_.containsKey(shader)) {
            Icon icon = Shaders.createShaderIcon(shader, true, 48, 16, 4, 1);
            rendererIconMap_.put(shader, IconUtils.toImageIcon((Icon)icon));
        }
        return (Icon)rendererIconMap_.get(shader);
    }
}

