/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.jel;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.DVMap;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import java.util.HashMap;
import uk.ac.starlink.ttools.jel.JELUtils;

public class JELFunction {
    private final String xvarname_;
    private final String fexpr_;
    private final XResolver xResolver_;
    private final CompiledExpression fCompex_;
    private final Object[] args_;

    public JELFunction(String xvarname, String fexpr) throws CompilationException {
        this.xvarname_ = xvarname;
        this.fexpr_ = fexpr;
        Class[] staticLib = JELUtils.getStaticClasses().toArray(new Class[0]);
        this.xResolver_ = new XResolver(xvarname);
        Class[] dynamicLib = new Class[]{this.xResolver_.getClass()};
        Class[] dotClasses = new Class[]{};
        HashMap<String, Class<?>> cnmap = null;
        Library lib = new Library(staticLib, dynamicLib, dotClasses, this.xResolver_, cnmap);
        this.fCompex_ = Evaluator.compile(fexpr, lib, Double.TYPE);
        this.args_ = new Object[]{this.xResolver_};
    }

    public double evaluate(double x) {
        this.xResolver_.setXValue(x);
        try {
            return this.fCompex_.evaluate_double(this.args_);
        }
        catch (Throwable e) {
            return Double.NaN;
        }
    }

    public String getXVarName() {
        return this.xvarname_;
    }

    public String getExpression() {
        return this.fexpr_;
    }

    public static void main(String[] args) {
        String usage = "Usage: " + JELFunction.class.getName() + " " + "<varname> <expr> <varvalue>\n";
        if (args.length != 3) {
            System.err.println(usage);
            System.exit(1);
        }
        String xvarname = args[0];
        String fexpr = args[1];
        String value = args[2];
        try {
            JELFunction f = new JELFunction(xvarname, fexpr);
            double x = Double.parseDouble(value);
            double y = f.evaluate(x);
            System.out.println("f(" + xvarname + ")=" + fexpr + "\n" + "f(" + value + ")=" + y);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("\n" + usage);
            System.exit(1);
        }
    }

    public static class XResolver
    extends DVMap {
        private final String xvarname_;
        private double dValue_;

        private XResolver(String xvarname) {
            this.xvarname_ = xvarname;
        }

        @Override
        public String getTypeName(String name) {
            return name.equals(this.xvarname_) ? "Double" : null;
        }

        public double getDoubleProperty(String name) {
            return name.equals(this.xvarname_) ? this.dValue_ : Double.NaN;
        }

        private void setXValue(double dval) {
            this.dValue_ = dval;
        }
    }
}

