/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.jel;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.ttools.jel.Constant;
import uk.ac.starlink.ttools.jel.JELRowReader;

public class ResultSetJELRowReader
extends JELRowReader {
    private final ResultSet rset_;
    private String[] colNames_;
    private String[] colLabels_;
    private Class[] colClazzes_;

    public ResultSetJELRowReader(ResultSet rset) throws SQLException {
        this.rset_ = rset;
        ResultSetMetaData rsetMeta = rset.getMetaData();
        int ncol = rsetMeta.getColumnCount();
        this.colNames_ = new String[ncol];
        this.colLabels_ = new String[ncol];
        this.colClazzes_ = new Class[ncol];
        for (int icol = 0; icol < ncol; ++icol) {
            int icol1 = icol + 1;
            this.colNames_[icol] = rsetMeta.getColumnName(icol1);
            this.colLabels_[icol] = rsetMeta.getColumnLabel(icol1);
            String clazzName = rsetMeta.getColumnClassName(icol1);
            try {
                this.colClazzes_[icol] = Class.forName(clazzName);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw (SQLException)new SQLException("No such class " + clazzName).initCause(e);
            }
        }
    }

    @Override
    protected int getColumnIndexByName(String name) {
        int ncol = this.colNames_.length;
        for (int icol = 0; icol < ncol; ++icol) {
            if (!this.colNames_[icol].equalsIgnoreCase(name) && !this.colLabels_[icol].equalsIgnoreCase(name)) continue;
            return icol;
        }
        return -1;
    }

    @Override
    protected Constant getConstantByName(String name) {
        return null;
    }

    @Override
    protected boolean isBlank(int icol) {
        try {
            return Tables.isBlank((Object)this.rset_.getObject(icol + 1)) || this.rset_.wasNull();
        }
        catch (SQLException e) {
            return true;
        }
    }

    @Override
    protected Class getColumnClass(int icol) {
        return this.colClazzes_[icol];
    }

    @Override
    protected boolean getBooleanColumnValue(int icol) {
        try {
            boolean result = this.rset_.getBoolean(icol + 1);
            if (this.rset_.wasNull()) {
                this.foundNull();
            }
            return result;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected byte getByteColumnValue(int icol) {
        try {
            byte result = this.rset_.getByte(icol + 1);
            if (this.rset_.wasNull()) {
                this.foundNull();
            }
            return result;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected char getCharColumnValue(int icol) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected short getShortColumnValue(int icol) {
        try {
            short result = this.rset_.getShort(icol + 1);
            if (this.rset_.wasNull()) {
                this.foundNull();
            }
            return result;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected int getIntColumnValue(int icol) {
        try {
            int result = this.rset_.getInt(icol + 1);
            if (this.rset_.wasNull()) {
                this.foundNull();
            }
            return result;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected long getLongColumnValue(int icol) {
        try {
            long result = this.rset_.getLong(icol + 1);
            if (this.rset_.wasNull()) {
                this.foundNull();
            }
            return result;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected float getFloatColumnValue(int icol) {
        try {
            float result = this.rset_.getFloat(icol + 1);
            if (this.rset_.wasNull()) {
                this.foundNull();
            }
            return result;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected double getDoubleColumnValue(int icol) {
        try {
            double result = this.rset_.getDouble(icol + 1);
            if (this.rset_.wasNull()) {
                this.foundNull();
            }
            return result;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Object getObjectColumnValue(int icol) {
        try {
            return this.rset_.getObject(icol + 1);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Constant getSpecialByName(String name) {
        return super.getSpecialByName(name);
    }
}

