/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.join;

import java.util.logging.Logger;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.NdRange;

public class HumanMatchEngine
implements MatchEngine {
    private final MatchEngine baseEngine_;
    private final ValueInfo[] tupleInfos_;
    private final DescribedValue[] matchParams_;
    private final DescribedValue[] tuningParams_;
    private final ValueWrapper[] tupleWrappers_;
    private final ValueWrapper scoreWrapper_;
    private final ValueInfo scoreInfo_;
    private final int nval_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.join");
    private static ValueWrapper NULL_WRAPPER = new ValueWrapper(){

        @Override
        public Object wrapValue(Object value) {
            return value;
        }

        @Override
        public Object unwrapValue(Object value) {
            return value;
        }

        @Override
        public double wrapDouble(double value) {
            return value;
        }

        @Override
        public ValueInfo wrapValueInfo(ValueInfo info) {
            return info;
        }

        @Override
        public DescribedValue wrapDescribedValue(DescribedValue dval) {
            return dval;
        }
    };

    public HumanMatchEngine(MatchEngine baseEngine) {
        this.baseEngine_ = baseEngine;
        ValueInfo[] tinfos = baseEngine.getTupleInfos();
        this.nval_ = tinfos.length;
        this.tupleWrappers_ = new ValueWrapper[this.nval_];
        this.tupleInfos_ = new ValueInfo[this.nval_];
        for (int i = 0; i < this.nval_; ++i) {
            this.tupleWrappers_[i] = this.createWrapper(tinfos[i]);
            this.tupleInfos_[i] = this.tupleWrappers_[i].wrapValueInfo(tinfos[i]);
        }
        DescribedValue[] mParams = baseEngine.getMatchParameters();
        this.matchParams_ = new DescribedValue[mParams.length];
        for (int i = 0; i < mParams.length; ++i) {
            DescribedValue param = mParams[i];
            this.matchParams_[i] = this.createWrapper(param.getInfo()).wrapDescribedValue(param);
        }
        DescribedValue[] tParams = baseEngine.getTuningParameters();
        this.tuningParams_ = new DescribedValue[tParams.length];
        for (int i = 0; i < tParams.length; ++i) {
            DescribedValue param = tParams[i];
            this.tuningParams_[i] = this.createWrapper(param.getInfo()).wrapDescribedValue(param);
        }
        ValueInfo minfo = baseEngine.getMatchScoreInfo();
        if (minfo != null) {
            this.scoreWrapper_ = this.createWrapper(minfo);
            this.scoreInfo_ = this.scoreWrapper_.wrapValueInfo(minfo);
        } else {
            this.scoreWrapper_ = NULL_WRAPPER;
            this.scoreInfo_ = null;
        }
    }

    public DescribedValue[] getMatchParameters() {
        return this.matchParams_;
    }

    public DescribedValue[] getTuningParameters() {
        return this.tuningParams_;
    }

    public ValueInfo[] getTupleInfos() {
        return this.tupleInfos_;
    }

    public Object[] getBins(Object[] tuple) {
        return this.baseEngine_.getBins(this.unwrapTuple(tuple));
    }

    public double matchScore(Object[] tuple1, Object[] tuple2) {
        return this.scoreWrapper_.wrapDouble(this.baseEngine_.matchScore(this.unwrapTuple(tuple1), this.unwrapTuple(tuple2)));
    }

    public double getScoreScale() {
        return this.scoreWrapper_.wrapDouble(this.baseEngine_.getScoreScale());
    }

    public ValueInfo getMatchScoreInfo() {
        return this.scoreInfo_;
    }

    public boolean canBoundMatch() {
        return this.baseEngine_.canBoundMatch();
    }

    public NdRange getMatchBounds(NdRange[] inRanges, int index) {
        int nr = inRanges.length;
        NdRange[] unwrappedInRanges = new NdRange[nr];
        for (int ir = 0; ir < nr; ++ir) {
            NdRange inRng = inRanges[ir];
            unwrappedInRanges[ir] = new NdRange(this.toComparables(this.unwrapTuple(inRng.getMins())), this.toComparables(this.unwrapTuple(inRng.getMaxs())));
        }
        NdRange unwrappedResult = this.baseEngine_.getMatchBounds(unwrappedInRanges, index);
        return new NdRange(this.toComparables(this.wrapTuple(unwrappedResult.getMins())), this.toComparables(this.wrapTuple(unwrappedResult.getMaxs())));
    }

    private Object[] unwrapTuple(Object[] wrapped) {
        Object[] unwrapped = new Object[this.nval_];
        for (int i = 0; i < this.nval_; ++i) {
            unwrapped[i] = this.tupleWrappers_[i].unwrapValue(wrapped[i]);
        }
        return unwrapped;
    }

    private Object[] wrapTuple(Object[] unwrapped) {
        Object[] wrapped = new Object[this.nval_];
        for (int i = 0; i < this.nval_; ++i) {
            wrapped[i] = this.tupleWrappers_[i].wrapValue(unwrapped[i]);
        }
        return wrapped;
    }

    private Comparable[] toComparables(Object[] objs) {
        Comparable[] comps = new Comparable[objs.length];
        for (int i = 0; i < comps.length; ++i) {
            comps[i] = objs[i] instanceof Comparable ? (Comparable)objs[i] : null;
        }
        return comps;
    }

    private ValueWrapper createWrapper(ValueInfo info) {
        Class clazz;
        String units = info == null ? null : info.getUnitString();
        Class clazz2 = clazz = info == null ? null : info.getContentClass();
        if (("radians".equals(units) || "radian".equals(units)) && (clazz == Double.class || clazz == Number.class)) {
            if (this.isSmallAngle(info)) {
                return new DoubleFactorWrapper(4.84813681109536E-6, "arcsec");
            }
            if (this.isLargeAngle(info)) {
                return new DoubleFactorWrapper(Math.PI / 180, "degrees");
            }
            logger_.warning("Unknown angular quantity " + info + " - convert to degrees");
            return new DoubleFactorWrapper(Math.PI / 180, "degrees");
        }
        return NULL_WRAPPER;
    }

    public boolean isLargeAngle(ValueInfo info) {
        String ucd = info.getUCD();
        if (ucd == null) {
            return false;
        }
        String lucd = ucd.toLowerCase();
        return lucd.matches("pos[\\._](eq|az|earth|ecliptic|galactic|supergalactic)[\\._].*") || lucd.startsWith("pos.posAng".toLowerCase());
    }

    public boolean isSmallAngle(ValueInfo info) {
        String ucd = info.getUCD();
        if (ucd == null) {
            return false;
        }
        String lucd = ucd.toLowerCase();
        return lucd.startsWith("pos.angDistance".toLowerCase()) || lucd.startsWith("pos.angResolution".toLowerCase()) || lucd.startsWith("phys.angSize".toLowerCase());
    }

    private static class DoubleFactorWrapper
    extends ValueWrapper {
        final double factor_;
        final String units_;

        DoubleFactorWrapper(double factor, String units) {
            this.factor_ = factor;
            this.units_ = units;
        }

        @Override
        public Object wrapValue(Object value) {
            return value instanceof Number ? new Double(((Number)value).doubleValue() / this.factor_) : null;
        }

        @Override
        public Object unwrapValue(Object value) {
            return value instanceof Number ? new Double(((Number)value).doubleValue() * this.factor_) : null;
        }

        @Override
        public double wrapDouble(double value) {
            return value / this.factor_;
        }

        @Override
        public ValueInfo wrapValueInfo(ValueInfo info) {
            DefaultValueInfo vinfo = new DefaultValueInfo(info);
            vinfo.setUnitString(this.units_);
            return vinfo;
        }

        @Override
        public DescribedValue wrapDescribedValue(final DescribedValue dval) {
            return new DescribedValue(this.wrapValueInfo(dval.getInfo()), this.wrapValue(dval.getValue())){

                public Object getValue() {
                    return DoubleFactorWrapper.this.wrapValue(dval.getValue());
                }

                public void setValue(Object value) {
                    dval.setValue(DoubleFactorWrapper.this.unwrapValue(value));
                }
            };
        }
    }

    private static abstract class ValueWrapper {
        private ValueWrapper() {
        }

        public abstract Object unwrapValue(Object var1);

        public abstract Object wrapValue(Object var1);

        public abstract double wrapDouble(double var1);

        public abstract ValueInfo wrapValueInfo(ValueInfo var1);

        public abstract DescribedValue wrapDescribedValue(DescribedValue var1);
    }
}

