/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.join;

import java.io.IOException;
import java.util.logging.Logger;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.Match1Type;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.RowMatcher;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.jel.JELTable;
import uk.ac.starlink.ttools.task.SingleTableMapping;

public class Match1Mapping
implements SingleTableMapping {
    private final MatchEngine matchEngine_;
    private final Match1Type type1_;
    private final String[] tupleExprs_;
    private final ProgressIndicator progger_;
    private static final Logger logger = Logger.getLogger("uk.ac.starlink.ttools.join");

    public Match1Mapping(MatchEngine matchEngine, Match1Type type1, String[] tupleExprs, ProgressIndicator progger) {
        this.matchEngine_ = matchEngine;
        this.type1_ = type1;
        this.tupleExprs_ = (String[])tupleExprs.clone();
        this.progger_ = progger;
    }

    @Override
    public StarTable map(StarTable inTable) throws TaskException, IOException {
        LinkSet matches;
        ValueInfo[] tupleInfos = this.matchEngine_.getTupleInfos();
        JELTable.createJELTable(inTable, tupleInfos, this.tupleExprs_);
        inTable = Tables.randomTable((StarTable)inTable);
        StarTable subTable = JELTable.createJELTable(inTable, tupleInfos, this.tupleExprs_);
        RowMatcher matcher = new RowMatcher(this.matchEngine_, new StarTable[]{subTable});
        matcher.setIndicator(this.progger_);
        try {
            matches = matcher.findInternalMatches(false);
        }
        catch (InterruptedException e) {
            throw new ExecutionException("Match was interrupted", (Throwable)e);
        }
        if (!matches.sort()) {
            logger.warning("Can't sort matches - matched table rows may be in an unhelpful order");
        }
        int matchCount = matches.size();
        logger.info(matchCount + " matches found");
        if (matchCount == 0) {
            throw new ExecutionException("No matches were found");
        }
        return this.type1_.createMatchTable(inTable, matches);
    }
}

