/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.join;

import java.io.IOException;
import java.util.logging.Logger;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.join.JoinType;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.MatchStarTables;
import uk.ac.starlink.table.join.PairMode;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.RowMatcher;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.jel.JELTable;
import uk.ac.starlink.ttools.task.InputTableSpec;
import uk.ac.starlink.ttools.task.TableMapping;

public class Match2Mapping
implements TableMapping {
    final String[] exprTuple1_;
    final String[] exprTuple2_;
    final JoinFixAction[] fixacts_;
    final MatchEngine matchEngine_;
    final PairMode pairMode_;
    final JoinType join_;
    final ValueInfo scoreInfo_;
    final ProgressIndicator progger_;
    private static final Logger logger = Logger.getLogger("uk.ac.starlink.ttools.task");

    Match2Mapping(MatchEngine matchEngine, String[] exprTuple1, String[] exprTuple2, JoinType join, PairMode pairMode, JoinFixAction fixact1, JoinFixAction fixact2, ValueInfo scoreInfo, ProgressIndicator progger) {
        this.matchEngine_ = matchEngine;
        this.exprTuple1_ = exprTuple1;
        this.exprTuple2_ = exprTuple2;
        this.join_ = join;
        this.pairMode_ = pairMode;
        this.fixacts_ = new JoinFixAction[]{fixact1, fixact2};
        this.scoreInfo_ = scoreInfo;
        this.progger_ = progger;
    }

    @Override
    public StarTable mapTables(InputTableSpec[] inSpecs) throws IOException, TaskException {
        LinkSet matches;
        StarTable inTable1 = inSpecs[0].getWrappedTable();
        StarTable inTable2 = inSpecs[1].getWrappedTable();
        this.makeSubTable(inTable1, this.exprTuple1_);
        this.makeSubTable(inTable2, this.exprTuple2_);
        inTable1 = Tables.randomTable((StarTable)inTable1);
        inTable2 = Tables.randomTable((StarTable)inTable2);
        StarTable subTable1 = this.makeSubTable(inTable1, this.exprTuple1_);
        StarTable subTable2 = this.makeSubTable(inTable2, this.exprTuple2_);
        RowMatcher matcher = new RowMatcher(this.matchEngine_, new StarTable[]{subTable1, subTable2});
        matcher.setIndicator(this.progger_);
        try {
            matches = matcher.findPairMatches(this.pairMode_);
            if (!matches.sort()) {
                logger.warning("Implementation can't sort rows - matched table rows may not be ordered");
            }
        }
        catch (InterruptedException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        boolean addGroups = this.pairMode_.mayProduceGroups();
        return MatchStarTables.makeJoinTable((StarTable)inTable1, (StarTable)inTable2, (LinkSet)matches, (JoinType)this.join_, (boolean)addGroups, (JoinFixAction[])this.fixacts_, (ValueInfo)this.scoreInfo_);
    }

    protected StarTable makeSubTable(StarTable inTable, String[] exprTuple) throws ExecutionException {
        return JELTable.createJELTable(inTable, this.matchEngine_.getTupleInfos(), exprTuple);
    }
}

