/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.join;

import java.io.IOException;
import java.util.logging.Logger;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.join.LinkSet;
import uk.ac.starlink.table.join.MatchEngine;
import uk.ac.starlink.table.join.MatchStarTables;
import uk.ac.starlink.table.join.MultiJoinType;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.RowMatcher;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.ExecutionException;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.jel.JELTable;
import uk.ac.starlink.ttools.join.MatchEngineParameter;
import uk.ac.starlink.ttools.join.ProgressIndicatorParameter;
import uk.ac.starlink.ttools.task.InputTableSpec;
import uk.ac.starlink.ttools.task.JoinFixActionParameter;
import uk.ac.starlink.ttools.task.TableMapper;
import uk.ac.starlink.ttools.task.TableMapping;
import uk.ac.starlink.ttools.task.WordsParameter;

public class MatchMapper
implements TableMapper {
    private final MatchEngineParameter matcherParam_;
    private final JoinFixActionParameter fixcolsParam_;
    private final ChoiceParameter<String> mmodeParam_;
    private final IntegerParameter irefParam_ = new IntegerParameter("iref");
    private final ProgressIndicatorParameter progressParam_;
    private static final String PAIRS_MODE = "pairs";
    private static final String GROUP_MODE = "group";
    private static final Logger logger = Logger.getLogger("uk.ac.starlink.ttools.join");

    public MatchMapper() {
        this.irefParam_.setPrompt("Index of reference table in pairs mode");
        this.irefParam_.setUsage("<table-index>");
        this.irefParam_.setIntDefault(1);
        this.mmodeParam_ = new ChoiceParameter("multimode", (Object[])new String[]{PAIRS_MODE, GROUP_MODE});
        this.mmodeParam_.setPrompt("Semantics of multi-table match");
        this.mmodeParam_.setStringDefault(PAIRS_MODE);
        this.irefParam_.setDescription(new String[]{"<p>If <code>" + this.mmodeParam_.getName() + "</code>" + "=<code>" + PAIRS_MODE + "</code>", "this parameter gives the index of the table in the input table", "list which is to serve as the reference table", "(the one which must be matched by other tables).", "Ignored in other modes.", "</p>", "<p>Row ordering in the output table is usually tidiest", "if the default setting of 1 is used", "(i.e. if the first input table is used as the reference table).", "</p>"});
        this.mmodeParam_.setDescription(new String[]{"<p>Defines what is meant by a multi-table match.", "There are two possibilities:", "<ul>", "<li><code>pairs</code>:", "Each output row corresponds to a single row of the", "<em>reference table</em>", "(see parameter <code>" + this.irefParam_.getName() + "</code>)", "and contains entries from other tables which are pair matches", "to that.", "If a reference table row matches multiple rows from one of", "the other tables, only the best one is included.", "</li>", "<li><code>group</code>:", "Each output row corresponds to a group of entries from the", "input tables which are", "mutually linked by pair matches between them.", "This means that although you can get from any entry to any", "other entry via one or more pair matches,", "there is no guarantee that any entry", "is a pair match with any other entry.", "No table has privileged status in this case.", "If there are multiple entries from a given table in the", "match group, an arbitrary one is chosen for inclusion", "(there is no unique way to select the best).", "See <ref id='matchGroup'/> for more discussion.", "</li>", "</ul>", "In the case of well-separated objects these modes will give", "the same results.  For crowded fields however it will make", "a difference which is chosen.", "</p>", "<p>Note that which rows actually appear in the output", "is also influenced by the", "<code>" + new MultiJoinTypeParameter("N").getName() + "</code>", "parameter.", "</p>"});
        this.matcherParam_ = new MatchEngineParameter("matcher");
        this.fixcolsParam_ = new JoinFixActionParameter("fixcols");
        this.progressParam_ = new ProgressIndicatorParameter("progress");
    }

    @Override
    public Parameter[] getParameters() {
        return new Parameter[]{this.mmodeParam_, this.irefParam_, this.matcherParam_, this.matcherParam_.getMatchParametersParameter(), this.matcherParam_.getTuningParametersParameter(), this.matcherParam_.createMatchTupleParameter("N"), new MultiJoinTypeParameter("N"), this.fixcolsParam_, this.fixcolsParam_.createSuffixParameter("N"), this.progressParam_};
    }

    @Override
    public TableMapping createMapping(Environment env, int nin) throws TaskException {
        int iref;
        String mmode = this.mmodeParam_.stringValue(env);
        if (PAIRS_MODE.equalsIgnoreCase(mmode)) {
            this.irefParam_.setMinimum(1);
            this.irefParam_.setMaximum(nin);
            iref = this.irefParam_.intValue(env) - 1;
        } else {
            iref = -1;
        }
        MatchEngine matcher = this.matcherParam_.matchEngineValue(env);
        String[][] exprTuples = new String[nin][];
        JoinFixAction[] fixActs = new JoinFixAction[nin];
        MultiJoinType[] joinTypes = new MultiJoinType[nin];
        for (int i = 0; i < nin; ++i) {
            String numLabel = Integer.toString(i + 1);
            WordsParameter tupleParam = this.matcherParam_.createMatchTupleParameter(numLabel);
            MatchEngineParameter.configureTupleParameter(tupleParam, matcher);
            exprTuples[i] = tupleParam.wordsValue(env);
            StringParameter suffixParam = this.fixcolsParam_.createSuffixParameter(numLabel);
            fixActs[i] = this.fixcolsParam_.getJoinFixAction(env, suffixParam);
            joinTypes[i] = (MultiJoinType)new MultiJoinTypeParameter(numLabel).objectValue(env);
        }
        ProgressIndicator progger = this.progressParam_.progressIndicatorValue(env);
        if (GROUP_MODE.equalsIgnoreCase(mmode)) {
            return new GroupMatchMapping(matcher, exprTuples, fixActs, progger, joinTypes);
        }
        if (PAIRS_MODE.equalsIgnoreCase(mmode)) {
            return new PairsMatchMapping(matcher, exprTuples, fixActs, progger, iref, joinTypes);
        }
        throw new AssertionError((Object)("Unknown multimode " + mmode + "???"));
    }

    private static class MultiJoinTypeParameter
    extends ChoiceParameter<MultiJoinType> {
        public MultiJoinTypeParameter(String numLabel) {
            super("join" + numLabel, (Object[])new MultiJoinType[]{MultiJoinType.DEFAULT, MultiJoinType.MATCH, MultiJoinType.NOMATCH, MultiJoinType.ALWAYS});
            boolean hasNum = numLabel != null && numLabel.length() > 0;
            String prompt = "Output row selection criteria";
            if (hasNum) {
                prompt = prompt + " from table " + numLabel;
            }
            this.setPrompt(prompt);
            this.setDefaultOption(MultiJoinType.DEFAULT);
            this.setDescription(new String[]{"<p>Determines which rows", hasNum ? "from input table " + numLabel : "", "are included in the output table.", "The matching algorithm determines which of the rows in", "each of the input tables correspond to which rows in", "the other input tables, and this parameter determines", "what to do with that information.", "</p>", "<p>The default behaviour is that a row will appear in the", "output table if it represents a match of rows from two or", "more of the input tables.", "This can be altered on a per-input-table basis however", "by choosing one of the non-default options below:", "<ul>", "<li><code>" + MultiJoinType.MATCH + "</code>:", "Rows are included only if they contain an entry from", "input table " + numLabel + ".", "</li>", "<li><code>" + MultiJoinType.NOMATCH + "</code>:", "Rows are included only if they do not contain an entry from", "input table " + numLabel + ".", "</li>", "<li><code>" + MultiJoinType.ALWAYS + "</code>:", "Rows are included if they contain an entry from", "input table " + numLabel, "(overrides any " + MultiJoinType.MATCH + " and " + MultiJoinType.NOMATCH, "settings of other tables).", "</li>", "<li><code>" + MultiJoinType.DEFAULT + "</code>:", "Input table " + numLabel + " has no special effect on", "whether rows are included.", "</li>", "</ul>", "</p>"});
        }
    }

    private static class GroupMatchMapping
    extends MatchMapping {
        private final MultiJoinType[] joinTypes_;

        GroupMatchMapping(MatchEngine matchEngine, String[][] exprTuples, JoinFixAction[] fixActs, ProgressIndicator progger, MultiJoinType[] joinTypes) {
            super(matchEngine, exprTuples, fixActs, progger);
            this.joinTypes_ = joinTypes;
        }

        @Override
        protected LinkSet findMatches(RowMatcher matcher) throws IOException, InterruptedException {
            return matcher.findGroupMatches(this.joinTypes_);
        }

        @Override
        protected StarTable createJoinTable(StarTable[] inTables, LinkSet matches, JoinFixAction[] fixActs) {
            return MatchStarTables.makeJoinTable((StarTable[])inTables, (LinkSet)matches, (boolean)false, (JoinFixAction[])fixActs, null);
        }
    }

    private static class PairsMatchMapping
    extends MatchMapping {
        private final int iref_;
        private final MultiJoinType[] joinTypes_;

        PairsMatchMapping(MatchEngine matchEngine, String[][] exprTuples, JoinFixAction[] fixActs, ProgressIndicator progger, int iref, MultiJoinType[] joinTypes) {
            super(matchEngine, exprTuples, fixActs, progger);
            this.iref_ = iref;
            this.joinTypes_ = joinTypes;
        }

        @Override
        protected LinkSet findMatches(RowMatcher matcher) throws IOException, InterruptedException {
            return matcher.findMultiPairMatches(this.iref_, true, this.joinTypes_);
        }

        @Override
        protected StarTable createJoinTable(StarTable[] inTables, LinkSet matches, JoinFixAction[] fixActs) {
            return MatchStarTables.makeJoinTable((StarTable[])inTables, (LinkSet)matches, (boolean)false, (JoinFixAction[])fixActs, null);
        }
    }

    private static abstract class MatchMapping
    implements TableMapping {
        private final int nin_;
        private final MatchEngine matchEngine_;
        private final String[][] exprTuples_;
        private final JoinFixAction[] fixActs_;
        private final ProgressIndicator progger_;

        MatchMapping(MatchEngine matchEngine, String[][] exprTuples, JoinFixAction[] fixActs, ProgressIndicator progger) {
            this.matchEngine_ = matchEngine;
            this.exprTuples_ = exprTuples;
            this.fixActs_ = fixActs;
            this.progger_ = progger;
            this.nin_ = this.exprTuples_.length;
        }

        @Override
        public StarTable mapTables(InputTableSpec[] inSpecs) throws IOException, TaskException {
            LinkSet matches;
            StarTable[] inTables = new StarTable[this.nin_];
            for (int i = 0; i < this.nin_; ++i) {
                inTables[i] = inSpecs[i].getWrappedTable();
                this.makeSubTable(inTables[i], this.exprTuples_[i]);
            }
            StarTable[] subTables = new StarTable[this.nin_];
            for (int i = 0; i < this.nin_; ++i) {
                inTables[i] = Tables.randomTable((StarTable)inTables[i]);
                subTables[i] = this.makeSubTable(inTables[i], this.exprTuples_[i]);
            }
            RowMatcher matcher = new RowMatcher(this.matchEngine_, subTables);
            matcher.setIndicator(this.progger_);
            try {
                matches = this.findMatches(matcher);
                if (!matches.sort()) {
                    logger.warning("Implementation can't sort rows - matched table rows may not be sorted");
                }
            }
            catch (InterruptedException e) {
                throw new ExecutionException(e.getMessage(), (Throwable)e);
            }
            return this.createJoinTable(inTables, matches, this.fixActs_);
        }

        protected abstract LinkSet findMatches(RowMatcher var1) throws IOException, InterruptedException;

        protected abstract StarTable createJoinTable(StarTable[] var1, LinkSet var2, JoinFixAction[] var3) throws IOException;

        private StarTable makeSubTable(StarTable inTable, String[] exprTuple) throws ExecutionException {
            return JELTable.createJELTable(inTable, this.matchEngine_.getTupleInfos(), exprTuple);
        }
    }
}

