/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.join;

import java.io.PrintStream;
import uk.ac.starlink.table.join.NullProgressIndicator;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.TextProgressIndicator;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.TaskException;

public class ProgressIndicatorParameter
extends ChoiceParameter<String> {
    private static final String NONE = "none";
    private static final String LOG = "log";
    private static final String PROFILE = "profile";

    public ProgressIndicatorParameter(String name) {
        super(name, (Object[])new String[]{NONE, LOG, PROFILE});
        this.setPrompt("How to report progress to screen");
        this.setStringDefault(LOG);
        this.setDescription(new String[]{"<p>Determines whether information on progress of the match", "should be output to the standard error stream as it progresses.", "For lengthy matches this is a useful reassurance and can give", "guidance about how much longer it will take.", "It can also be useful as a performance diagnostic.", "</p>", "<p>The options are:", "<ul>", "<li><code>none</code>:", "no progress is shown", "</li>", "<li><code>log</code>:", "progress information is shown", "</li>", "<li><code>profile</code>:", "progress information and limited time/memory profiling", "information are shown", "</li>", "</ul>", "</p>"});
    }

    public ProgressIndicator progressIndicatorValue(Environment env) throws TaskException {
        return this.stringToProgressIndicator(env, (String)this.objectValue(env));
    }

    public String stringToObject(Environment env, String sval) throws TaskException {
        this.stringToProgressIndicator(env, sval);
        return sval;
    }

    private ProgressIndicator stringToProgressIndicator(Environment env, String sval) throws TaskException {
        PrintStream strm = env.getErrorStream();
        if (strm != null) {
            if (LOG.equals(sval)) {
                return new TextProgressIndicator(strm, false);
            }
            if (PROFILE.equals(sval)) {
                return new TextProgressIndicator(strm, true);
            }
        }
        return new NullProgressIndicator();
    }
}

