/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.join;

import java.io.PrintStream;
import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.table.join.FixedSkyMatchEngine;
import uk.ac.starlink.table.join.JoinType;
import uk.ac.starlink.table.join.NullProgressIndicator;
import uk.ac.starlink.table.join.PairMode;
import uk.ac.starlink.table.join.PixtoolsHealpixSkyPixellator;
import uk.ac.starlink.table.join.ProgressIndicator;
import uk.ac.starlink.table.join.SkyPixellator;
import uk.ac.starlink.table.join.TextProgressIndicator;
import uk.ac.starlink.task.DoubleParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.join.FindModeParameter;
import uk.ac.starlink.ttools.join.JoinTypeParameter;
import uk.ac.starlink.ttools.join.SkyMatch2Mapping;
import uk.ac.starlink.ttools.task.SkyCoordParameter;
import uk.ac.starlink.ttools.task.TableMapper;
import uk.ac.starlink.ttools.task.TableMapping;

public class SkyMatch2Mapper
implements TableMapper {
    private final Parameter[] raParams_ = new Parameter[2];
    private final Parameter[] decParams_ = new Parameter[2];
    private final DoubleParameter errorParam_;
    private final JoinTypeParameter joinParam_;
    private final FindModeParameter modeParam_;
    private final IntegerParameter healpixkParam_;

    public SkyMatch2Mapper() {
        for (int i = 0; i < 2; ++i) {
            int i1 = i + 1;
            this.raParams_[i] = SkyCoordParameter.createRaParameter("ra" + i1, null, "table " + i1);
            this.decParams_[i] = SkyCoordParameter.createDecParameter("dec" + i1, null, "table " + i1);
        }
        this.errorParam_ = new DoubleParameter("error");
        this.errorParam_.setUsage("<value/arcsec>");
        this.errorParam_.setPrompt("Maximum separation in arcsec");
        this.errorParam_.setDescription(new String[]{"<p>The maximum separation permitted between two objects", "for them to count as a match.  Units are arc seconds.", "</p>"});
        this.healpixkParam_ = new IntegerParameter("tuning");
        this.healpixkParam_.setUsage("<healpix-k>");
        this.healpixkParam_.setPrompt("HEALPix pixel size parameter");
        this.healpixkParam_.setDescription(new String[]{"<p>Tuning parameter that controls the pixel size used when", "binning the rows.", "The legal range is from", "0 (corresponding to pixel size of about 60 degrees) to", "20 (about 0.2 arcsec).", "The value of this parameter will not affect the result", "but may affect the performance in terms of CPU and memory", "resources required.", "A default value will be chosen based on the size of the", "<code>" + this.errorParam_.getName() + "</code>", "parameter, but it may be possible to improve performance by", "adjusting the default value.", "The value used can be seen by examining the progress output.", "If your match is taking a long time or is failing from lack", "of memory it may be worth trying different values", "for this parameter.", "</p>"});
        this.healpixkParam_.setNullPermitted(true);
        this.healpixkParam_.setMinimum(0);
        this.healpixkParam_.setMaximum(20);
        this.joinParam_ = new JoinTypeParameter("join");
        this.modeParam_ = new FindModeParameter("find");
    }

    @Override
    public Parameter[] getParameters() {
        return new Parameter[]{this.raParams_[0], this.decParams_[0], this.raParams_[1], this.decParams_[1], this.errorParam_, this.healpixkParam_, this.joinParam_, this.modeParam_};
    }

    @Override
    public TableMapping createMapping(Environment env, int nin) throws TaskException {
        String ra1 = this.raParams_[0].stringValue(env);
        String dec1 = this.decParams_[0].stringValue(env);
        String ra2 = this.raParams_[1].stringValue(env);
        String dec2 = this.decParams_[1].stringValue(env);
        double error = this.errorParam_.doubleValue(env) * 4.84813681109536E-6;
        if (error < 0.0) {
            throw new ParameterValueException((Parameter)this.errorParam_, "Negative value illegal");
        }
        PixtoolsHealpixSkyPixellator pixer = new PixtoolsHealpixSkyPixellator();
        FixedSkyMatchEngine matcher = new FixedSkyMatchEngine((SkyPixellator)pixer, error);
        int defk = pixer.getHealpixK();
        if (defk >= 0) {
            this.healpixkParam_.setIntDefault(defk);
        }
        int k = this.healpixkParam_.intValue(env);
        pixer.setHealpixK(k);
        JoinType join = this.joinParam_.joinTypeValue(env);
        PairMode pairMode = (PairMode)this.modeParam_.objectValue(env);
        JoinFixAction fixact1 = JoinFixAction.makeRenameDuplicatesAction((String)"_1", (boolean)false, (boolean)true);
        JoinFixAction fixact2 = JoinFixAction.makeRenameDuplicatesAction((String)"_2", (boolean)false, (boolean)true);
        PrintStream err = env.getErrorStream();
        NullProgressIndicator progger = err == null ? new NullProgressIndicator() : new TextProgressIndicator(err, false);
        return new SkyMatch2Mapping(matcher, ra1, dec1, ra2, dec2, join, pairMode, fixact1, fixact2, (ProgressIndicator)progger);
    }
}

