/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import cds.tools.ExtApp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.filter.AddColumnsTable;
import uk.ac.starlink.ttools.filter.JELColumnSupplement;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.votable.VOTableWriter;

public class ExtAppMode
implements ProcessingMode {
    private final StringParameter selParam_ = new StringParameter("select");
    private final StringParameter showParam_;
    private final BooleanParameter visParam_;

    public ExtAppMode() {
        this.selParam_.setUsage("<expr>");
        this.selParam_.setNullPermitted(true);
        this.showParam_ = new StringParameter("show");
        this.showParam_.setUsage("<expr>");
        this.showParam_.setNullPermitted(true);
        this.visParam_ = new BooleanParameter("visible");
        this.visParam_.setNullPermitted(true);
    }

    @Override
    public Parameter[] getAssociatedParameters() {
        return new Parameter[]{this.selParam_, this.showParam_, this.visParam_};
    }

    @Override
    public String getDescription() {
        return DocUtils.join(new String[]{"<p>Talks to TOPCAT as a CDS-style <code>ExtApp</code>,", "used for TOPCAT ExtApp implementation testing purposes.", "</p>", "<p>ExtApp functionality is moribund, having more or less", "been superceded by PLASTIC.", "</p>"});
    }

    @Override
    public TableConsumer createConsumer(Environment env) throws TaskException {
        final String selExpr = this.selParam_.stringValue(env);
        final String showExpr = this.showParam_.stringValue(env);
        final Boolean vis = (Boolean)this.visParam_.objectValue(env);
        return new TableConsumer(){

            @Override
            public void consume(StarTable table) throws IOException {
                table = ExtAppMode.this.doctor(table);
                ByteArrayOutputStream ostrm = new ByteArrayOutputStream();
                new StarTableOutput().writeStarTable(table, (OutputStream)ostrm, (StarTableWriter)new VOTableWriter());
                ByteArrayInputStream istrm = new ByteArrayInputStream(ostrm.toByteArray());
                ExtAppMode.this.getExtApp().loadVOTable(new DummyExtApp(), istrm);
                if (selExpr != null) {
                    String[] selIds = ExtAppMode.this.getSelectedIds(table, selExpr);
                    ExtAppMode.this.getExtApp().selectVOTableObject(selIds);
                }
                if (showExpr != null) {
                    String[] showIds = ExtAppMode.this.getSelectedIds(table, showExpr);
                    ExtAppMode.this.getExtApp().showVOTableObject(showIds);
                }
                if (vis != null) {
                    ExtAppMode.this.getExtApp().setVisible(vis);
                }
            }
        };
    }

    private StarTable doctor(StarTable table) throws IOException {
        JELColumnSupplement oidSup = new JELColumnSupplement(table, "\"id_\"+$0", new ColumnInfo("_OID"));
        return new AddColumnsTable(table, oidSup);
    }

    private String[] getSelectedIds(StarTable table, String selexpr) throws IOException {
        int idcol = table.getColumnCount() - 1;
        ColumnInfo flagInfo = new ColumnInfo("flag", Boolean.class, null);
        table = new AddColumnsTable((StarTable)table, new JELColumnSupplement((StarTable)table, selexpr, flagInfo));
        int flagcol = table.getColumnCount() - 1;
        ArrayList<Object> idList = new ArrayList<Object>();
        RowSequence rseq = table.getRowSequence();
        while (rseq.next()) {
            if (!((Boolean)rseq.getCell(flagcol)).booleanValue()) continue;
            idList.add(rseq.getCell(idcol));
        }
        rseq.close();
        return idList.toArray(new String[0]);
    }

    private ExtApp getExtApp() throws IOException {
        try {
            Object controlWindow = Class.forName("uk.ac.starlink.topcat.ControlWindow").getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            return (ExtApp)controlWindow.getClass().getMethod("getExtApp", new Class[0]).invoke(controlWindow, new Object[0]);
        }
        catch (Throwable e) {
            throw (IOException)new IOException("Can't get ExtApp").initCause(e);
        }
    }

    private static class DummyExtApp
    implements ExtApp {
        private DummyExtApp() {
        }

        @Override
        public void loadVOTable(ExtApp app, InputStream istrm) {
        }

        @Override
        public void setVisible(boolean flag) {
        }

        @Override
        public String execCommand(String cmd) {
            return "No action";
        }

        @Override
        public void showVOTableObject(String[] oids) {
        }

        @Override
        public void selectVOTableObject(String[] oids) {
        }

        public String toString() {
            return "STILTS";
        }
    }
}

