/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import cds.moc.HealpixMoc;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.OutputStreamParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.StringParameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.cone.ConeQueryRowSequence;
import uk.ac.starlink.ttools.cone.JELQuerySequenceFactory;
import uk.ac.starlink.ttools.cone.MocFormat;
import uk.ac.starlink.ttools.cone.PixtoolsHealpix;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.task.SkyCoordParameter;
import uk.ac.starlink.util.Destination;

public class MocMode
implements ProcessingMode {
    private final IntegerParameter orderParam_ = new IntegerParameter("order");
    private final StringParameter raParam_;
    private final StringParameter decParam_;
    private final StringParameter radiusParam_;
    private final ChoiceParameter<MocFormat> mocfmtParam_;
    private final OutputStreamParameter outParam_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.mode");
    public static final MocFormat FITS_FORMAT = new CdsMocFormat("fits"){

        @Override
        protected void doWrite(HealpixMoc moc, OutputStream out) throws Exception {
            moc.writeFits(out);
        }
    };
    public static final MocFormat JSON_FORMAT = new CdsMocFormat("json"){

        @Override
        protected void doWrite(HealpixMoc moc, OutputStream out) throws Exception {
            moc.writeJSON(out);
        }
    };

    public MocMode() {
        this.orderParam_.setPrompt("MOC Healpix maximum order");
        this.orderParam_.setMinimum(1);
        this.orderParam_.setMaximum(29);
        this.orderParam_.setDescription(new String[]{"<p>Maximum HEALPix order for the MOC.", "This defines the maximum resolution of the output coverage map.", "The angular resolution corresponding to order <em>k</em>", "is approximately 180/sqrt(3.Pi)/2^<em>k</em>", "(3520*2^<em>-k</em> arcmin).", "</p>"});
        this.orderParam_.setIntDefault(13);
        String system = null;
        String inDescrip = "the input table";
        this.raParam_ = SkyCoordParameter.createRaParameter("ra", system, inDescrip);
        this.decParam_ = SkyCoordParameter.createDecParameter("dec", system, inDescrip);
        this.radiusParam_ = new StringParameter("radius");
        this.radiusParam_.setUsage("<expr>");
        this.radiusParam_.setPrompt("Radius expression in degrees");
        this.radiusParam_.setDescription(new String[]{"<p>Expression which evaluates to the radius in degrees", "of the cone at each row of the input table.", "The default is \"<code>0</code>\",", "which treats each position as a point rather than a cone,", "but a constant or an expression as described in", "<ref id='jel'/> may be used instead.", "</p>"});
        this.radiusParam_.setStringDefault("0");
        this.mocfmtParam_ = new ChoiceParameter("mocfmt", MocFormat.class, (Object[])new MocFormat[]{FITS_FORMAT, JSON_FORMAT});
        this.mocfmtParam_.setPrompt("Output format for MOC file");
        this.mocfmtParam_.setDescription(new String[]{"<p>Determines the output format for the MOC file.", "</p>"});
        this.mocfmtParam_.setDefaultOption((Object)FITS_FORMAT);
        this.outParam_ = new OutputStreamParameter("out");
        this.outParam_.setPreferExplicit(true);
        this.outParam_.setPrompt("Location of output MOC file");
    }

    @Override
    public Parameter[] getAssociatedParameters() {
        return new Parameter[]{this.orderParam_, this.raParam_, this.decParam_, this.radiusParam_, this.mocfmtParam_, this.outParam_};
    }

    @Override
    public String getDescription() {
        return DocUtils.join(new String[]{"<p>Generates a Multi-Order Coverage map from the sky positions", "associated with the rows of the input table,", "and writes it out to a FITS or JSON file.", "</p>"});
    }

    @Override
    public TableConsumer createConsumer(Environment env) throws TaskException {
        String raString = this.raParam_.stringValue(env);
        String decString = this.decParam_.stringValue(env);
        String radiusString = this.radiusParam_.stringValue(env);
        final JELQuerySequenceFactory qsFact = new JELQuerySequenceFactory(raString, decString, radiusString);
        final int order = this.orderParam_.intValue(env);
        final MocFormat mocfmt = (MocFormat)this.mocfmtParam_.objectValue(env);
        final Destination dest = (Destination)this.outParam_.objectValue(env);
        return new TableConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void consume(StarTable table) throws IOException {
                HealpixMoc moc;
                ConeQueryRowSequence qseq = qsFact.createQuerySequence(table);
                try {
                    moc = MocMode.createMoc(order, qseq);
                }
                finally {
                    qseq.close();
                }
                if (logger_.isLoggable(Level.INFO)) {
                    logger_.info("MOC: size=" + moc.getSize() + ", coverage=" + moc.getCoverage());
                }
                OutputStream out = dest.createStream();
                try {
                    mocfmt.writeMoc(moc, out);
                }
                finally {
                    out.close();
                }
            }
        };
    }

    private static HealpixMoc createMoc(int order, ConeQueryRowSequence qseq) throws IOException {
        HealpixMoc moc;
        try {
            moc = new HealpixMoc(order);
        }
        catch (Exception e) {
            throw (IOException)new IOException("Error creating MOC (bad order " + order + "?)").initCause(e);
        }
        logger_.info("New MOC order=" + order + ", resolution=" + (float)moc.getAngularRes() + "deg");
        PixtoolsHealpix healpix = PixtoolsHealpix.getInstance();
        MocMode.setChecked(moc, false);
        while (qseq.next()) {
            double ra = qseq.getRa();
            double dec = qseq.getDec();
            double radius = qseq.getRadius();
            if (Double.isNaN(ra) || !(dec >= -90.0) || !(dec <= 90.0) || !(radius >= 0.0)) continue;
            try {
                if (radius == 0.0) {
                    moc.add(order, healpix.ang2pix(order, ra, dec));
                    continue;
                }
                long[] pixels = healpix.queryDisc(order, ra, dec, radius);
                int npix = pixels.length;
                for (int ipix = 0; ipix < npix; ++ipix) {
                    moc.add(order, pixels[ipix]);
                }
            }
            catch (Exception e) {
                throw (IOException)new IOException("HEALPix/MOC error").initCause(e);
            }
        }
        MocMode.setChecked(moc, true);
        return moc;
    }

    public static void setChecked(HealpixMoc moc, boolean checked) throws IOException {
        try {
            moc.setCheckConsistencyFlag(checked);
            if (checked) {
                moc.checkAndFix();
            }
        }
        catch (Exception e) {
            throw (IOException)new IOException("MOC error").initCause(e);
        }
    }

    private static abstract class CdsMocFormat
    implements MocFormat {
        private final String name_;

        CdsMocFormat(String name) {
            this.name_ = name;
        }

        protected abstract void doWrite(HealpixMoc var1, OutputStream var2) throws Exception;

        @Override
        public void writeMoc(HealpixMoc moc, OutputStream out) throws IOException {
            try {
                this.doWrite(moc, out);
            }
            catch (Exception e) {
                throw (IOException)new IOException("MOC write error").initCause(e);
            }
        }

        public String toString() {
            return this.name_;
        }
    }
}

