/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.gui.StarJTable;
import uk.ac.starlink.table.gui.TableRowHeader;
import uk.ac.starlink.table.gui.ViewHugeSelectionModel;
import uk.ac.starlink.table.gui.ViewHugeTableModel;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.ttools.DocUtils;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.util.gui.SizingScrollPane;

public class SwingMode
implements ProcessingMode,
TableConsumer {
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.mode");

    @Override
    public TableConsumer createConsumer(Environment env) {
        return this;
    }

    @Override
    public Parameter[] getAssociatedParameters() {
        return new Parameter[0];
    }

    @Override
    public String getDescription() {
        return DocUtils.join(new String[]{"<p>Displays the table in a scrollable window.", "</p>"});
    }

    @Override
    public void consume(StarTable table) throws IOException {
        TableRowHeader rowHeader;
        long nrow = table.getRowCount();
        SizingScrollPane scroller = new SizingScrollPane();
        StarJTable jt = new StarJTable(table, false);
        DefaultListSelectionModel rowSelModel = new DefaultListSelectionModel();
        if (nrow > Integer.MAX_VALUE) {
            throw new IOException("Sorry, table is too big to view (" + nrow + " > 2^31)");
        }
        if (nrow > 0x1FFFFFFL) {
            logger_.info("Large table (" + nrow + " rows)" + ": using ViewHugeTableModel");
            JScrollBar vbar = scroller.getVerticalScrollBar();
            final ViewHugeTableModel vhModel = new ViewHugeTableModel(jt.getModel(), vbar);
            jt.setModel((TableModel)vhModel);
            ViewHugeSelectionModel vsModel = new ViewHugeSelectionModel((ListSelectionModel)rowSelModel, vhModel);
            jt.setSelectionModel((ListSelectionModel)vsModel);
            rowHeader = new TableRowHeader((JTable)jt){

                public long rowNumber(int irow) {
                    return vhModel.getHugeRow(irow) + 1;
                }
            };
            rowHeader.setLongestNumber(nrow);
            vhModel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("viewBase".equals(evt.getPropertyName())) {
                        rowHeader.repaint();
                    }
                }
            });
        } else {
            jt.setSelectionModel((ListSelectionModel)rowSelModel);
            rowHeader = new TableRowHeader((JTable)jt){

                public long rowNumber(int irow) {
                    return irow + 1;
                }
            };
        }
        scroller.setViewportView((Component)jt);
        rowHeader.installOnScroller((JScrollPane)scroller);
        StarJTable.configureColumnWidths((JTable)jt, (int)600, (int)500);
        final JFrame frame = new JFrame();
        frame.getContentPane().add((Component)scroller);
        frame.setDefaultCloseOperation(2);
        String quitKey = "quit";
        jt.getInputMap().put(KeyStroke.getKeyStroke('q'), quitKey);
        jt.getActionMap().put(quitKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                frame.dispose();
            }
        });
        frame.pack();
        frame.setVisible(true);
    }
}

