/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import javax.swing.JComponent;
import uk.ac.starlink.ttools.plot.AxisLabeller;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.Shaders;

public class AuxLegend
extends JComponent {
    private final boolean horizontal_;
    private final int iconDepth_;
    private int preLength_;
    private int postLength_;
    private Shader shader_;
    private int prefDepth_;
    private AxisLabeller labeller_;
    private boolean logFlag_;
    private boolean flipFlag_;
    private double lo_;
    private double hi_;

    public AuxLegend(boolean horizontal, int iconDepth) {
        this.horizontal_ = horizontal;
        this.iconDepth_ = iconDepth;
    }

    public void setLengthPadding(int preLength, int postLength) {
        this.preLength_ = preLength;
        this.postLength_ = postLength;
    }

    public void configure(PlotState state, int iaux) {
        Shader shader = this.shader_ = state.getValid() && state.getShaders().length > iaux ? state.getShaders()[iaux] : null;
        if (this.shader_ != null) {
            int idim = state.getMainNdim() + iaux;
            this.logFlag_ = state.getLogFlags()[idim];
            this.flipFlag_ = state.getFlipFlags()[idim];
            this.lo_ = state.getRanges()[idim][0];
            this.hi_ = state.getRanges()[idim][1];
            String label = state.getAxisLabels()[idim];
            this.labeller_ = new AxisLabeller(label, this.lo_, this.hi_, 200, this.logFlag_, !this.flipFlag_, this.getFontMetrics(this.getFont()), this.horizontal_ ? AxisLabeller.X : AxisLabeller.ANTI_Y, 6, this.preLength_, this.postLength_);
        } else {
            this.labeller_ = null;
        }
        this.fitToSize();
        this.revalidate();
        this.repaint();
    }

    public boolean isHorizontal() {
        return this.horizontal_;
    }

    private void fitToSize() {
        if (this.labeller_ != null) {
            Insets insets = this.getInsets();
            int xadd = insets.left + insets.right;
            int yadd = insets.top + insets.bottom;
            int npix = (this.horizontal_ ? this.getWidth() - xadd : this.getHeight() - yadd) - this.preLength_ - this.postLength_;
            this.labeller_.setNpix(npix);
            this.prefDepth_ = this.iconDepth_ + this.labeller_.getAnnotationBounds().height + (this.horizontal_ ? yadd : xadd);
        } else {
            this.prefDepth_ = 0;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            Color col = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(col);
        }
        if (this.labeller_ != null) {
            this.fitToSize();
            Insets insets = this.getInsets();
            int txtDepth = this.labeller_.getAnnotationBounds().height;
            int iconDepth = (this.horizontal_ ? this.getHeight() - insets.top - insets.bottom : this.getWidth() - insets.left - insets.right) - txtDepth;
            int xIcon = insets.left + (this.horizontal_ ? this.preLength_ : 0);
            int yIcon = insets.top + (this.horizontal_ ? 0 : this.preLength_);
            int xpix = this.horizontal_ ? this.labeller_.getNpix() : iconDepth;
            int ypix = this.horizontal_ ? iconDepth : this.labeller_.getNpix();
            int xLabel = xIcon + (this.horizontal_ ? 0 : xpix);
            int yLabel = yIcon + (this.horizontal_ ? ypix : 0);
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform transform = g2.getTransform();
            if (this.horizontal_) {
                g2.translate(xLabel, yLabel);
                this.labeller_.annotateAxis(g);
            } else {
                g2.translate(xLabel, yLabel);
                g2.rotate(1.5707963267948966);
                this.labeller_.annotateAxis(g2);
            }
            g2.setTransform(transform);
            Shaders.createShaderIcon(Shaders.invert(this.shader_), this.horizontal_, xpix, ypix, 0, 0).paintIcon(this, g, xIcon, yIcon);
            g.drawRect(xIcon, yIcon, xpix, ypix);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize(200);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getSize(Integer.MAX_VALUE);
    }

    @Override
    public Dimension getMinimumSize() {
        Insets insets = this.getInsets();
        return this.getSize(32 + (this.horizontal_ ? insets.left + insets.right : insets.top + insets.bottom));
    }

    private Dimension getSize(int length) {
        return this.horizontal_ ? new Dimension(length, this.prefDepth_) : new Dimension(this.prefDepth_, length);
    }

    public double fractionToData(double frac) {
        double f = this.flipFlag_ ^ !this.horizontal_ ? 1.0 - frac : frac;
        return this.logFlag_ ? Math.exp(f * Math.log(this.hi_ / this.lo_)) * this.lo_ : f * (this.hi_ - this.lo_) + this.lo_;
    }

    public Rectangle getDataBounds() {
        Rectangle box = new Rectangle(this.getBounds());
        Insets insets = this.getInsets();
        box.x += insets.left;
        box.y += insets.top;
        box.width -= insets.left + insets.right;
        box.height -= insets.top + insets.bottom;
        if (this.horizontal_) {
            box.x += this.preLength_;
            box.width -= this.preLength_ + this.postLength_;
        } else {
            box.y += this.preLength_;
            box.height -= this.preLength_ + this.postLength_;
        }
        return box;
    }
}

