/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.util.Arrays;
import uk.ac.starlink.ttools.plot.Style;

public abstract class DefaultStyle
implements Style {
    private Color color_;
    private int lineWidth_ = 1;
    private float[] dash_;
    private final Object otherAtts_;
    private static final Object DUMMY_ATTS = new Object();

    protected DefaultStyle(Color color, Object otherAtts) {
        this.otherAtts_ = otherAtts == null ? DUMMY_ATTS : otherAtts;
        this.setColor(color);
    }

    public void setColor(Color color) {
        this.color_ = color;
    }

    public Color getColor() {
        return this.color_;
    }

    public void setLineWidth(int width) {
        this.lineWidth_ = width;
    }

    public int getLineWidth() {
        return this.lineWidth_;
    }

    public void setDash(float[] dash) {
        this.dash_ = dash;
    }

    public float[] getDash() {
        return this.dash_;
    }

    public Stroke getStroke(int cap, int join) {
        int thick = this.getLineWidth();
        float[] dash = this.getDash();
        if (dash != null && thick != 1) {
            dash = (float[])dash.clone();
            int i = 0;
            while (i < dash.length) {
                int n = i++;
                dash[n] = dash[n] * (float)thick;
            }
        }
        return new BasicStroke(thick, cap, join, 10.0f, dash, 0.0f);
    }

    public Object getOtherAtts() {
        return this.otherAtts_;
    }

    public boolean equals(Object o) {
        if (o instanceof DefaultStyle) {
            DefaultStyle other = (DefaultStyle)o;
            return this.getClass().equals(other.getClass()) && this.getColor().equals(other.getColor()) && this.getLineWidth() == other.getLineWidth() && Arrays.equals(this.getDash(), other.getDash()) && this.getOtherAtts().equals(other.getOtherAtts());
        }
        return false;
    }

    public int hashCode() {
        int code = 5555;
        code = code * 23 + this.getClass().hashCode();
        code = code * 23 + this.getColor().hashCode();
        code = code * 23 + this.getStroke(0, 0).hashCode();
        code = code * 23 + this.getOtherAtts().hashCode();
        return code;
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getName()).append(this.getColor()).append(this.getOtherAtts()).toString();
    }

    public static Stroke getStroke(Stroke stroke, int cap, int join) {
        BasicStroke bstroke;
        if (stroke instanceof BasicStroke && ((bstroke = (BasicStroke)stroke).getEndCap() != cap || bstroke.getLineJoin() != join)) {
            return new BasicStroke(bstroke.getLineWidth(), cap, join, bstroke.getMiterLimit(), bstroke.getDashArray(), bstroke.getDashPhase());
        }
        return stroke;
    }
}

