/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.Shaders;
import uk.ac.starlink.ttools.plot.Style;

public abstract class DensityStyle
implements Style,
Icon {
    private final Channel channel_;
    private final float[] rgba_;
    private Shader shader_;
    private static final int ICON_WIDTH = 24;
    private static final int ICON_HEIGHT = 8;
    public static final Channel RED = new Channel("Red", 0);
    public static final Channel GREEN = new Channel("Green", 1);
    public static final Channel BLUE = new Channel("Blue", 2);

    public DensityStyle(Channel channel) {
        this.channel_ = channel;
        this.rgba_ = new float[4];
        this.shader_ = Shaders.BLACK_WHITE;
    }

    public void setShader(Shader shader) {
        assert (this.shader_.isAbsolute());
        this.shader_ = shader;
    }

    public Shader getShader() {
        return this.shader_;
    }

    public int levelBits(byte level) {
        if (this.isRGB()) {
            return (0xFF & level) << this.channel_.shift_;
        }
        this.getShader().adjustRgba(this.rgba_, (float)(0xFF & level) / 255.0f);
        return ((int)(this.rgba_[2] * 255.9f) & 0xFF) << 0 | ((int)(this.rgba_[1] * 255.9f) & 0xFF) << 8 | ((int)(this.rgba_[0] * 255.9f) & 0xFF) << 16 | ((int)(this.rgba_[3] * 255.9f) & 0xFF) << 24;
    }

    private Channel getChannel() {
        return this.channel_;
    }

    protected abstract boolean isRGB();

    @Override
    public Icon getLegendIcon() {
        return this;
    }

    @Override
    public int getIconHeight() {
        return 8;
    }

    @Override
    public int getIconWidth() {
        return 24;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g = g.create();
        int ylo = y;
        int yhi = y + 8;
        for (int i = 0; i < 24; ++i) {
            byte level = (byte)(255 * i / 24);
            g.setColor(new Color(0xFF000000 | this.levelBits(level), true));
            g.drawLine(x + i, ylo, x + i, yhi);
        }
    }

    public String toString() {
        return this.channel_.toString();
    }

    public static class Channel {
        private final String name_;
        private final int irgb_;
        private final int shift_;

        private Channel(String name, int irgb) {
            this.name_ = name;
            this.irgb_ = irgb;
            this.shift_ = 8 * (2 - irgb);
        }

        public String toString() {
            return this.name_;
        }
    }
}

