/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Logger;
import uk.ac.starlink.ttools.plot.ExternalFontMapper;
import uk.ac.starlink.ttools.plot.GraphicExporter;
import uk.ac.starlink.ttools.plot.Picture;

public abstract class PdfGraphicExporter
extends GraphicExporter {
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2");
    public static PdfGraphicExporter BASIC = new PdfGraphicExporter(){

        @Override
        public Graphics2D createGraphics(PdfContentByte pcb, int width, int height) {
            return pcb.createGraphics(width, height, new DefaultFontMapper());
        }
    };
    public static PdfGraphicExporter GLYPH_TEXT = new PdfGraphicExporter(){

        @Override
        public Graphics2D createGraphics(PdfContentByte pcb, int width, int height) {
            return pcb.createGraphicsShapes(width, height);
        }
    };

    public static PdfGraphicExporter createExternalFontExporter(URL fontsUrl) {
        return new ExternalFontExporter(fontsUrl);
    }

    protected PdfGraphicExporter() {
        super("pdf", "application/pdf", true, "Portable Document Format", new String[]{".pdf"});
    }

    @Override
    public void exportGraphic(Picture picture, OutputStream out) throws IOException {
        int width = picture.getPictureWidth();
        int height = picture.getPictureHeight();
        Document doc = new Document(new Rectangle(width, height));
        try {
            PdfWriter pWriter = PdfWriter.getInstance(doc, out);
            doc.open();
            Graphics2D g2 = this.createGraphics(pWriter.getDirectContent(), width, height);
            picture.paintPicture(g2);
            g2.dispose();
            doc.close();
        }
        catch (DocumentException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public abstract Graphics2D createGraphics(PdfContentByte var1, int var2, int var3);

    private static class ExternalFontExporter
    extends PdfGraphicExporter {
        private final URL fontsUrl_;
        private FontMapper mapper_;

        public ExternalFontExporter(URL fontsUrl) {
            this.fontsUrl_ = fontsUrl;
        }

        @Override
        public Graphics2D createGraphics(PdfContentByte pcb, int width, int height) {
            FontMapper mapper = this.getMapper();
            return mapper == null ? pcb.createGraphicsShapes(width, height) : pcb.createGraphics(width, height, mapper);
        }

        private synchronized FontMapper getMapper() {
            if (this.mapper_ == null) {
                ExternalFontMapper efm = null;
                if (this.fontsUrl_ != null) {
                    try {
                        efm = ExternalFontMapper.createMapperFromResourceList(this.fontsUrl_.openStream());
                    }
                    catch (Exception e) {
                        logger_.warning("Error reading external fonts at " + this.fontsUrl_ + ": " + e);
                    }
                } else {
                    logger_.warning("Can't find external fonts at " + this.fontsUrl_);
                }
                this.mapper_ = efm;
            }
            return this.mapper_;
        }
    }
}

