/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.Matrices;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.util.FloatList;

public class Shaders {
    public static final String LUTFILES_PROPERTY = "lut.files";
    public static final Shader FIX_RED = new FixRGBComponentShader("RGB Red", 0);
    public static final Shader FIX_GREEN = new FixRGBComponentShader("RGB Green", 1);
    public static final Shader FIX_BLUE = new FixRGBComponentShader("RGB Blue", 2);
    public static final Shader SCALE_RED = new ScaleRGBComponentShader("Scale Red", 0);
    public static final Shader SCALE_GREEN = new ScaleRGBComponentShader("Scale Green", 1);
    public static final Shader SCALE_BLUE = new ScaleRGBComponentShader("Scale Blue", 2);
    public static final Shader FIX_Y = new YuvShader("YUV Y", 0, true);
    public static final Shader FIX_U = new YuvShader("YUV U", 1, true);
    public static final Shader FIX_V = new YuvShader("YUV V", 2, true);
    public static final Shader SCALE_Y = new YuvShader("Scale YUV Y", 0, false);
    public static final Shader HSV_H = new HsvShader("HSV H", 0, true);
    public static final Shader HSV_S = new HsvShader("HSV S", 1, true);
    public static final Shader HSV_V = new HsvShader("HSV V", 2, true);
    public static final Shader SCALE_H = new HsvShader("Scale HSV H", 0, false);
    public static final Shader SCALE_S = new HsvShader("Scale HSV S", 1, false);
    public static final Shader SCALE_V = new HsvShader("Scale HSV V", 2, false);
    public static final Shader RED_BLUE = Shaders.createInterpolationShader("Red-Blue", Color.RED, Color.BLUE);
    public static final Shader CYAN_MAGENTA = Shaders.createInterpolationShader("Cyan-Magenta", Color.CYAN, Color.MAGENTA);
    public static final Shader WHITE_BLACK = Shaders.createInterpolationShader("Greyscale", Color.WHITE, Color.BLACK);
    public static final Shader BLACK_WHITE = Shaders.createInterpolationShader("Greyscale", Color.BLACK, Color.WHITE);
    public static final Shader SRON_RAINBOW = Shaders.createSronRainbowShader("SRON");
    public static final Shader CUBEHELIX = Shaders.createCubehelixShader("Cubehelix", 0.5, -1.5, 1.0, 1.0);
    public static final Shader CUBEHELIX2 = Shaders.createCubehelixShader("Cubehelix2", 0.5, -1.5, 1.5, 1.0);
    public static final Shader CUBEHELIX3 = Shaders.createCubehelixShader("Cubehelix3", 2.0, 1.0, 3.0, 1.0);
    public static final Shader LUT_AIPS0 = new ResourceLutShader("AIPS0", "aips0.lut");
    public static final Shader LUT_BACKGR = new ResourceLutShader("Background", "backgr.lut");
    public static final Shader LUT_COLOR = new ResourceLutShader("Colour", "color.lut");
    public static final Shader LUT_HEAT = new ResourceLutShader("Heat", "heat.lut");
    public static final Shader LUT_IDL2 = new ResourceLutShader("IDL2", "idl2.lut");
    public static final Shader LUT_IDL4 = new ResourceLutShader("IDL4", "idl4.lut");
    public static final Shader LUT_ISOPHOT = new ResourceLutShader("Isophot", "isophot.lut");
    public static final Shader LUT_LIGHT = new ResourceLutShader("Light", "light.lut");
    public static final Shader LUT_MANYCOL = new ResourceLutShader("Manycol", "manycol.lut");
    public static final Shader LUT_PASTEL = new ResourceLutShader("Pastel", "pastel.lut");
    public static final Shader LUT_RAINBOW = new ResourceLutShader("Rainbow", "rainbow1.lut");
    public static final Shader LUT_RAMP = new ResourceLutShader("Ramp", "ramp.lut");
    public static final Shader LUT_RANDOM = new ResourceLutShader("Random", "random.lut");
    public static final Shader LUT_REAL = new ResourceLutShader("Real", "real.lut");
    public static final Shader LUT_SMOOTH = new ResourceLutShader("Smooth", "smooth.lut");
    public static final Shader LUT_STAIRCASE = new ResourceLutShader("Staircase", "staircase.lut");
    public static final Shader LUT_STANDARD = new ResourceLutShader("Standard", "standard.lut");
    public static final Shader LUT_ACCENT = new ResourceLutShader("Accent", "accent.lut");
    public static final Shader LUT_COLD = new ResourceLutShader("Cold", "cold.lut");
    public static final Shader LUT_GLNEMO2 = new ResourceLutShader("Rainbow2", "glnemo2.lut");
    public static final Shader LUT_GNUPLOT = new ResourceLutShader("Gnuplot", "MPL_gnuplot.lut");
    public static final Shader LUT_GNUPLOT2 = new ResourceLutShader("Gnuplot2", "MPL_gnuplot2.lut");
    public static final Shader LUT_SPECXB2Y = new ResourceLutShader("SpecxBY", "specxbl2yel.lut");
    public static final Shader LUT_BRG = new ResourceLutShader("BRG", "brg.lut");
    public static final Shader LUT_PAIRED;
    public static final Shader LUT_RAINBOW3;
    public static final Shader LUT_SET1;
    public static final Shader LUT_MPL2MAGMA;
    public static final Shader LUT_MPL2INFERNO;
    public static final Shader LUT_MPL2PLASMA;
    public static final Shader LUT_MPL2VIRIDIS;
    public static final Shader LUT_HOTCOLD;
    public static final Shader[] LUT_SHADERS;
    public static final Shader BREWER_BUGN;
    public static final Shader BREWER_BUPU;
    public static final Shader BREWER_ORRD;
    public static final Shader BREWER_PUBU;
    public static final Shader BREWER_PURD;
    public static final Shader BREWER_RDBU;
    public static final Shader BREWER_PIYG;
    public static final Shader BREWER_BRBG;
    public static final Shader HCL_POLAR;
    public static final Shader DFLT_GRID_SHADER;
    private static final String LUT_BASE = "/uk/ac/starlink/ttools/colormaps/";
    private static Shader[] customShaders_;
    private static final Logger logger_;
    public static final Shader NULL;
    public static final Shader TRANSPARENCY;
    public static final Shader FIX_INTENSITY;
    public static final Shader SCALE_INTENSITY;
    public static final Shader FADE_BLACK;
    public static final Shader FADE_WHITE;
    public static final Shader FIX_HUE;

    public static Shader createInterpolationShader(String name, Color color0, Color color1) {
        final float[] rgba0 = color0.getRGBComponents(null);
        final float[] rgba1 = color1.getRGBComponents(null);
        return new InterpolationShader(name, new Color[]{color0, color1}){

            @Override
            public void adjustRgba(float[] rgba, float value) {
                for (int i = 0; i < 4; ++i) {
                    float f0 = rgba0[i];
                    float f1 = rgba1[i];
                    rgba[i] = f0 + (f1 - f0) * value;
                }
            }
        };
    }

    public static Shader createInterpolationShader(String name, Color[] colors) {
        return colors.length == 2 ? Shaders.createInterpolationShader(name, colors[0], colors[1]) : new InterpolationShader(name, colors);
    }

    private static Shader createSronRainbowShader(String name) {
        return new BasicShader(name){

            @Override
            public void adjustRgba(float[] rgba, float value) {
                double x = value;
                double x2 = x * x;
                double x3 = x * x2;
                double x4 = x * x3;
                double x5 = x * x4;
                double x6 = x * x5;
                double r = (0.472 - 0.567 * x + 4.05 * x2) / (1.0 + 8.72 * x - 19.17 * x2 + 14.1 * x3);
                double g = 0.108932 - 1.22635 * x + 27.284 * x2 - 98.577 * x3 + 163.3 * x4 - 131.395 * x5 + 40.634 * x6;
                double b = 1.0 / (1.97 + 3.54 * x - 68.5 * x2 + 243.0 * x3 - 297.0 * x4 + 125.0 * x5);
                rgba[0] = (float)r;
                rgba[1] = (float)g;
                rgba[2] = (float)b;
            }
        };
    }

    private static Shader createCubehelixShader(String name, final double start, final double rots, final double hue, final double gamma) {
        double third = 0.3333333333333333;
        final boolean gamma1 = gamma == 1.0;
        return new BasicShader(name){

            @Override
            public void adjustRgba(float[] rgba, float value) {
                double angle = Math.PI * 2 * (start * 0.3333333333333333 + 1.0 + rots * (double)value);
                double fract = gamma1 ? (double)value : Math.pow(value, gamma);
                double amp = hue * fract * 0.5 * (1.0 - fract);
                double c = Math.cos(angle);
                double s = Math.sin(angle);
                rgba[0] = (float)(fract + amp * (-0.14861 * c + 1.78277 * s));
                rgba[1] = (float)(fract + amp * (-0.29227 * c - 0.90649 * s));
                rgba[2] = (float)(fract + amp * (1.97294 * c));
                for (int i = 0; i < 3; ++i) {
                    rgba[i] = Math.max(0.0f, Math.min(1.0f, rgba[i]));
                }
            }
        };
    }

    public static Shader createFixedShader(String name, Color color) {
        final float[] fixedRgba = color.getRGBComponents(new float[4]);
        return new BasicShader(name){

            @Override
            public void adjustRgba(float[] rgba, float value) {
                for (int i = 0; i < 4; ++i) {
                    rgba[i] = fixedRgba[i];
                }
            }
        };
    }

    public static Shader createMaskShader(String name, final float minMask, final float maxMask, final boolean sense) {
        return new BasicShader(name, false){

            @Override
            public void adjustRgba(float[] rgba, float value) {
                if ((value > minMask && value < maxMask) ^ sense) {
                    rgba[3] = 0.0f;
                }
            }
        };
    }

    public static Shader[] getCustomShaders() {
        if (customShaders_ == null) {
            String fileset;
            try {
                fileset = System.getProperty(LUTFILES_PROPERTY);
            }
            catch (SecurityException e) {
                fileset = null;
            }
            ArrayList<TextFileLutShader> shaderList = new ArrayList<TextFileLutShader>();
            if (fileset != null && fileset.length() > 0) {
                String[] files = fileset.split("\\Q" + File.pathSeparator + "\\E");
                for (int i = 0; i < files.length; ++i) {
                    String f = files[i];
                    try {
                        shaderList.add(new TextFileLutShader(new File(f), 256));
                        continue;
                    }
                    catch (IOException e) {
                        logger_.warning("Failed to load custom lookup table " + f + " (" + e + ")");
                    }
                }
            }
            customShaders_ = shaderList.toArray(new Shader[0]);
        }
        return customShaders_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static float[] readFloatArray(URL loc) throws IOException {
        DataInputStream in = new DataInputStream(new BufferedInputStream(loc.openStream()));
        FloatList flist = new FloatList();
        try {
            try {
                float value;
                while ((value = in.readFloat()) >= 0.0f && value <= 1.0f) {
                    flist.add(value);
                }
                throw new IOException("RGB values out of range");
            }
            catch (EOFException e) {
                float[] fArray = flist.toFloatArray();
                return fArray;
            }
        }
        finally {
            in.close();
        }
    }

    private static final float enforceBounds(float f) {
        if (f >= 0.0f) {
            if (f <= 1.0f) {
                return f;
            }
            return 1.0f;
        }
        return 0.0f;
    }

    private static float[] interpolateRgb(float[] in, int nsamp) {
        int nin = in.length / 3;
        float[] out = new float[nsamp * 3];
        for (int is = 0; is < nsamp; ++is) {
            for (int ic = 0; ic < 3; ++ic) {
                int ilo = is * (nin - 1) / (nsamp - 1);
                int ihi = Math.min(ilo + 1, nin - 1);
                float frac = (float)(is * (nin - 1)) / (float)(nsamp - 1) - (float)ilo;
                out[is * 3 + ic] = in[ilo * 3 + ic] + frac * (in[ihi * 3 + ic] - in[ilo * 3 + ic]);
            }
        }
        return out;
    }

    public static Shader invert(Shader shader) {
        return new InvertedShader(shader);
    }

    public static Shader fade(Shader shader, float scaleAlpha) {
        return scaleAlpha == 1.0f ? shader : new FadedShader(shader, scaleAlpha);
    }

    public static Shader rename(Shader shader, String name) {
        return new RenamedShader(shader, name);
    }

    public static Shader stretch(Shader shader, float frac0, float frac1) {
        return new StretchedShader(shader, frac0, frac1);
    }

    public static Shader quantise(Shader shader, double nlevel) {
        return new QuantisedShader(shader, nlevel);
    }

    public static Shader applyShader(Shader shader, Color baseColor, int nsample) {
        return new AppliedLutShader(shader, baseColor, nsample);
    }

    private static Icon create1dIcon(Shader shader, boolean horizontal, Color baseColor, int width, int height, int xpad, int ypad) {
        return new ShaderIcon1(shader, horizontal, baseColor, width, height, xpad, ypad);
    }

    public static Icon create2dIcon(Shader xShader, Shader yShader, boolean xFirst, Color baseColor, int width, int height, int xpad, int ypad) {
        return new ShaderIcon2(xShader, yShader, xFirst, baseColor, width, height, xpad, ypad);
    }

    public static Icon createShaderIcon(Shader shader, Shader gridShader, boolean horizontal, int width, int height, int xpad, int ypad) {
        return shader.isAbsolute() ? Shaders.create1dIcon(shader, horizontal, Color.BLACK, width, height, xpad, ypad) : Shaders.create2dIcon(horizontal ? shader : gridShader, horizontal ? gridShader : shader, !horizontal, Color.BLACK, width, height, xpad, ypad);
    }

    public static Icon createShaderIcon(Shader shader, boolean horizontal, int width, int height, int xpad, int ypad) {
        return Shaders.createShaderIcon(shader, DFLT_GRID_SHADER, horizontal, width, height, xpad, ypad);
    }

    public static boolean isTransparent(Shader shader) {
        if (shader == null) {
            return false;
        }
        float[] rgba = new float[]{1.0f, 0.1f, 0.6f, 1.0f};
        shader.adjustRgba(rgba, 0.8f);
        if (rgba[3] != 1.0f) {
            return true;
        }
        shader.adjustRgba(rgba, 0.2f);
        return rgba[3] != 1.0f;
    }

    static {
        LUT_RAINBOW3 = new ResourceLutShader("Rainbow3", "gist_rainbow.lut");
        LUT_PAIRED = new ResourceLutShader("Paired", "paired.lut");
        LUT_SET1 = new ResourceLutShader("Set1", "set1.lut");
        LUT_MPL2MAGMA = new ResourceLutShader("Magma", "mpl2_magma.lut");
        LUT_MPL2INFERNO = new ResourceLutShader("Inferno", "mpl2_inferno.lut");
        LUT_MPL2PLASMA = new ResourceLutShader("Plasma", "mpl2_plasma.lut");
        LUT_MPL2VIRIDIS = new ResourceLutShader("Viridis", "mpl2_viridis.lut");
        LUT_HOTCOLD = new ResourceLutShader("HotCold", "hotcold.lut");
        LUT_SHADERS = new Shader[]{LUT_AIPS0, LUT_BACKGR, LUT_COLOR, LUT_HEAT, LUT_IDL2, LUT_IDL4, LUT_ISOPHOT, LUT_LIGHT, LUT_MANYCOL, LUT_PASTEL, LUT_RAINBOW, LUT_RAMP, LUT_RANDOM, LUT_REAL, LUT_SMOOTH, LUT_STAIRCASE, LUT_STANDARD, LUT_ACCENT, LUT_COLD, LUT_GLNEMO2, LUT_GNUPLOT, LUT_GNUPLOT2, LUT_SPECXB2Y, LUT_BRG, LUT_RAINBOW3, LUT_PAIRED, LUT_SET1, LUT_MPL2MAGMA, LUT_MPL2INFERNO, LUT_MPL2PLASMA, LUT_MPL2VIRIDIS, LUT_HOTCOLD};
        BREWER_BUGN = new SampleShader("BuGn", new int[]{15595771, 0xCCECE6, 10082505, 6734500, 2925151, 27948});
        BREWER_BUPU = new SampleShader("BuPu", new int[]{15595771, 12571622, 10403034, 9213638, 8935079, 8458108});
        BREWER_ORRD = new SampleShader("OrRd", new int[]{16707801, 16635038, 16628612, 16551257, 14895667, 0xB30000});
        BREWER_PUBU = new SampleShader("PuBu", new int[]{15855350, 13685222, 10927579, 7645647, 2854078, 285325});
        BREWER_PURD = new SampleShader("PuRd", new int[]{15855350, 13941210, 13210823, 14640560, 14490743, 9961539});
        BREWER_RDBU = new SampleShader("RdBu", new int[]{11671595, 14049357, 16033154, 16636871, 13755888, 9618910, 4428739, 2188972});
        BREWER_PIYG = new SampleShader("PiYG", new int[]{12917629, 14579630, 15840986, 16638191, 15136208, 12116358, 8371265, 5083681});
        BREWER_BRBG = new SampleShader("BrBG", new int[]{9195786, 12550445, 14664317, 16181443, 13101797, 8441281, 3512207, 91742});
        HCL_POLAR = new SampleShader("HueCL", new int[]{15295621, 15034738, 14774110, 14382406, 13925156, 13336576, 12748288, 0xB88B00, 11309056, 10458368, 0x909900, 8363264, 7053568, 5350400, 2467586, 43575, 44113, 44647, 44922, 45195, 45211, 44970, 44728, 44229, 43472, 42203, 40931, 39402, 4952814, 7637745, 9601521, 11106542, 12284138, 13265123, 14050010, 14638543, 15031235, 15293365, 15424679, 15425686});
        DFLT_GRID_SHADER = LUT_BRG;
        logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot");
        NULL = new BasicShader("None", false){

            @Override
            public void adjustRgba(float[] rgba, float value) {
            }
        };
        TRANSPARENCY = new BasicShader("Transparency", false){

            @Override
            public void adjustRgba(float[] rgba, float value) {
                rgba[3] = rgba[3] * (value * value);
            }
        };
        FIX_INTENSITY = new BasicShader("Intensity", false){

            @Override
            public void adjustRgba(float[] rgba, float value) {
                float max = Math.max(rgba[0], Math.max(rgba[1], rgba[2]));
                float m1 = 1.0f / max;
                for (int i = 0; i < 3; ++i) {
                    rgba[i] = 1.0f - value * (1.0f - rgba[i] * m1);
                }
            }
        };
        SCALE_INTENSITY = new BasicShader("Scale Intensity", false){

            @Override
            public void adjustRgba(float[] rgba, float value) {
                for (int i = 0; i < 3; ++i) {
                    rgba[i] = 1.0f - value * (1.0f - rgba[i]);
                }
            }
        };
        FADE_BLACK = new FadeShader("Blacker", Color.BLACK);
        FADE_WHITE = new FadeShader("Whiter", Color.WHITE);
        FIX_HUE = new BasicShader("Hue"){

            @Override
            public void adjustRgba(float[] rgba, float value) {
                float b;
                float g;
                float r;
                float h = value * 359.99f;
                float h6 = h / 60.0f;
                int hi = (int)h6;
                float f = h6 - (float)hi;
                float s = 1.0f;
                float v = 1.0f;
                float p = v * (1.0f - s);
                float q = v * (1.0f - f * s);
                float t = v * (1.0f - (1.0f - f) * s);
                switch (hi) {
                    case 0: {
                        r = v;
                        g = t;
                        b = p;
                        break;
                    }
                    case 1: {
                        r = q;
                        g = v;
                        b = p;
                        break;
                    }
                    case 2: {
                        r = p;
                        g = v;
                        b = t;
                        break;
                    }
                    case 3: {
                        r = p;
                        g = q;
                        b = v;
                        break;
                    }
                    case 4: {
                        r = t;
                        g = p;
                        b = v;
                        break;
                    }
                    case 5: {
                        r = v;
                        g = p;
                        b = q;
                        break;
                    }
                    default: {
                        r = 0.0f;
                        g = 0.0f;
                        b = 0.0f;
                    }
                }
                rgba[0] = r;
                rgba[1] = g;
                rgba[2] = b;
            }
        };
    }

    private static class ShaderIcon2
    implements Icon {
        private final Shader xShader_;
        private final Shader yShader_;
        private final boolean xFirst_;
        private final int width_;
        private final int height_;
        private final int xpad_;
        private final int ypad_;
        private final float[] baseRgba_;

        public ShaderIcon2(Shader xShader, Shader yShader, boolean xFirst, Color baseColor, int width, int height, int xpad, int ypad) {
            this.xShader_ = xShader;
            this.yShader_ = yShader;
            this.xFirst_ = xFirst;
            this.width_ = width;
            this.height_ = height;
            this.xpad_ = xpad;
            this.ypad_ = ypad;
            this.baseRgba_ = baseColor.getRGBComponents(null);
        }

        @Override
        public int getIconWidth() {
            return this.width_;
        }

        @Override
        public int getIconHeight() {
            return this.height_;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color origColor = g.getColor();
            int nx = this.width_ - 2 * this.xpad_;
            int ny = this.height_ - 2 * this.ypad_;
            float nx1 = 1.0f / (float)(nx - 1);
            float ny1 = 1.0f / (float)(ny - 1);
            for (int ix = 0; ix < nx; ++ix) {
                for (int iy = 0; iy < ny; ++iy) {
                    g.setColor(this.getColor((float)ix * nx1, (float)iy * ny1));
                    g.drawRect(x + ix + this.xpad_, y + iy + this.ypad_, 1, 1);
                }
            }
            g.setColor(origColor);
        }

        private Color getColor(float xval, float yval) {
            float[] rgba = (float[])this.baseRgba_.clone();
            if (this.xFirst_) {
                this.xShader_.adjustRgba(rgba, xval);
                this.yShader_.adjustRgba(rgba, yval);
            } else {
                this.yShader_.adjustRgba(rgba, yval);
                this.xShader_.adjustRgba(rgba, xval);
            }
            return new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
        }
    }

    private static class ShaderIcon1
    implements Icon {
        private final Shader shader_;
        private final boolean horizontal_;
        private final int width_;
        private final int height_;
        private final int xpad_;
        private final int ypad_;
        private final float[] baseRgba_;

        public ShaderIcon1(Shader shader, boolean horizontal, Color baseColor, int width, int height, int xpad, int ypad) {
            this.shader_ = shader;
            this.horizontal_ = horizontal;
            this.width_ = width;
            this.height_ = height;
            this.xpad_ = xpad;
            this.ypad_ = ypad;
            this.baseRgba_ = baseColor.getRGBComponents(null);
        }

        @Override
        public int getIconWidth() {
            return this.width_;
        }

        @Override
        public int getIconHeight() {
            return this.height_;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color origColor = g.getColor();
            int npix = this.horizontal_ ? this.width_ - 2 * this.xpad_ : this.height_ - 2 * this.ypad_;
            float np1 = 1.0f / (float)(npix - 1);
            int xlo = x + this.xpad_;
            int xhi = x + this.width_ - this.xpad_;
            int ylo = y + this.ypad_;
            int yhi = y + this.height_ - this.ypad_;
            for (int ipix = 0; ipix < npix; ++ipix) {
                g.setColor(this.getColor((float)ipix * np1));
                if (this.horizontal_) {
                    g.fillRect(xlo + ipix - 1, ylo, 1, yhi - ylo);
                    continue;
                }
                g.fillRect(xlo, ylo + ipix - 1, xhi - xlo, 1);
            }
            g.setColor(origColor);
        }

        private Color getColor(float value) {
            float[] rgba = (float[])this.baseRgba_.clone();
            this.shader_.adjustRgba(rgba, value);
            return new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
        }
    }

    private static class AppliedLutShader
    extends LutShader {
        private final Shader baseShader_;
        private final Color baseColor_;
        private final int nsample_;
        private final float[] lut_;

        AppliedLutShader(Shader baseShader, Color baseColor, int nsample) {
            super(baseShader.getName() + "-fix");
            this.baseShader_ = baseShader;
            this.baseColor_ = baseColor;
            this.nsample_ = nsample;
            float[] baseRgba = baseColor.getRGBColorComponents(new float[4]);
            float[] rgba = new float[4];
            this.lut_ = new float[3 * nsample];
            for (int is = 0; is < nsample; ++is) {
                float level = (float)is / (float)(nsample - 1);
                System.arraycopy(baseRgba, 0, rgba, 0, 4);
                baseShader.adjustRgba(rgba, level);
                System.arraycopy(rgba, 0, this.lut_, is * 3, 3);
            }
        }

        @Override
        protected float[] getRgbLut() {
            return this.lut_;
        }

        public boolean equals(Object o) {
            if (o instanceof AppliedLutShader) {
                AppliedLutShader other = (AppliedLutShader)o;
                return this.baseShader_.equals(other.baseShader_) && (this.baseShader_.isAbsolute() || this.baseColor_.equals(other.baseColor_)) && this.nsample_ == other.nsample_;
            }
            return false;
        }

        public int hashCode() {
            int code = 5501;
            code = code * 23 + this.baseShader_.hashCode();
            code = code * 23 + (this.baseShader_.isAbsolute() ? 99 : this.baseColor_.hashCode());
            code = code * 23 + this.nsample_;
            return code;
        }
    }

    private static class SampleShader
    extends LutShader {
        private static final float FF1 = 0.003921569f;
        protected final float[] lut_;

        SampleShader(String name, int[] rgbs) {
            super(name);
            this.lut_ = Shaders.interpolateRgb(SampleShader.toFloats(rgbs), 256);
        }

        @Override
        protected float[] getRgbLut() {
            return this.lut_;
        }

        private static float[] toFloats(int[] rgbs) {
            float[] flut = new float[rgbs.length * 3];
            for (int i = 0; i < rgbs.length; ++i) {
                int j = i * 3;
                int rgb = rgbs[i];
                flut[j++] = (float)(rgb >> 16 & 0xFF) * 0.003921569f;
                flut[j++] = (float)(rgb >> 8 & 0xFF) * 0.003921569f;
                flut[j++] = (float)(rgb >> 0 & 0xFF) * 0.003921569f;
            }
            return flut;
        }
    }

    private static class TextFileLutShader
    extends LutShader {
        private final float[] lut_;
        private static final Pattern TRIPLE_REGEX = Pattern.compile("\\s*([0-9.e]+)\\s+([0-9.e]+)\\s+([0-9.e]+)\\s*");

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TextFileLutShader(File file, int minSamples) throws IOException {
            super(file.getName());
            FloatList flist = new FloatList();
            int iline = 0;
            BufferedReader in = new BufferedReader(new FileReader(file));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    ++iline;
                    String tline = line.replaceFirst("#.*", "").trim();
                    if (tline.length() <= 0) continue;
                    Matcher matcher = TRIPLE_REGEX.matcher(tline);
                    if (matcher.matches()) {
                        for (int i = 0; i < 3; ++i) {
                            float val = Float.parseFloat(matcher.group(i + 1));
                            if (!(val >= 0.0f) || !(val <= 1.0f)) {
                                throw new IOException("Not in range 0-1: " + file + " line " + iline);
                            }
                            flist.add(val);
                        }
                        continue;
                    }
                    throw new IOException("Not 3 numbers: " + file + " line " + iline);
                }
            }
            finally {
                in.close();
            }
            float[] lut = flist.toFloatArray();
            float[] fArray = this.lut_ = lut.length < minSamples ? Shaders.interpolateRgb(lut, minSamples) : lut;
            assert (this.lut_.length % 3 == 0);
        }

        @Override
        protected float[] getRgbLut() {
            return this.lut_;
        }
    }

    private static class ResourceLutShader
    extends LutShader {
        private final String resourceName_;
        private float[] lut_;

        ResourceLutShader(String name, String resourceName) {
            super(name);
            this.resourceName_ = resourceName;
        }

        @Override
        protected float[] getRgbLut() {
            if (this.lut_ == null) {
                String loc = Shaders.LUT_BASE + this.resourceName_;
                logger_.config("Reading lookup table at " + loc);
                URL url = Shaders.class.getResource(loc);
                try {
                    if (url == null) {
                        throw new FileNotFoundException("No resource " + loc);
                    }
                    this.lut_ = Shaders.readFloatArray(url);
                }
                catch (IOException e) {
                    logger_.warning("No colour map for " + this + ": " + e);
                    this.lut_ = new float[3];
                }
            }
            return this.lut_;
        }
    }

    private static abstract class LutShader
    extends BasicShader {
        LutShader(String name) {
            super(name);
        }

        protected abstract float[] getRgbLut();

        @Override
        public void adjustRgba(float[] rgba, float value) {
            float[] lut = this.getRgbLut();
            int nsamp = lut.length / 3;
            int is3 = 3 * (int)(value * (float)(nsamp - 1) + 0.5f);
            rgba[0] = lut[is3 + 0];
            rgba[1] = lut[is3 + 1];
            rgba[2] = lut[is3 + 2];
        }
    }

    private static class ScaleRGBComponentShader
    extends BasicShader {
        private final int icomp_;

        ScaleRGBComponentShader(String name, int icomp) {
            super(name, false);
            this.icomp_ = icomp;
        }

        @Override
        public void adjustRgba(float[] rgba, float value) {
            int n = this.icomp_;
            rgba[n] = rgba[n] * value;
        }
    }

    private static class RenamedShader
    implements Shader {
        private final Shader base_;
        private final String name_;

        public RenamedShader(Shader base, String name) {
            this.base_ = base;
            this.name_ = name;
        }

        @Override
        public String getName() {
            return this.name_;
        }

        @Override
        public boolean isAbsolute() {
            return this.base_.isAbsolute();
        }

        @Override
        public void adjustRgba(float[] rgba, float value) {
            this.base_.adjustRgba(rgba, value);
        }

        public int hashCode() {
            int code = 9191;
            code = 23 * code + this.base_.hashCode();
            code = 23 * code + this.name_.hashCode();
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof RenamedShader) {
                RenamedShader other = (RenamedShader)o;
                return this.base_.equals(other.base_) && this.name_.equals(other.name_);
            }
            return false;
        }
    }

    private static class QuantisedShader
    implements Shader {
        private final Shader base_;
        private final float nlevel_;

        public QuantisedShader(Shader base, double nlevel) {
            this.base_ = base;
            this.nlevel_ = (float)nlevel;
        }

        @Override
        public void adjustRgba(float[] rgba, float value) {
            this.base_.adjustRgba(rgba, this.quantise(value));
        }

        private float quantise(float value) {
            return (float)((int)(value * this.nlevel_)) / this.nlevel_;
        }

        @Override
        public boolean isAbsolute() {
            return this.base_.isAbsolute();
        }

        @Override
        public String getName() {
            return this.base_.getName() + "-" + Math.round(this.nlevel_);
        }

        public int hashCode() {
            int code = 4392;
            code = 23 * code + this.base_.hashCode();
            code = 23 * code + Float.floatToIntBits(this.nlevel_);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof QuantisedShader) {
                QuantisedShader other = (QuantisedShader)o;
                return this.base_.equals(other.base_) && this.nlevel_ == other.nlevel_;
            }
            return false;
        }

        public String toString() {
            return this.getName();
        }
    }

    private static class FadedShader
    implements Shader {
        private final Shader base_;
        private final float scaleAlpha_;

        public FadedShader(Shader base, float scaleAlpha) {
            this.base_ = base;
            this.scaleAlpha_ = scaleAlpha;
        }

        @Override
        public void adjustRgba(float[] rgba, float value) {
            this.base_.adjustRgba(rgba, value);
            rgba[3] = rgba[3] * this.scaleAlpha_;
        }

        @Override
        public boolean isAbsolute() {
            return this.base_.isAbsolute();
        }

        @Override
        public String getName() {
            return this.base_.getName() + "*" + this.scaleAlpha_;
        }

        public boolean equals(Object o) {
            if (o instanceof FadedShader) {
                FadedShader other = (FadedShader)o;
                return this.base_.equals(other.base_) && this.scaleAlpha_ == other.scaleAlpha_;
            }
            return false;
        }

        public int hashCode() {
            int code = 2223432;
            code = 23 * code + this.base_.hashCode();
            code = 23 * code + Float.floatToIntBits(this.scaleAlpha_);
            return code;
        }
    }

    private static class InvertedShader
    implements Shader {
        private final Shader base_;

        public InvertedShader(Shader base) {
            this.base_ = base;
        }

        @Override
        public void adjustRgba(float[] rgba, float value) {
            this.base_.adjustRgba(rgba, 1.0f - value);
        }

        @Override
        public boolean isAbsolute() {
            return this.base_.isAbsolute();
        }

        @Override
        public String getName() {
            return "-" + this.base_.getName();
        }

        public boolean equals(Object o) {
            if (o instanceof InvertedShader) {
                InvertedShader other = (InvertedShader)o;
                return this.base_.equals(other.base_);
            }
            return false;
        }

        public int hashCode() {
            return -this.base_.hashCode();
        }
    }

    private static class StretchedShader
    implements Shader {
        private final String name_;
        private final Shader baseShader_;
        private final float f0_;
        private final float fScale_;

        public StretchedShader(String name, Shader base, float f0, float f1) {
            if (!(f0 >= 0.0f && f0 <= 1.0f && f1 >= 0.0f && f1 <= 1.0f)) {
                throw new IllegalArgumentException("Bad fraction");
            }
            this.name_ = name;
            this.baseShader_ = base;
            this.f0_ = f0;
            this.fScale_ = f1 - f0;
        }

        public StretchedShader(Shader base, float f0, float f1) {
            this("Stretch-" + base.getName(), base, f0, f1);
        }

        @Override
        public String getName() {
            return this.name_;
        }

        @Override
        public boolean isAbsolute() {
            return this.baseShader_.isAbsolute();
        }

        @Override
        public void adjustRgba(float[] rgba, float value) {
            this.baseShader_.adjustRgba(rgba, this.f0_ + this.fScale_ * value);
        }

        public boolean equals(Object o) {
            if (o instanceof StretchedShader) {
                StretchedShader other = (StretchedShader)o;
                return this.baseShader_.equals(other.baseShader_) && this.f0_ == other.f0_ && this.fScale_ == other.fScale_;
            }
            return false;
        }

        public int hashCode() {
            int code = 79;
            code = code * 23 + this.baseShader_.hashCode();
            code = code * 23 + Float.floatToIntBits(this.f0_);
            code = code * 23 + Float.floatToIntBits(this.fScale_);
            return code;
        }
    }

    private static class InterpolationShader
    extends BasicShader {
        private final float[][] rgbas_;
        private final int nRange_;
        private final float fRange_;
        private final float[] rgbaMax_;

        InterpolationShader(String name, Color[] colors) {
            super(name);
            int nc = colors.length;
            this.nRange_ = nc - 1;
            this.fRange_ = 1.0f / (float)this.nRange_;
            this.rgbas_ = new float[nc][];
            for (int ic = 0; ic < nc; ++ic) {
                this.rgbas_[ic] = colors[ic].getRGBComponents(null);
            }
            this.rgbaMax_ = this.rgbas_[nc - 1];
        }

        @Override
        public void adjustRgba(float[] rgba, float value) {
            if (value >= 1.0f) {
                for (int i = 0; i < 4; ++i) {
                    rgba[i] = this.rgbaMax_[i];
                }
            } else {
                int ic0 = (int)((float)this.nRange_ * value);
                int ic1 = ic0 + 1;
                float v = (float)this.nRange_ * (value % this.fRange_);
                float[] rgba0 = this.rgbas_[ic0];
                float[] rgba1 = this.rgbas_[ic1];
                for (int i = 0; i < 4; ++i) {
                    float f0 = rgba0[i];
                    float f1 = rgba1[i];
                    rgba[i] = f0 + (f1 - f0) * v;
                }
            }
        }

        public int hashCode() {
            return Arrays.deepHashCode((Object[])this.rgbas_);
        }

        public boolean equals(Object o) {
            if (o instanceof InterpolationShader) {
                InterpolationShader other = (InterpolationShader)o;
                return Arrays.deepEquals((Object[])this.rgbas_, (Object[])other.rgbas_);
            }
            return false;
        }
    }

    private static class FadeShader
    extends BasicShader {
        private final float[] fadeRgba_;

        FadeShader(String name, Color fadeColor) {
            super(name, false);
            this.fadeRgba_ = fadeColor.getComponents(new float[4]);
        }

        @Override
        public void adjustRgba(float[] rgba, float value) {
            for (int i = 0; i < 4; ++i) {
                int n = i;
                rgba[n] = rgba[n] + value * (this.fadeRgba_[i] - rgba[i]);
            }
        }

        public int hashCode() {
            int code = 3344;
            code = 23 * code + Arrays.hashCode(this.fadeRgba_);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof FadeShader) {
                FadeShader other = (FadeShader)o;
                return Arrays.equals(this.fadeRgba_, other.fadeRgba_);
            }
            return false;
        }
    }

    private static class HsvShader
    extends ColorSpaceComponentShader {
        HsvShader(String name, int icomp, boolean fix) {
            super(name, icomp, fix);
        }

        @Override
        protected void toSpace(float[] rgb) {
            float sh;
            float h;
            float r = rgb[0];
            float g = rgb[1];
            float b = rgb[2];
            float max = Math.max(r, Math.max(g, b));
            float min = Math.min(r, Math.min(g, b));
            float v = max;
            float s = max > 0.0f ? 1.0f - min / max : 0.0f;
            float diff = max - min;
            if (diff == 0.0f) {
                h = 0.0f;
            } else if (r == max) {
                h = 60.0f * (g - b) / diff + 0.0f;
            } else if (g == max) {
                h = 60.0f * (b - r) / diff + 120.0f;
            } else if (b == max) {
                h = 60.0f * (r - g) / diff + 240.0f;
            } else {
                assert (false);
                h = 0.0f;
            }
            if (h < 0.0f) {
                h += 360.0f;
            }
            rgb[0] = sh = h / 360.0f;
            rgb[1] = s;
            rgb[2] = v;
        }

        @Override
        protected void fromSpace(float[] hsv) {
            float b;
            float g;
            float r;
            float sh = hsv[0];
            float s = hsv[1];
            float v = hsv[2];
            float h6 = sh * 6.0f;
            int ih = (int)h6;
            float f = h6 - (float)ih;
            float p = v * (1.0f - s);
            float q = v * (1.0f - f * s);
            float t = v * (1.0f - (1.0f - f) * s);
            switch (ih) {
                case 0: {
                    r = v;
                    g = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = v;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = v;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = v;
                    break;
                }
                case 4: {
                    r = t;
                    g = p;
                    b = v;
                    break;
                }
                case 5: 
                case 6: {
                    r = v;
                    g = p;
                    b = q;
                    break;
                }
                default: {
                    r = 0.0f;
                    g = 0.0f;
                    b = 0.0f;
                    assert (false) : ih;
                    break;
                }
            }
            hsv[0] = r;
            hsv[1] = g;
            hsv[2] = b;
        }
    }

    private static class YPbPrShader
    extends ColorSpaceComponentShader {
        private static final float[] T;
        private static final float[] F;

        YPbPrShader(String name, int icomp, boolean fix) {
            super(name, icomp, fix);
        }

        @Override
        protected void toSpace(float[] rgb) {
            float r = rgb[0];
            float g = rgb[1];
            float b = rgb[2];
            float y = r * T[0] + g * T[1] + b * T[2];
            float pb = r * T[3] + g * T[4] + b * T[5];
            float pr = r * T[6] + g * T[7] + b * T[8];
            rgb[0] = Shaders.enforceBounds(y);
            rgb[1] = Shaders.enforceBounds(pb + 0.5f);
            rgb[2] = Shaders.enforceBounds(pr + 0.5f);
        }

        @Override
        protected void fromSpace(float[] yPbPr) {
            float y = yPbPr[0];
            float pb = yPbPr[1] - 0.5f;
            float pr = yPbPr[2] - 0.5f;
            float r = y * F[0] + pb * F[1] + pr * F[2];
            float g = y * F[3] + pb * F[4] + pr * F[5];
            float b = y * F[6] + pb * F[7] + pr * F[8];
            yPbPr[0] = Shaders.enforceBounds(r);
            yPbPr[1] = Shaders.enforceBounds(g);
            yPbPr[2] = Shaders.enforceBounds(b);
        }

        static {
            double[] toRgb = new double[]{0.299, 0.587, 0.114, -0.168736, -0.331264, 0.5, 0.5, -0.418688, -0.081312};
            double[] fromRgb = Matrices.invert(toRgb);
            T = new float[9];
            F = new float[9];
            for (int i = 0; i < 9; ++i) {
                YPbPrShader.T[i] = (float)toRgb[i];
                YPbPrShader.F[i] = (float)fromRgb[i];
            }
        }
    }

    private static class YuvShader
    extends ColorSpaceComponentShader {
        YuvShader(String name, int icomp, boolean fix) {
            super(name, icomp, fix);
        }

        @Override
        protected void toSpace(float[] rgb) {
            float r = rgb[0];
            float g = rgb[1];
            float b = rgb[2];
            float y = 0.299f * r + 0.587f * g + 0.114f * b;
            float u = 0.436f * (b - y) / 0.886f;
            float v = 0.615f * (r - y) / 0.701f;
            float su = 0.5f * (u / 0.436f) + 0.5f;
            float sv = 0.5f * (v / 0.615f) + 0.5f;
            rgb[0] = Shaders.enforceBounds(y);
            rgb[1] = Shaders.enforceBounds(su);
            rgb[2] = Shaders.enforceBounds(sv);
        }

        @Override
        protected void fromSpace(float[] yuv) {
            float y = yuv[0];
            float su = yuv[1];
            float sv = yuv[2];
            float u = (su * 2.0f - 1.0f) * 0.436f;
            float v = (sv * 2.0f - 1.0f) * 0.615f;
            float r = y + 1.13983f * v;
            float g = y - 0.39466f * u - 0.5806f * v;
            float b = y + 2.03211f * u;
            yuv[0] = Shaders.enforceBounds(r);
            yuv[1] = Shaders.enforceBounds(g);
            yuv[2] = Shaders.enforceBounds(b);
        }
    }

    private static class FixRGBComponentShader
    extends BasicShader {
        private final int icomp_;

        FixRGBComponentShader(String name, int icomp) {
            super(name, false);
            this.icomp_ = icomp;
        }

        @Override
        public void adjustRgba(float[] rgba, float value) {
            rgba[this.icomp_] = value;
        }
    }

    private static abstract class ColorSpaceComponentShader
    extends BasicShader {
        private final int icomp_;
        private final boolean fix_;

        ColorSpaceComponentShader(String name, int icomp, boolean fix) {
            super(name, false);
            this.icomp_ = icomp;
            this.fix_ = fix;
        }

        protected abstract void toSpace(float[] var1);

        protected abstract void fromSpace(float[] var1);

        @Override
        public void adjustRgba(float[] rgba, float value) {
            this.toSpace(rgba);
            rgba[this.icomp_] = this.fix_ ? value : value * rgba[this.icomp_];
            this.fromSpace(rgba);
        }
    }

    private static abstract class BasicShader
    implements Shader {
        private final String name_;
        private final boolean isAbsolute_;

        BasicShader(String name) {
            this(name, true);
        }

        BasicShader(String name, boolean isAbsolute) {
            this.name_ = name;
            this.isAbsolute_ = isAbsolute;
        }

        @Override
        public String getName() {
            return this.name_;
        }

        @Override
        public boolean isAbsolute() {
            return this.isAbsolute_;
        }

        public String toString() {
            return this.name_;
        }
    }
}

