/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.BitSet;
import uk.ac.starlink.ttools.plot.DataColorTweaker;
import uk.ac.starlink.ttools.plot.MarkStyle;
import uk.ac.starlink.ttools.plot.Pixellator;
import uk.ac.starlink.ttools.plot.PlotVolume;

public class ZBufferPlotVolume
extends PlotVolume {
    private final int xdim_;
    private final int ydim_;
    private final int xoff_;
    private final int yoff_;
    private final float[] zbuf_;
    private final int[] rgbBuf_;
    private final BitSet mask_;
    private final int[][] pixoffs_;
    private final BufferedImage image_;
    private final MarkStyle[] styles_;
    private final Graphics graphics_;
    private final Rectangle clip_;
    private final Paint markPaint_;
    private final Paint labelPaint_;
    private static final int NO_RGBA = 0;

    public ZBufferPlotVolume(Component c, Graphics g, MarkStyle[] styles, double padFactor, int[] padBorders, double fogginess, boolean hasLabels, DataColorTweaker tweaker, Workspace ws) {
        super(c, g, styles, padFactor, padBorders, fogginess);
        this.graphics_ = g;
        this.styles_ = (MarkStyle[])styles.clone();
        int ppad = 2;
        for (int i = 0; i < styles.length; ++i) {
            ppad = Math.max(ppad, 2 + 2 * styles[i].getMaximumRadius());
        }
        this.xdim_ = c.getWidth() + 2 * ppad;
        this.ydim_ = c.getHeight() + 2 * ppad;
        this.xoff_ = -ppad;
        this.yoff_ = -ppad;
        this.clip_ = new Rectangle(this.graphics_.getClipBounds());
        this.clip_.translate(ppad, ppad);
        ws.init(this.xdim_, this.ydim_);
        this.zbuf_ = ws.zbuf_;
        this.rgbBuf_ = ws.rgbBuf_;
        this.mask_ = ws.mask_;
        this.image_ = ws.image_;
        Arrays.fill(this.zbuf_, Float.MAX_VALUE);
        int nstyle = styles.length;
        this.pixoffs_ = new int[nstyle][];
        for (int is = 0; is < nstyle; ++is) {
            this.pixoffs_[is] = styles[is].getFlattenedPixelOffsets(this.xdim_);
        }
        Color[] markColors = new Color[nstyle];
        Color[] labelColors = new Color[nstyle];
        for (int is = 0; is < nstyle; ++is) {
            markColors[is] = styles[is].getColor();
            labelColors[is] = Color.BLACK;
        }
        DataColorTweaker markTweaker = this.createFoggingTweaker(tweaker);
        this.markPaint_ = markTweaker != null ? new TweakedPaint(markColors, markTweaker) : new FixedPaint(markColors);
        DataColorTweaker labelTweaker = this.createFoggingTweaker(null);
        this.labelPaint_ = labelTweaker != null ? new TweakedPaint(labelColors, labelTweaker) : new FixedPaint(labelColors);
    }

    @Override
    public void plot2d(int xp, int yp, double zd, double[] coords, int is, boolean showPoint, String label, int nerr, int[] xoffs, int[] yoffs, double[] zerrs) {
        int pixoff;
        float z = (float)zd;
        int xbase = xp - this.xoff_;
        int ybase = yp - this.yoff_;
        int base = xbase + this.xdim_ * ybase;
        this.markPaint_.setColor(is, coords);
        if (showPoint) {
            int[] pixoffs = this.pixoffs_[is];
            int npixoff = pixoffs.length;
            for (int ioff = 0; ioff < npixoff; ++ioff) {
                this.hitPixel(base + pixoffs[ioff], z, this.markPaint_);
            }
        }
        if (nerr > 0) {
            Pixellator epixer = this.styles_[is].getErrorRenderer().getPixels(this.clip_, xbase, ybase, xoffs, yoffs);
            epixer.start();
            while (epixer.next()) {
                pixoff = epixer.getX() + this.xdim_ * epixer.getY();
                this.hitPixel(pixoff, z, this.markPaint_);
            }
        }
        if (label != null && z <= this.zbuf_[base]) {
            this.labelPaint_.setColor(is, coords);
            Pixellator lpixer = this.styles_[is].getLabelPixels(label, xbase, ybase, this.clip_);
            if (lpixer != null) {
                lpixer.start();
                while (lpixer.next()) {
                    pixoff = lpixer.getX() + this.xdim_ * lpixer.getY();
                    this.hitPixel(pixoff, z, this.labelPaint_);
                }
            }
        }
    }

    @Override
    public void flush() {
        Graphics g = this.getGraphics();
        int xmin = this.xdim_;
        int xmax = 0;
        int ymin = this.ydim_;
        int ymax = 0;
        int ipix = this.mask_.nextSetBit(0);
        while (ipix >= 0) {
            int iy = ipix / this.xdim_;
            int ix = ipix % this.xdim_;
            xmin = Math.min(xmin, ix);
            xmax = Math.max(xmax, ix);
            ymin = Math.min(ymin, iy);
            ymax = Math.max(ymax, iy);
            ipix = this.mask_.nextSetBit(ipix + 1);
        }
        if (xmax >= xmin && ymax >= ymin) {
            int width = xmax - xmin + 1;
            int height = ymax - ymin + 1;
            this.image_.setRGB(xmin, ymin, width, height, this.rgbBuf_, xmin + ymin * this.xdim_, this.xdim_);
            g.drawImage(this.image_.getSubimage(xmin, ymin, width, height), this.xoff_ + xmin, this.yoff_ + ymin, null);
        }
    }

    private void hitPixel(int ipix, float z, Paint paint) {
        int rgb;
        if (z <= this.zbuf_[ipix] && (rgb = paint.getRgb()) != 0) {
            this.mask_.set(ipix);
            this.zbuf_[ipix] = z;
            this.rgbBuf_[ipix] = rgb;
        }
    }

    public static class Workspace {
        private int xdim_ = -1;
        private int ydim_ = -1;
        private float[] zbuf_;
        private int[] rgbBuf_;
        private BitSet mask_;
        private BufferedImage image_;

        private void init(int xdim, int ydim) {
            if (xdim == this.xdim_ && ydim == this.ydim_) {
                Arrays.fill(this.zbuf_, 0.0f);
                Arrays.fill(this.rgbBuf_, 0);
                this.mask_.clear();
            } else {
                this.xdim_ = xdim;
                this.ydim_ = ydim;
                int npix = xdim * ydim;
                this.zbuf_ = new float[npix];
                this.rgbBuf_ = new int[npix];
                this.mask_ = new BitSet(npix);
                this.image_ = new BufferedImage(xdim, ydim, 2);
            }
        }
    }

    private static class TweakedPaint
    extends Paint {
        final float[][] frgbs_;
        final float[] frgb_;
        final DataColorTweaker tweaker_;
        final int ncoord_;
        final double[] coords_;
        int iset_;
        boolean rgbOk_;
        int rgb_;

        public TweakedPaint(Color[] colors, DataColorTweaker tweaker) {
            int nstyle = colors.length;
            this.frgb_ = new float[4];
            this.frgbs_ = new float[nstyle][];
            for (int is = 0; is < nstyle; ++is) {
                this.frgbs_[is] = colors[is].getRGBComponents(null);
            }
            this.tweaker_ = tweaker;
            this.ncoord_ = tweaker.getNcoord();
            this.coords_ = new double[this.ncoord_];
        }

        @Override
        public void setColor(int iset, double[] coords) {
            this.rgbOk_ = false;
            this.iset_ = iset;
            System.arraycopy(coords, 0, this.coords_, 0, this.ncoord_);
        }

        @Override
        public int getRgb() {
            if (!this.rgbOk_) {
                float[] frgb = this.frgbs_[this.iset_];
                this.frgb_[0] = frgb[0];
                this.frgb_[1] = frgb[1];
                this.frgb_[2] = frgb[2];
                this.frgb_[3] = frgb[3];
                if (this.tweaker_.setCoords(this.coords_)) {
                    this.tweaker_.tweakColor(this.frgb_);
                    float r = this.frgb_[0];
                    float b = this.frgb_[2];
                    this.frgb_[2] = r;
                    this.frgb_[0] = b;
                    this.rgb_ = PlotVolume.packRgba(this.frgb_);
                } else {
                    this.rgb_ = 0;
                }
            }
            return this.rgb_;
        }
    }

    private static class FixedPaint
    extends Paint {
        final int[] rgbs_;
        int rgb_;

        public FixedPaint(Color[] colors) {
            int nstyle = colors.length;
            this.rgbs_ = new int[nstyle];
            for (int is = 0; is < nstyle; ++is) {
                this.rgbs_[is] = colors[is].getRGB();
            }
        }

        @Override
        public void setColor(int iset, double[] coords) {
            this.rgb_ = this.rgbs_[iset];
        }

        @Override
        public int getRgb() {
            return this.rgb_;
        }
    }

    private static abstract class Paint {
        private Paint() {
        }

        abstract void setColor(int var1, double[] var2);

        abstract int getRgb();
    }
}

