/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.data.DataStore;

public class AuxScale {
    private final String name_;
    public static AuxScale COLOR = new AuxScale("Aux");

    public AuxScale(String name) {
        this.name_ = name;
    }

    public String getName() {
        return this.name_;
    }

    public String toString() {
        return this.name_;
    }

    public static AuxScale[] getAuxScales(PlotLayer[] layers) {
        HashSet<AuxScale> scaleSet = new HashSet<AuxScale>();
        for (int il = 0; il < layers.length; ++il) {
            scaleSet.addAll(layers[il].getAuxRangers().keySet());
        }
        return scaleSet.toArray(new AuxScale[0]);
    }

    public static Map<AuxScale, Range> calculateAuxRanges(AuxScale[] scales, PlotLayer[] layers, Surface surface, Object[] knownPlans, DataStore dataStore) {
        HashMap<AuxScale, Range> rangeMap = new HashMap<AuxScale, Range>();
        for (int is = 0; is < scales.length; ++is) {
            AuxScale scale = scales[is];
            rangeMap.put(scale, AuxScale.calculateRange(scale, layers, surface, knownPlans, dataStore));
        }
        return rangeMap;
    }

    private static Range calculateRange(AuxScale scale, PlotLayer[] layers, Surface surface, Object[] knownPlans, DataStore dataStore) {
        Range range = new Range();
        for (int il = 0; il < layers.length; ++il) {
            PlotLayer layer = layers[il];
            AuxReader rdr = layer.getAuxRangers().get(scale);
            if (rdr == null) continue;
            rdr.adjustAuxRange(surface, layer.getDataSpec(), dataStore, knownPlans, range);
        }
        return range;
    }

    public static Map<AuxScale, Range> getClippedRanges(AuxScale[] scales, Map<AuxScale, Range> dataRanges, Map<AuxScale, Range> fixRanges, Map<AuxScale, Subrange> subranges, Map<AuxScale, Boolean> logFlags) {
        HashMap<AuxScale, Range> clipRanges = new HashMap<AuxScale, Range>();
        for (int i = 0; i < scales.length; ++i) {
            AuxScale scale = scales[i];
            boolean logFlag = logFlags.containsKey(scale) ? logFlags.get(scale) : false;
            clipRanges.put(scale, AuxScale.clipRange(dataRanges.get(scale), fixRanges.get(scale), subranges.get(scale), logFlag));
        }
        return clipRanges;
    }

    public static Range clipRange(Range dataRange, Range fixRange, Subrange subrange, boolean isLog) {
        Range fullRange;
        Range range = fullRange = dataRange == null ? new Range() : new Range(dataRange);
        if (fixRange != null) {
            fullRange.limit(fixRange);
        }
        if (subrange == null) {
            return fullRange;
        }
        double[] bounds = fullRange.getFiniteBounds(isLog);
        return new Range(PlotUtil.scaleRange(bounds[0], bounds[1], subrange, isLog));
    }

    public static AuxScale[] getMissingScales(AuxScale[] reqScales, Map<AuxScale, Range> dataRanges, Map<AuxScale, Range> fixRanges) {
        ArrayList<AuxScale> scaleList = new ArrayList<AuxScale>();
        for (int i = 0; i < reqScales.length; ++i) {
            AuxScale scale = reqScales[i];
            Range dataRange = dataRanges.get(scale);
            Range fixRange = fixRanges.get(scale);
            if (dataRange != null && dataRange.isFinite() || fixRange != null && fixRange.isFinite()) continue;
            scaleList.add(scale);
        }
        return scaleList.toArray(new AuxScale[0]);
    }
}

