/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.Orientation;
import uk.ac.starlink.ttools.plot2.Tick;

@Equality
public abstract class Axis {
    private final int glo_;
    private final int ghi_;
    private final double dlo_;
    private final double dhi_;

    protected Axis(int glo, int ghi, double dlo, double dhi) {
        if (glo >= ghi) {
            throw new IllegalArgumentException("Bad graphics bounds");
        }
        if (!(dlo < dhi)) {
            throw new IllegalArgumentException("Bad data bounds");
        }
        this.glo_ = glo;
        this.ghi_ = ghi;
        this.dlo_ = dlo;
        this.dhi_ = dhi;
    }

    public abstract double dataToGraphics(double var1);

    public abstract double graphicsToData(double var1);

    public abstract double[] dataZoom(double var1, double var3);

    public abstract double[] dataPan(double var1, double var3);

    public int[] getGraphicsLimits() {
        return new int[]{this.glo_, this.ghi_};
    }

    public double[] getDataLimits() {
        return new double[]{this.dlo_, this.dhi_};
    }

    public abstract boolean isLinear();

    public void drawLabels(Tick[] ticks, String title, Captioner captioner, Orientation orient, boolean invert, Graphics g) {
        this.calculateLabels(ticks, title, captioner, orient, invert, g);
    }

    public Rectangle getLabelBounds(Tick[] ticks, String title, Captioner captioner, Orientation orient, boolean invert) {
        return this.calculateLabels(ticks, title, captioner, orient, invert, null);
    }

    private Rectangle calculateLabels(Tick[] ticks, String title, Captioner captioner, Orientation orient, boolean invert, Graphics g) {
        double det0;
        boolean hasGraphics = g != null;
        Graphics2D g2 = hasGraphics ? (Graphics2D)g : null;
        AffineTransform trans0 = hasGraphics ? g2.getTransform() : null;
        double d = det0 = trans0 == null ? 0.0 : trans0.getDeterminant();
        if (Double.isNaN(det0) || det0 == 0.0) {
            hasGraphics = false;
            trans0 = null;
        }
        int cpad = captioner.getPad();
        Rectangle textBounds = null;
        Rectangle tickBounds = new Rectangle();
        int tickUnit = orient.isDown() ? -2 : 2;
        for (int it = 0; it < ticks.length; ++it) {
            AffineTransform oTrans;
            Tick tick = ticks[it];
            String label = tick.getLabel();
            int gx = (int)this.dataToGraphics(tick.getValue());
            double tx = invert ? (double)(this.ghi_ - gx) : (double)(gx - this.glo_);
            AffineTransform tTrans = AffineTransform.getTranslateInstance(tx, 0.0);
            Rectangle cbounds = label == null ? null : captioner.getCaptionBounds(label);
            AffineTransform affineTransform = oTrans = label == null ? null : orient.captionTransform(cbounds, cpad);
            if (label != null) {
                Rectangle box = Axis.combineTrans(tTrans, oTrans).createTransformedShape(cbounds).getBounds();
                tickBounds.add(box);
            }
            if (!hasGraphics) continue;
            g2.setTransform(Axis.combineTrans(trans0, tTrans));
            if (label != null) {
                g2.drawLine(0, -tickUnit, 0, tickUnit);
                g2.setTransform(Axis.combineTrans(trans0, tTrans, oTrans));
                captioner.drawCaption(label, g2);
            } else {
                g2.drawLine(0, 0, 0, tickUnit);
            }
            g2.setTransform(trans0);
        }
        if (hasGraphics) {
            g2.setTransform(trans0);
        }
        textBounds = Axis.combineRect(textBounds, tickBounds);
        if (title != null && title.length() > 0) {
            Rectangle cbounds = captioner.getCaptionBounds(title);
            int tx = (this.ghi_ - this.glo_) / 2 - cbounds.width / 2;
            int ty = orient.isDown() ? tickBounds.height + cpad - cbounds.y : -tickBounds.height - cpad - cbounds.height - cbounds.y;
            AffineTransform tTrans = AffineTransform.getTranslateInstance(tx, ty);
            if (hasGraphics) {
                g2.setTransform(Axis.combineTrans(trans0, tTrans));
                captioner.drawCaption(title, g2);
                g2.setTransform(trans0);
            }
            Rectangle titleBounds = Axis.combineTrans(tTrans).createTransformedShape(cbounds).getBounds();
            textBounds = Axis.combineRect(textBounds, titleBounds);
        }
        return textBounds;
    }

    public static Axis createAxis(int glo, int ghi, double dlo, double dhi, boolean log, boolean flip) {
        return log ? new LogAxis(glo, ghi, dlo, dhi, flip) : new LinearAxis(glo, ghi, dlo, dhi, flip);
    }

    private static AffineTransform combineTrans(AffineTransform ... transforms) {
        AffineTransform trans = new AffineTransform();
        for (int i = 0; i < transforms.length; ++i) {
            trans.concatenate(transforms[i]);
        }
        return trans;
    }

    private static Rectangle combineRect(Rectangle r1, Rectangle r2) {
        if (r1 == null) {
            return r2;
        }
        Rectangle rect = new Rectangle(r1);
        if (r2 != null) {
            rect.add(r2);
        }
        return rect;
    }

    public static double[] pan(double dlo, double dhi, double d0, double d1, boolean isLog) {
        double[] dArray;
        if (isLog) {
            double[] dArray2;
            double d10 = d0 / d1;
            double plo = dlo * d10;
            double phi = dhi * d10;
            if (plo > Double.MIN_VALUE && phi < Double.MAX_VALUE) {
                double[] dArray3 = new double[2];
                dArray3[0] = plo;
                dArray2 = dArray3;
                dArray3[1] = phi;
            } else {
                double[] dArray4 = new double[2];
                dArray4[0] = dlo;
                dArray2 = dArray4;
                dArray4[1] = dhi;
            }
            return dArray2;
        }
        double d10 = d1 - d0;
        double plo = dlo - d10;
        double phi = dhi - d10;
        if (plo > -1.7976931348623157E308 && phi < Double.MAX_VALUE) {
            double[] dArray5 = new double[2];
            dArray5[0] = plo;
            dArray = dArray5;
            dArray5[1] = phi;
        } else {
            double[] dArray6 = new double[2];
            dArray6[0] = dlo;
            dArray = dArray6;
            dArray6[1] = dhi;
        }
        return dArray;
    }

    public static double[] zoom(double dlo, double dhi, double d0, double factor, boolean isLog) {
        double[] dArray;
        if (isLog) {
            double[] dArray2;
            double f1 = 1.0 / factor;
            double zlo = d0 * Math.pow(dlo / d0, f1);
            double zhi = d0 * Math.pow(dhi / d0, f1);
            if (zlo > Double.MIN_VALUE && zhi < Double.MAX_VALUE) {
                double[] dArray3 = new double[2];
                dArray3[0] = zlo;
                dArray2 = dArray3;
                dArray3[1] = zhi;
            } else {
                double[] dArray4 = new double[2];
                dArray4[0] = dlo;
                dArray2 = dArray4;
                dArray4[1] = dhi;
            }
            return dArray2;
        }
        double f1 = 1.0 / factor;
        double zlo = d0 + (dlo - d0) * f1;
        double zhi = d0 + (dhi - d0) * f1;
        if (zlo > -1.7976931348623157E308 && zhi < Double.MAX_VALUE) {
            double[] dArray5 = new double[2];
            dArray5[0] = zlo;
            dArray = dArray5;
            dArray5[1] = zhi;
        } else {
            double[] dArray6 = new double[2];
            dArray6[0] = dlo;
            dArray = dArray6;
            dArray6[1] = dhi;
        }
        return dArray;
    }

    private static class LogAxis
    extends Axis {
        private final double a_;
        private final double a1_;
        private final double b_;
        private final double dlo_;
        private final double dhi_;

        public LogAxis(int glo, int ghi, double dlo, double dhi, boolean flip) {
            super(glo, ghi, dlo, dhi);
            this.dlo_ = dlo;
            this.dhi_ = dhi;
            this.a_ = (flip ? -1.0 : 1.0) * (double)(ghi - glo) / (Math.log(dhi) - Math.log(dlo));
            this.b_ = (double)(flip ? ghi : glo) - this.a_ * Math.log(dlo);
            this.a1_ = 1.0 / this.a_;
        }

        @Override
        public boolean isLinear() {
            return false;
        }

        @Override
        public double dataToGraphics(double d) {
            return d > 0.0 ? this.b_ + this.a_ * Math.log(d) : Double.NaN;
        }

        @Override
        public double graphicsToData(double g) {
            return Math.exp((g - this.b_) * this.a1_);
        }

        @Override
        public double[] dataZoom(double d0, double factor) {
            return LogAxis.zoom(this.dlo_, this.dhi_, d0, factor, true);
        }

        @Override
        public double[] dataPan(double d0, double d1) {
            return LogAxis.pan(this.dlo_, this.dhi_, d0, d1, true);
        }

        public int hashCode() {
            int code = -242442;
            code = 23 * code + Float.floatToIntBits((float)this.a_);
            code = 23 * code + Float.floatToIntBits((float)this.b_);
            code = 23 * code + Float.floatToIntBits((float)this.dlo_);
            code = 23 * code + Float.floatToIntBits((float)this.dhi_);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof LogAxis) {
                LogAxis other = (LogAxis)o;
                return this.a_ == other.a_ && this.b_ == other.b_ && this.dlo_ == other.dlo_ && this.dhi_ == other.dhi_;
            }
            return false;
        }
    }

    private static class LinearAxis
    extends Axis {
        private final double a_;
        private final double a1_;
        private final double b_;
        private final double dlo_;
        private final double dhi_;

        public LinearAxis(int glo, int ghi, double dlo, double dhi, boolean flip) {
            super(glo, ghi, dlo, dhi);
            this.dlo_ = dlo;
            this.dhi_ = dhi;
            this.a_ = (flip ? -1.0 : 1.0) * (double)(ghi - glo) / (dhi - dlo);
            this.a1_ = 1.0 / this.a_;
            this.b_ = (double)(flip ? ghi : glo) - this.a_ * dlo;
        }

        @Override
        public boolean isLinear() {
            return true;
        }

        @Override
        public double dataToGraphics(double d) {
            return this.b_ + this.a_ * d;
        }

        @Override
        public double graphicsToData(double g) {
            return (g - this.b_) * this.a1_;
        }

        @Override
        public double[] dataZoom(double d0, double factor) {
            return LinearAxis.zoom(this.dlo_, this.dhi_, d0, factor, false);
        }

        @Override
        public double[] dataPan(double d0, double d1) {
            return LinearAxis.pan(this.dlo_, this.dhi_, d0, d1, false);
        }

        public int hashCode() {
            int code = 2359;
            code = 23 * code + Float.floatToIntBits((float)this.a_);
            code = 23 * code + Float.floatToIntBits((float)this.b_);
            code = 23 * code + Float.floatToIntBits((float)this.dlo_);
            code = 23 * code + Float.floatToIntBits((float)this.dhi_);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof LinearAxis) {
                LinearAxis other = (LinearAxis)o;
                return this.a_ == other.a_ && this.b_ == other.b_ && this.dlo_ == other.dlo_ && this.dhi_ == other.dhi_;
            }
            return false;
        }
    }
}

