/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.Orientation;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Tick;
import uk.ac.starlink.ttools.plot2.Ticker;

public abstract class BasicTicker
implements Ticker {
    private final boolean logFlag_;
    public static final BasicTicker LINEAR = new BasicTicker(false){

        @Override
        public Rule createRule(double dlo, double dhi, double approxMajorCount, int adjust) {
            return new CheckRule(BasicTicker.createRawRule(dlo, dhi, approxMajorCount, adjust, false)){

                @Override
                boolean checkLabel(String label, double value) {
                    return Math.abs(Double.parseDouble(label) - value) < 1.0E-10;
                }
            };
        }
    };
    public static final BasicTicker LOG = new BasicTicker(true){

        @Override
        public Rule createRule(double dlo, double dhi, double approxMajorCount, int adjust) {
            if (dlo <= 0.0 || dhi <= 0.0) {
                throw new IllegalArgumentException("Negative log range?");
            }
            return new CheckRule(BasicTicker.createRawRule(dlo, dhi, approxMajorCount, adjust, true)){

                @Override
                boolean checkLabel(String label, double value) {
                    return Math.abs(Double.parseDouble(label) / value - 1.0) < 1.0E-10;
                }
            };
        }
    };

    protected BasicTicker(boolean logFlag) {
        this.logFlag_ = logFlag;
    }

    public abstract Rule createRule(double var1, double var3, double var5, int var7);

    @Override
    public Tick[] getTicks(double dlo, double dhi, boolean withMinor, Captioner captioner, Orientation orient, int npix, double crowding) {
        Rule rule = this.getRule(dlo, dhi, captioner, orient, npix, crowding);
        return withMinor ? PlotUtil.arrayConcat(BasicTicker.getMajorTicks(rule, dlo, dhi), BasicTicker.getMinorTicks(rule, dlo, dhi)) : BasicTicker.getMajorTicks(rule, dlo, dhi);
    }

    public Rule getRule(double dlo, double dhi, Captioner captioner, Orientation orient, int npix, double crowding) {
        Rule rule;
        Tick[] majors;
        if (dhi <= dlo) {
            throw new IllegalArgumentException("Bad range: " + dlo + " .. " + dhi);
        }
        double approxMajorCount = (double)Math.max(1, npix / 80) * crowding;
        Axis axis = Axis.createAxis(0, npix, dlo, dhi, this.logFlag_, false);
        int adjust = 0;
        while (BasicTicker.overlaps(majors = BasicTicker.getMajorTicks(rule = this.createRule(dlo, dhi, approxMajorCount, adjust), dlo, dhi), axis, captioner, orient) && adjust-- > -5) {
        }
        return rule;
    }

    public static Tick[] getMajorTicks(Rule rule, double dlo, double dhi) {
        ArrayList<Tick> list = new ArrayList<Tick>();
        long index = rule.floorIndex(dlo);
        while (rule.indexToValue(index) <= dhi) {
            double major = rule.indexToValue(index);
            if (major >= dlo && major <= dhi) {
                String label = rule.indexToLabel(index);
                list.add(new Tick(major, label));
            }
            ++index;
        }
        return list.toArray(new Tick[0]);
    }

    public static Tick[] getMinorTicks(Rule rule, double dlo, double dhi) {
        ArrayList<Tick> list = new ArrayList<Tick>();
        long index = rule.floorIndex(dlo);
        while (rule.indexToValue(index) <= dhi) {
            double[] minors = rule.getMinors(index);
            for (int imin = 0; imin < minors.length; ++imin) {
                double minor = minors[imin];
                if (!(minor >= dlo) || !(minor <= dhi)) continue;
                list.add(new Tick(minor));
            }
            ++index;
        }
        return list.toArray(new Tick[0]);
    }

    private static Rule createRawRule(double dlo, double dhi, double approxMajorCount, int adjust, boolean log) {
        if (log && Math.log10(dhi / dlo) > 1.0) {
            LogSpacer[] spacers = LogSpacer.SPACERS;
            assert (spacers.length == 2);
            double nDecade = (Math.log10(dhi) - Math.log10(dlo)) / approxMajorCount;
            int iSpacer = nDecade >= 1.0 ? -((int)nDecade) : (nDecade >= 0.5 ? 0 : (nDecade >= 0.2 ? 1 : 2));
            if ((iSpacer += adjust) < 0) {
                return new DecadeLogRule(-iSpacer);
            }
            if (iSpacer < 2) {
                return new SpacerLogRule(spacers[iSpacer]);
            }
        }
        double approxMajorInterval = (dhi - dlo) / approxMajorCount;
        int exp = (int)Math.floor(Math.log10(approxMajorInterval));
        double oversize = approxMajorInterval / BasicTicker.exp10(exp);
        assert (oversize >= 1.0 && oversize < 10.0);
        int maxLevel = LinearSpacer.SPACERS.length;
        int num = exp * maxLevel + LinearSpacer.getSpacerIndex(oversize) - adjust;
        int[] div = BasicTicker.divFloor(num, maxLevel);
        return new LinearRule(div[0], LinearSpacer.SPACERS[div[1]]);
    }

    private static String linearLabel(long mantissa, int exp) {
        boolean minus = mantissa < 0L;
        String sign = minus ? "-" : "";
        String digits = Long.toString(minus ? -mantissa : mantissa);
        int ndigit = digits.length();
        int sciLimit = 3;
        if (mantissa == 0L) {
            return "0";
        }
        if (exp >= 0 && exp <= sciLimit) {
            return new StringBuffer().append(sign).append(digits).append(BasicTicker.zeros(exp)).toString();
        }
        if (exp < 0 && exp >= -sciLimit) {
            int pointPos = ndigit + exp;
            if (pointPos <= 0) {
                return new StringBuffer().append(sign).append("0.").append(BasicTicker.zeros(-pointPos)).append(digits).toString();
            }
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(sign).append(digits.substring(0, pointPos));
            if (pointPos < ndigit) {
                sbuf.append(".").append(digits.substring(pointPos));
            }
            return sbuf.toString();
        }
        if (exp > sciLimit) {
            int pexp;
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(sign).append(digits.charAt(0));
            int postDigit = ndigit - 1;
            if (postDigit > 0) {
                sbuf.append(".").append(digits.substring(1));
            }
            if ((pexp = exp + postDigit) > sciLimit) {
                sbuf.append("e").append(Integer.toString(pexp));
            } else {
                sbuf.append(BasicTicker.zeros(pexp));
            }
            return sbuf.toString();
        }
        if (exp < -sciLimit) {
            StringBuffer sbuf = new StringBuffer();
            sbuf.append(sign);
            int pexp = exp + ndigit;
            if (pexp > 0) {
                sbuf.append(digits.substring(0, pexp)).append(".").append(digits.substring(pexp));
            } else if (pexp <= 0 && pexp >= -sciLimit) {
                sbuf.append("0.").append(BasicTicker.zeros(-pexp)).append(digits);
            } else if (pexp < -sciLimit) {
                sbuf.append(digits.charAt(0)).append(".").append(digits.substring(1)).append("e").append(Integer.toString(pexp - 1));
            } else {
                assert (false);
                sbuf.append("??");
            }
            return sbuf.toString();
        }
        assert (false);
        return "??";
    }

    private static String logLabel(long mantissa, int exponent) {
        assert (mantissa > 0L && mantissa < 10L);
        double value = (double)mantissa * BasicTicker.exp10(exponent);
        String smantissa = Long.toString(mantissa);
        if (exponent == 0) {
            return smantissa;
        }
        if (exponent > -4 && exponent < 0) {
            return "0." + BasicTicker.zeros(-exponent - 1) + smantissa;
        }
        if (exponent < 4 && exponent > 0) {
            return smantissa + BasicTicker.zeros(exponent);
        }
        return smantissa + "e" + exponent;
    }

    public static boolean overlaps(Tick[] ticks, Axis axis, Captioner captioner, Orientation orient) {
        int cpad = captioner.getPad();
        Rectangle lastBox = null;
        for (int i = 0; i < ticks.length; ++i) {
            Tick tick = ticks[i];
            String label = tick.getLabel();
            if (label == null) continue;
            int gx = (int)axis.dataToGraphics(tick.getValue());
            Rectangle cbounds = captioner.getCaptionBounds(label);
            AffineTransform oTrans = orient.captionTransform(cbounds, cpad);
            Rectangle box = oTrans.createTransformedShape(cbounds).getBounds();
            box.translate(gx, 0);
            box.width += cpad;
            if (lastBox != null && box.intersects(lastBox)) {
                return true;
            }
            lastBox = box;
        }
        return false;
    }

    private static int[] divFloor(int numerator, int divisor) {
        int whole = numerator / divisor;
        int part = numerator % divisor;
        if (part < 0) {
            part += divisor;
            --whole;
        }
        assert (whole * divisor + part == numerator);
        return new int[]{whole, part};
    }

    private static double exp10(int exp) {
        return Math.pow(10.0, exp);
    }

    private static String zeros(int n) {
        StringBuffer sbuf = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            sbuf.append('0');
        }
        return sbuf.toString();
    }

    private static abstract class CheckRule
    implements Rule {
        private final Rule base_;

        CheckRule(Rule base) {
            this.base_ = base;
        }

        abstract boolean checkLabel(String var1, double var2);

        @Override
        public String indexToLabel(long index) {
            String label = this.base_.indexToLabel(index);
            assert (this.checkLabel(label, this.base_.indexToValue(index))) : '\"' + label + '\"' + " != " + this.base_.indexToValue(index);
            return label;
        }

        @Override
        public long floorIndex(double value) {
            return this.base_.floorIndex(value);
        }

        @Override
        public double[] getMinors(long index) {
            return this.base_.getMinors(index);
        }

        @Override
        public double indexToValue(long index) {
            return this.base_.indexToValue(index);
        }
    }

    private static class SpacerLogRule
    implements Rule {
        private final int[] majors_;
        private final double[][] minors_;

        public SpacerLogRule(LogSpacer spacer) {
            this.majors_ = spacer.majors_;
            this.minors_ = spacer.minors_;
        }

        @Override
        public long floorIndex(double value) {
            int expFloor = (int)Math.floor(Math.log10(value));
            double mult = value / BasicTicker.exp10(expFloor);
            int ik = 0;
            for (int i = 0; i < this.majors_.length; ++i) {
                if (!(mult >= (double)this.majors_[i])) continue;
                ik = i;
            }
            return expFloor * this.majors_.length + ik;
        }

        @Override
        public double indexToValue(long index) {
            int[] div = BasicTicker.divFloor((int)index, this.majors_.length);
            int exp = div[0];
            int ik = div[1];
            double value = (double)this.majors_[ik] * BasicTicker.exp10(exp);
            assert (this.floorIndex(value * 1.001) == index || (double)Math.abs(index) > 1.0E13);
            return value;
        }

        @Override
        public double[] getMinors(long index) {
            int[] div = BasicTicker.divFloor((int)index, this.majors_.length);
            int exp = div[0];
            int ik = div[1];
            double base = BasicTicker.exp10(exp);
            double[] kminors = this.minors_[ik];
            double[] minors = new double[kminors.length];
            for (int i = 0; i < kminors.length; ++i) {
                minors[i] = base * kminors[i];
            }
            return minors;
        }

        @Override
        public String indexToLabel(long index) {
            int[] div = BasicTicker.divFloor((int)index, this.majors_.length);
            int exp = div[0];
            int ik = div[1];
            return BasicTicker.logLabel(this.majors_[ik], exp);
        }
    }

    private static class DecadeLogRule
    implements Rule {
        private final int nDecade_;
        private final double[] minors_;

        public DecadeLogRule(int nDecade) {
            this.nDecade_ = nDecade;
            if (nDecade == 1) {
                this.minors_ = new double[]{2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
            } else if (nDecade == 2) {
                this.minors_ = new double[]{10.0, 20.0, 30.0, 40.0, 50.0, 60.0, 70.0, 80.0, 90.0};
            } else if (nDecade <= 10) {
                this.minors_ = new double[this.nDecade_ - 1];
                for (int i = 1; i < this.nDecade_; ++i) {
                    this.minors_[i - 1] = BasicTicker.exp10(i);
                }
            } else {
                this.minors_ = new double[0];
            }
        }

        @Override
        public long floorIndex(double value) {
            return (long)Math.floor(Math.log10(value) / (double)this.nDecade_);
        }

        @Override
        public double indexToValue(long index) {
            double value = BasicTicker.exp10((int)index * this.nDecade_);
            assert (this.floorIndex(value * Math.pow(10.0, (double)this.nDecade_ * 1.0E-8)) == index);
            return value;
        }

        @Override
        public double[] getMinors(long index) {
            double[] minors = new double[this.minors_.length];
            double major = this.indexToValue(index);
            for (int i = 0; i < minors.length; ++i) {
                minors[i] = major * this.minors_[i];
            }
            return minors;
        }

        @Override
        public String indexToLabel(long index) {
            return BasicTicker.logLabel(1L, (int)index * this.nDecade_);
        }
    }

    private static class LinearRule
    implements Rule {
        private final int exp_;
        private final LinearSpacer spacer_;
        private final double mult_;

        LinearRule(int exp, LinearSpacer spacer) {
            this.exp_ = exp;
            this.spacer_ = spacer;
            this.mult_ = BasicTicker.exp10(exp) * (double)spacer.major_;
        }

        @Override
        public long floorIndex(double value) {
            return (long)Math.floor(value / this.mult_);
        }

        @Override
        public double indexToValue(long index) {
            double value = (double)index * this.mult_;
            assert (this.floorIndex(value + 0.01 * this.mult_) == index || (double)Math.abs(index) > 1.0E14);
            return value;
        }

        @Override
        public double[] getMinors(long index) {
            double major = this.indexToValue(index);
            double[] minors = new double[this.spacer_.minors_.length];
            for (int i = 0; i < minors.length; ++i) {
                minors[i] = major + BasicTicker.exp10(this.exp_) * this.spacer_.minors_[i];
            }
            return minors;
        }

        @Override
        public String indexToLabel(long index) {
            long mantissa = index * (long)this.spacer_.major_;
            return BasicTicker.linearLabel(mantissa, this.exp_);
        }
    }

    private static class LogSpacer {
        private final int[] majors_;
        private final double[][] minors_;
        public static final LogSpacer[] SPACERS = new LogSpacer[]{new LogSpacer(new int[]{1, 2, 5}, new double[][]{{1.1, 1.2, 1.3, 1.4, 1.5}, {2.5, 3.0, 3.5, 4.0, 4.5}, {6.0, 7.0, 8.0, 9.0}}), new LogSpacer(new int[]{1, 2, 3, 4, 5}, new double[][]{{1.2, 1.4, 1.6, 1.8}, {2.2, 2.4, 2.6, 2.8}, {3.2, 3.4, 3.6, 3.8}, {4.2, 4.4, 4.6, 4.8}, {6.0, 7.0, 8.0, 9.0}})};

        public LogSpacer(int[] majors, double[][] minors) {
            this.majors_ = majors;
            this.minors_ = minors;
        }
    }

    private static class LinearSpacer {
        private final double thresh_;
        private final int major_;
        private final double[] minors_;
        public static final LinearSpacer[] SPACERS = new LinearSpacer[]{new LinearSpacer(2.5, 1, 0.1), new LinearSpacer(4.5, 2, 0.25), new LinearSpacer(7.5, 5, 1.0)};

        LinearSpacer(double oversizeThresh, int major, double minor) {
            this.thresh_ = oversizeThresh;
            this.major_ = major;
            int nminor = (int)Math.round((double)major / minor);
            this.minors_ = new double[nminor - 1];
            for (int i = 1; i < nminor; ++i) {
                this.minors_[i - 1] = minor * (double)i;
            }
        }

        public static int getSpacerIndex(double oversize) {
            for (int i = 0; i < SPACERS.length; ++i) {
                if (!(oversize <= LinearSpacer.SPACERS[i].thresh_)) continue;
                return i;
            }
            return SPACERS.length;
        }
    }

    public static interface Rule {
        public long floorIndex(double var1);

        public double[] getMinors(long var1);

        public double indexToValue(long var1);

        public String indexToLabel(long var1);
    }
}

