/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.scilab.forge.jlatexmath.ParseException;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;
import uk.ac.starlink.ttools.plot2.BasicCaptioner;
import uk.ac.starlink.ttools.plot2.Captioner;

public class LatexCaptioner
implements Captioner {
    private final int style_;
    private final float size_;
    private final int type_;
    public static final float DEFAULT_SIZE = 16.0f;
    public static final int STYLE_TEXT = 2;
    public static final int STYLE_DISPLAY = 0;
    public static final int STYLE_SCRIPT = 4;
    public static final int STYLE_SCRIPT_SCRIPT = 6;
    public static final int TYPE_SERIF = 0;
    public static final int TYPE_SANSSERIF = 1;
    public static final int TYPE_BOLD = 2;
    public static final int TYPE_ITALIC = 4;
    public static final int TYPE_ROMAN = 8;
    public static final int TYPE_TYPEWRITER = 16;
    private final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2");

    public LatexCaptioner() {
        this(16.0f);
    }

    public LatexCaptioner(float size) {
        this(size, 1);
    }

    public LatexCaptioner(float size, int type) {
        this(size, type, 2);
    }

    public LatexCaptioner(float size, int type, int style) {
        this.size_ = size;
        this.type_ = type;
        this.style_ = style;
    }

    @Override
    public void drawCaption(String label, Graphics g) {
        TeXIcon ti;
        try {
            ti = this.createTeXIcon(label, g.getColor());
        }
        catch (ParseException e) {
            this.getErrorCaptioner().drawCaption(this.getErrorText(label, e), g);
            this.logger_.log(Level.WARNING, "Bad LaTeX: \"" + label + "\" (" + e.getMessage() + ")", e);
            return;
        }
        Insets insets = ti.getInsets();
        ti.paintIcon(null, g.create(), -insets.left, -ti.getIconHeight() + insets.top);
    }

    @Override
    public Rectangle getCaptionBounds(String label) {
        TeXIcon ti;
        try {
            ti = this.createTeXIcon(label, Color.BLACK);
        }
        catch (ParseException e) {
            return this.getErrorCaptioner().getCaptionBounds(this.getErrorText(label, e));
        }
        Insets insets = ti.getInsets();
        Rectangle bounds = new Rectangle(-insets.left, -ti.getIconHeight() + insets.top + insets.bottom, (int)Math.ceil(ti.getTrueIconWidth()), (int)Math.ceil(ti.getTrueIconHeight()));
        return bounds;
    }

    @Override
    public int getPad() {
        return (int)this.size_ / 2;
    }

    private TeXIcon createTeXIcon(String label, Color color) throws ParseException {
        return new TeXFormula(this.adjustLabel(label)).createTeXIcon(this.style_, this.size_, this.type_, color);
    }

    private String adjustLabel(String label) {
        return label.replaceFirst("^-", "\\$-\\$");
    }

    private String getErrorText(String label, ParseException err) {
        return "Bad TeX: " + label;
    }

    private Captioner getErrorCaptioner() {
        return new BasicCaptioner();
    }

    public boolean equals(Object o) {
        if (o instanceof LatexCaptioner) {
            LatexCaptioner other = (LatexCaptioner)o;
            return this.size_ == other.size_ && this.type_ == other.type_ && this.style_ == other.style_;
        }
        return false;
    }

    public int hashCode() {
        int code = 90125;
        code = 23 * code + Float.floatToIntBits(this.size_);
        code = 23 * code + this.type_;
        code = 23 * code + this.style_;
        return code;
    }

    static {
        TeXFormula.registerFonts((boolean)false);
    }
}

