/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Arrays;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.LegendEntry;
import uk.ac.starlink.ttools.plot2.PlotUtil;

@Equality
public class LegendIcon
implements Icon {
    private final LegendEntry[] entries_;
    private final Captioner captioner_;
    private final boolean border_;
    private final Color bgColor_;
    private final int width_;
    private final int height_;
    private final int iconWidth_;
    private final int labelWidth_;
    private final int lineHeight_;

    public LegendIcon(LegendEntry[] entries, Captioner captioner, boolean border, Color bgColor) {
        this.entries_ = entries;
        this.captioner_ = captioner;
        this.border_ = border;
        this.bgColor_ = bgColor;
        int maxHeight = 0;
        int maxIconWidth = 0;
        int maxLabelWidth = 0;
        for (int ie = 0; ie < this.entries_.length; ++ie) {
            LegendEntry entry = this.entries_[ie];
            Rectangle bounds = captioner.getCaptionBounds(entry.getLabel());
            maxHeight = Math.max(bounds.height, maxHeight);
            maxIconWidth = Math.max(entry.getIcon().getIconWidth(), maxIconWidth);
            maxLabelWidth = Math.max(bounds.width, maxLabelWidth);
        }
        this.lineHeight_ = maxHeight;
        this.iconWidth_ = maxIconWidth;
        this.labelWidth_ = maxLabelWidth;
        int gap = captioner.getPad();
        this.width_ = this.iconWidth_ + this.labelWidth_ + gap * 3;
        this.height_ = (this.lineHeight_ + gap) * this.entries_.length + gap;
    }

    public Captioner getCaptioner() {
        return this.captioner_;
    }

    public boolean hasBorder() {
        return this.border_;
    }

    public Color getBackground() {
        return this.bgColor_;
    }

    @Override
    public int getIconWidth() {
        return this.width_;
    }

    @Override
    public int getIconHeight() {
        return this.height_;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x0, int y0) {
        Color color0 = g.getColor();
        if (this.bgColor_ != null) {
            g.setColor(this.bgColor_);
            g.fillRect(x0, y0, this.width_ - 1, this.height_ - 1);
            g.setColor(color0);
        }
        if (this.border_) {
            g.setColor(Color.BLACK);
            g.drawRect(x0, y0, this.width_ - 1, this.height_ - 1);
            g.setColor(color0);
        }
        int gap = this.captioner_.getPad();
        g.setColor(Color.BLACK);
        for (int ie = 0; ie < this.entries_.length; ++ie) {
            LegendEntry entry = this.entries_[ie];
            Icon icon = entry.getIcon();
            int ixp = x0 + gap + (this.iconWidth_ - icon.getIconWidth()) / 2;
            int iyp = y0 + gap + (gap + this.lineHeight_) * ie + (this.lineHeight_ - icon.getIconHeight()) / 2;
            icon.paintIcon(c, g, ixp, iyp);
            int lxp = x0 + gap + this.iconWidth_ + gap;
            int lyp = y0 + (gap + this.lineHeight_) * (ie + 1);
            g.translate(lxp, lyp);
            this.captioner_.drawCaption(entry.getLabel(), g);
            g.translate(-lxp, -lyp);
        }
        g.setColor(color0);
    }

    public boolean equals(Object o) {
        if (o instanceof LegendIcon) {
            LegendIcon other = (LegendIcon)o;
            return Arrays.equals(this.entries_, other.entries_) && this.captioner_.equals(other.captioner_) && this.border_ == other.border_ && PlotUtil.equals(this.bgColor_, other.bgColor_);
        }
        return false;
    }

    public int hashCode() {
        int code = 90125;
        code = 23 * code + Arrays.hashCode(this.entries_);
        code = 23 * code + this.captioner_.hashCode();
        code = 23 * code + (this.border_ ? 5 : 1);
        code = 23 * code + PlotUtil.hashCode(this.bgColor_);
        return code;
    }
}

