/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.Timer;
import uk.ac.starlink.ttools.plot2.Decoration;
import uk.ac.starlink.ttools.plot2.NavAction;
import uk.ac.starlink.ttools.plot2.Navigator;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Surface;

public abstract class NavigationListener<A>
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private final Timer decTimer_ = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            NavigationListener.this.setDecoration(null);
        }
    });
    private DragContext dragged_;
    private static final int DECORATION_AUTO_MILLIS = 500;

    protected NavigationListener() {
    }

    public abstract int getSurfaceIndex(Point var1);

    public abstract Surface getSurface(int var1);

    public abstract Navigator<A> getNavigator(int var1);

    public abstract Iterable<double[]> createDataPosIterable(Point var1);

    protected abstract void setAspect(int var1, A var2);

    protected abstract void setDecoration(Decoration var1);

    public void updateDecoration(Decoration dec, boolean autoCancel) {
        this.decTimer_.stop();
        this.setDecoration(dec);
        if (autoCancel && dec != null) {
            this.decTimer_.start();
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        Point pos = evt.getPoint();
        int isurf = this.getSurfaceIndex(pos);
        Surface surface = this.getSurface(isurf);
        this.dragged_ = surface == null ? null : new DragContext(isurf, surface, pos);
        Navigator<A> navigator = this.getNavigator(isurf);
        if (this.dragged_ != null && navigator != null) {
            Decoration dragDec;
            int ibutt = PlotUtil.getButtonDownIndex(evt);
            NavAction<A> drag0act = navigator.drag(this.dragged_.surface_, pos, ibutt, this.dragged_.start_);
            Decoration decoration = dragDec = drag0act == null ? null : drag0act.getDecoration();
            if (dragDec != null) {
                this.updateDecoration(dragDec, false);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        int ibutt;
        Point pos;
        NavAction<A> navact;
        Navigator<A> navigator;
        if (this.dragged_ != null && (navigator = this.getNavigator(this.dragged_.isurf_)) != null && (navact = navigator.drag(this.dragged_.surface_, pos = evt.getPoint(), ibutt = PlotUtil.getButtonDownIndex(evt), this.dragged_.start_)) != null) {
            this.updateDecoration(navact.getDecoration(), false);
            A aspect = navact.getAspect();
            if (aspect != null) {
                this.setAspect(this.dragged_.isurf_, aspect);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (this.dragged_ != null) {
            Object aspect;
            NavAction<A> navact;
            Navigator<A> navigator = this.getNavigator(this.dragged_.isurf_);
            if (navigator != null) {
                Point pos = evt.getPoint();
                int ibutt = PlotUtil.getButtonChangedIndex(evt);
                navact = navigator.endDrag(this.dragged_.surface_, pos, ibutt, this.dragged_.start_);
            } else {
                navact = null;
            }
            Decoration dec = navact == null ? null : navact.getDecoration();
            this.updateDecoration(dec, false);
            if (navact != null && (aspect = navact.getAspect()) != null) {
                this.setAspect(this.dragged_.isurf_, aspect);
            }
        }
        this.dragged_ = null;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        int isurf;
        Navigator<A> navigator;
        Point pos = evt.getPoint();
        int ibutt = PlotUtil.getButtonChangedIndex(evt);
        if (ibutt == 3 && (navigator = this.getNavigator(isurf = this.getSurfaceIndex(pos))) != null) {
            this.handleClick(navigator, isurf, pos, ibutt, this.createDataPosIterable(pos));
        }
    }

    protected void handleClick(Navigator<A> navigator, int isurf, Point pos, int ibutt, Iterable<double[]> dposIt) {
        Surface surface = this.getSurface(isurf);
        NavAction<A> navact = navigator.click(surface, pos, ibutt, dposIt);
        if (navact != null) {
            this.updateDecoration(navact.getDecoration(), true);
            A aspect = navact.getAspect();
            if (aspect != null) {
                this.setAspect(isurf, aspect);
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
        int wheelrot;
        NavAction<A> navact;
        Point pos = evt.getPoint();
        int isurf = this.getSurfaceIndex(pos);
        Navigator<A> navigator = this.getNavigator(isurf);
        Surface surface = this.getSurface(isurf);
        if (navigator != null && surface != null && (navact = navigator.wheel(surface, pos, wheelrot = evt.getWheelRotation())) != null) {
            this.updateDecoration(navact.getDecoration(), true);
            A aspect = navact.getAspect();
            if (aspect != null) {
                this.setAspect(isurf, aspect);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    public void addListeners(Component component) {
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        component.addMouseWheelListener(this);
    }

    public void removeListeners(Component component) {
        component.removeMouseListener(this);
        component.removeMouseMotionListener(this);
        component.removeMouseWheelListener(this);
    }

    private static class DragContext {
        final int isurf_;
        final Surface surface_;
        final Point start_;

        DragContext(int isurf, Surface surface, Point start) {
            this.isurf_ = isurf;
            this.surface_ = surface;
            this.start_ = start;
        }
    }
}

