/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;

public abstract class Orientation {
    public static final Orientation X = new Orientation(){

        @Override
        public AffineTransform captionTransform(Rectangle bounds, int pad) {
            return AffineTransform.getTranslateInstance(-bounds.width / 2, -bounds.y + pad);
        }

        @Override
        public boolean isDown() {
            return true;
        }
    };
    public static final Orientation Y = new Orientation(){

        @Override
        public AffineTransform captionTransform(Rectangle bounds, int pad) {
            AffineTransform trans = new AffineTransform();
            trans.rotate(1.5707963267948966);
            trans.translate(-bounds.width - pad, -bounds.y / 2);
            return trans;
        }

        @Override
        public boolean isDown() {
            return false;
        }
    };
    public static final Orientation ANTI_Y = new Orientation(){

        @Override
        public AffineTransform captionTransform(Rectangle bounds, int pad) {
            AffineTransform trans = new AffineTransform();
            trans.rotate(1.5707963267948966);
            trans.translate(pad, -bounds.y / 2);
            return trans;
        }

        @Override
        public boolean isDown() {
            return true;
        }
    };

    public abstract AffineTransform captionTransform(Rectangle var1, int var2);

    public abstract boolean isDown();
}

