/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.Decoration;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.Padding;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ShadeAxis;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;

@Equality
public class PlotPlacement {
    private final Rectangle bounds_;
    private final Surface surface_;
    private final List<Decoration> decorations_;
    private static final int EXTERNAL_LEGEND_GAP = 10;
    private static final int MIN_DIM = 24;
    private static final int PAD = 2;

    public PlotPlacement(Rectangle bounds, Surface surface) {
        this(bounds, surface, new Decoration[0]);
    }

    public PlotPlacement(Rectangle bounds, Surface surface, Decoration[] decorations) {
        this.bounds_ = bounds;
        this.surface_ = surface;
        this.decorations_ = new ArrayList<Decoration>(Arrays.asList(decorations));
    }

    public Rectangle getBounds() {
        return this.bounds_;
    }

    public Surface getSurface() {
        return this.surface_;
    }

    public List<Decoration> getDecorations() {
        return this.decorations_;
    }

    public Icon createPlotIcon(final Icon dataIcon) {
        final Rectangle plotBounds = this.surface_.getPlotBounds();
        return new Icon(){

            @Override
            public int getIconWidth() {
                return ((PlotPlacement)PlotPlacement.this).bounds_.width;
            }

            @Override
            public int getIconHeight() {
                return ((PlotPlacement)PlotPlacement.this).bounds_.height;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                int xoff = x - ((PlotPlacement)PlotPlacement.this).bounds_.x;
                int yoff = y - ((PlotPlacement)PlotPlacement.this).bounds_.y;
                g.translate(xoff, yoff);
                this.paintPlot(c, g);
                g.translate(-xoff, -yoff);
            }

            private void paintPlot(Component c, Graphics g) {
                Shape clip0 = g.getClip();
                g.clipRect(plotBounds.x, plotBounds.y, plotBounds.width, plotBounds.height);
                dataIcon.paintIcon(c, g, plotBounds.x, plotBounds.y);
                g.setClip(clip0);
                PlotPlacement.this.surface_.paintForeground(g);
                for (Decoration dec : PlotPlacement.this.decorations_) {
                    dec.paintDecoration(g);
                }
            }
        };
    }

    public boolean equals(Object o) {
        if (o instanceof PlotPlacement) {
            PlotPlacement other = (PlotPlacement)o;
            return this.bounds_.equals(other.bounds_) && this.surface_.equals(other.surface_) && ((Object)this.decorations_).equals(other.decorations_);
        }
        return false;
    }

    public int hashCode() {
        int code = 239991;
        code = 23 * code + this.bounds_.hashCode();
        code = 23 * code + this.surface_.hashCode();
        code = 23 * code + ((Object)this.decorations_).hashCode();
        return code;
    }

    public static <P, A> PlotPlacement createPlacement(Rectangle extBounds, Padding padding, SurfaceFactory<P, A> surfFact, P profile, A aspect, boolean withScroll, Icon legend, float[] legPos, String title, ShadeAxis shadeAxis) {
        Rectangle dataBounds = PlotPlacement.calculateDataBounds(extBounds, padding, surfFact, profile, aspect, withScroll, legend, legPos, title, shadeAxis);
        Surface surf = surfFact.createSurface(dataBounds, profile, aspect);
        Decoration[] decs = PlotPlacement.createPlotDecorations(surf, legend, legPos, title, shadeAxis);
        return new PlotPlacement(extBounds, surf, decs);
    }

    public static <P, A> Insets calculateDataInsets(Rectangle extBounds, SurfaceFactory<P, A> surfFact, P profile, A aspect, boolean withScroll, Icon legend, float[] legPos, String title, ShadeAxis shadeAxis, int pad) {
        boolean hasExtLegend = legend != null && legPos == null;
        Insets decInsets = new Insets(0, 0, 0, 0);
        if (hasExtLegend) {
            decInsets.right = Math.max(decInsets.right, legend.getIconWidth() + 10);
        }
        if (shadeAxis != null) {
            Rectangle rampBox = new Rectangle(0, 0, shadeAxis.getRampWidth(), extBounds.height);
            decInsets.right = Math.max(decInsets.right, rampBox.width + shadeAxis.getRampInsets((Rectangle)rampBox).right + 10);
            int yShadePad = shadeAxis.getEndPadding();
            if (!hasExtLegend) {
                decInsets.top = Math.max(decInsets.top, yShadePad);
            }
            decInsets.bottom = Math.max(decInsets.bottom, yShadePad);
        }
        if (title != null) {
            Captioner captioner = surfFact.createSurface(extBounds, profile, aspect).getCaptioner();
            decInsets.top = Math.max(decInsets.top, captioner.getCaptionBounds((String)title).height + captioner.getPad());
        }
        Insets padInsets = new Insets(2, 2, 2, 2);
        Insets insets = (Insets)decInsets.clone();
        int nit = withScroll ? 1 : 4;
        for (int i = 0; i < nit; ++i) {
            Rectangle plotBounds = PlotUtil.subtractInsets(PlotUtil.subtractInsets(extBounds, insets), padInsets);
            plotBounds.width = Math.max(plotBounds.width, 24);
            plotBounds.height = Math.max(plotBounds.height, 24);
            Surface surf = surfFact.createSurface(plotBounds, profile, aspect);
            Insets axisInsets = surf.getPlotInsets(withScroll);
            insets.top = Math.max(insets.top, axisInsets.top);
            insets.left = Math.max(insets.left, axisInsets.left);
            insets.bottom = Math.max(insets.bottom, axisInsets.bottom);
            insets.right = Math.max(insets.right, axisInsets.right);
        }
        insets.top += padInsets.top;
        insets.left += padInsets.left;
        insets.bottom += padInsets.bottom;
        insets.right += padInsets.right;
        return insets;
    }

    public static <P, A> Rectangle calculateDataBounds(Rectangle extBounds, Padding padding, SurfaceFactory<P, A> surfFact, P profile, A aspect, boolean withScroll, Icon legend, float[] legPos, String title, ShadeAxis shadeAxis) {
        Insets insets;
        Padding padding2 = padding = padding == null ? new Padding() : padding;
        if (padding.isDefinite()) {
            insets = padding.toDefiniteInsets();
        } else {
            Insets dataInsets = PlotPlacement.calculateDataInsets(extBounds, surfFact, profile, aspect, withScroll, legend, legPos, title, shadeAxis, 2);
            insets = padding.overrideInsets(dataInsets);
        }
        return PlotUtil.subtractInsets(extBounds, insets);
    }

    public static Decoration[] createPlotDecorations(Surface surf, Icon legend, float[] legPos, String title, ShadeAxis shadeAxis) {
        Rectangle dataBounds = surf.getPlotBounds();
        Insets insets = surf.getPlotInsets(false);
        ArrayList<Decoration> decList = new ArrayList<Decoration>();
        int gxlo = dataBounds.x;
        int gylo = dataBounds.y;
        int gxhi = dataBounds.x + dataBounds.width;
        int gyhi = dataBounds.y + dataBounds.height;
        if (legend != null) {
            int ly;
            int lx;
            if (legPos == null) {
                lx = gxhi + 10;
                ly = gylo;
            } else {
                lx = gxlo + Math.round((float)(gxhi - gxlo - legend.getIconWidth()) * legPos[0]);
                ly = gylo + Math.round((float)(gyhi - gylo - legend.getIconHeight()) * (1.0f - legPos[1]));
            }
            decList.add(new Decoration(legend, lx, ly));
        }
        if (shadeAxis != null) {
            int sx = gxhi + 10;
            boolean hasExtLegend = legend != null && legPos == null;
            int sy = gylo;
            if (hasExtLegend) {
                sy += legend.getIconHeight() + Math.max(shadeAxis.getEndPadding() + 2, 10);
            }
            Rectangle rampBox = new Rectangle(sx, sy, shadeAxis.getRampWidth(), gyhi - sy);
            Icon shadeIcon = shadeAxis.createAxisIcon(rampBox);
            decList.add(new Decoration(shadeIcon, sx, sy));
        }
        if (title != null) {
            Captioner captioner = surf.getCaptioner();
            CaptionIcon titleIcon = new CaptionIcon(title, captioner);
            int px = dataBounds.x + dataBounds.width / 2 - titleIcon.getIconWidth() / 2;
            int py = dataBounds.y - titleIcon.getIconHeight() - captioner.getPad();
            decList.add(new Decoration(titleIcon, px, py));
        }
        return decList.toArray(new Decoration[0]);
    }

    @Equality
    private static class CaptionIcon
    implements Icon {
        private final String text_;
        private final Captioner captioner_;
        private final int width_;
        private final int height_;
        private final int x_;
        private final int y_;

        CaptionIcon(String text, Captioner captioner) {
            this.text_ = text;
            this.captioner_ = captioner;
            Rectangle bounds = captioner.getCaptionBounds(text);
            this.x_ = 0;
            this.y_ = -bounds.y;
            this.width_ = bounds.width;
            this.height_ = bounds.height;
        }

        @Override
        public int getIconWidth() {
            return this.width_;
        }

        @Override
        public int getIconHeight() {
            return this.height_;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int xoff = x + this.x_;
            int yoff = y + this.y_;
            Color color0 = g.getColor();
            g.setColor(Color.BLACK);
            g.translate(xoff, yoff);
            this.captioner_.drawCaption(this.text_, g);
            g.translate(-xoff, -yoff);
            g.setColor(color0);
        }

        public int hashCode() {
            int code = 4432;
            code = 23 * this.text_.hashCode();
            code = 23 * this.captioner_.hashCode();
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof CaptionIcon) {
                CaptionIcon other = (CaptionIcon)o;
                return this.text_.equals(other.text_) && this.captioner_.equals(other.captioner_);
            }
            return false;
        }
    }
}

