/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.PdfGraphicExporter;
import uk.ac.starlink.ttools.plot.Picture;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.Gang;
import uk.ac.starlink.ttools.plot2.IndicatedRow;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotPlacement;
import uk.ac.starlink.ttools.plot2.PointCloud;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.Slow;
import uk.ac.starlink.ttools.plot2.SubCloud;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.layer.BinList;
import uk.ac.starlink.ttools.plot2.paper.PaperType;

public class PlotUtil {
    private static Boolean dfltAntialias_;
    private static final Logger logger_;
    public static final TupleSequence EMPTY_TUPLE_SEQUENCE;
    private static final String LATEX_FONT_PATHS = "latex_fonts.txt";
    public static final PdfGraphicExporter LATEX_PDF_EXPORTER;
    public static final double NEAR_PIXELS = 4.0;
    public static final int DEFAULT_MAX_PIXELS = 20;
    public static final short MAX_MARKSIZE = 100;
    public static final int MIN_RAMP_UNIT = 12;
    private static final double PAD_FRACTION = 0.02;
    private static final Level REPORT_LEVEL;

    private PlotUtil() {
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public static int hashCode(Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }

    public static boolean storeFullPrecision() {
        return true;
    }

    public static synchronized boolean getDefaultTextAntialiasing() {
        if (dfltAntialias_ == null) {
            String os;
            try {
                os = System.getProperty("os.name");
            }
            catch (SecurityException e) {
                os = "?";
            }
            boolean isMac = os != null && (os.toLowerCase().indexOf("macos") >= 0 || os.toLowerCase().indexOf("mac os") >= 0);
            dfltAntialias_ = isMac;
            logger_.info("Use default text antialias setting " + dfltAntialias_ + " (os.name=" + os + ")");
        }
        return dfltAntialias_;
    }

    public static String getIndexSuffix(int ipos) {
        return Integer.toString(1 + ipos);
    }

    public static void logTimeElapsed(Logger logger, String phase, long elapsed) {
        if (elapsed > 0L) {
            logger.info(phase + " time: " + elapsed);
        }
    }

    public static void logTimeFromStart(Logger logger, String phase, long start) {
        PlotUtil.logTimeElapsed(logger, phase, System.currentTimeMillis() - start);
    }

    public static <T> T[] arrayConcat(T[] a1, T[] a2) {
        int count = a1.length + a2.length;
        ArrayList<T> list = new ArrayList<T>(count);
        list.addAll(Arrays.asList(a1));
        list.addAll(Arrays.asList(a2));
        Class<?> eClazz = a1.getClass().getComponentType();
        Object[] result = list.toArray((Object[])Array.newInstance(eClazz, count));
        return result;
    }

    public static String concatLines(String[] lines) {
        int leng = 0;
        for (String line : lines) {
            leng += line.length() + 1;
        }
        StringBuffer sbuf = new StringBuffer(leng);
        for (String line : lines) {
            sbuf.append(line).append('\n');
        }
        return sbuf.toString();
    }

    public static double toDouble(Number value) {
        return value == null ? Double.NaN : value.doubleValue();
    }

    public static boolean isFinite(double value) {
        return !Double.isNaN(value) && !Double.isInfinite(value);
    }

    public static boolean isPointFinite(Point2D.Double gp) {
        return PlotUtil.isFinite(gp.x) && PlotUtil.isFinite(gp.y);
    }

    public static boolean isPointReal(Point2D.Double gp) {
        return !Double.isNaN(gp.x) && !Double.isNaN(gp.y);
    }

    public static void quantisePoint(Point2D.Double dpos, Point gpos) {
        gpos.x = PlotUtil.ifloor(dpos.x);
        gpos.y = PlotUtil.ifloor(dpos.y);
    }

    public static int ifloor(double x) {
        int y = (int)x;
        return x >= 0.0 || x == (double)y || y == Integer.MIN_VALUE ? y : y - 1;
    }

    public static double[] orderPair(double p1, double p2) {
        double[] dArray;
        if (p1 <= p2) {
            double[] dArray2 = new double[2];
            dArray2[0] = p1;
            dArray = dArray2;
            dArray2[1] = p2;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = p2;
            dArray = dArray3;
            dArray3[1] = p1;
        }
        return dArray;
    }

    public static Rectangle getGangBounds(Gang gang) {
        int nz = gang.getZoneCount();
        int xmin = Integer.MAX_VALUE;
        int ymin = Integer.MAX_VALUE;
        int xmax = Integer.MIN_VALUE;
        int ymax = Integer.MIN_VALUE;
        for (int iz = 0; iz < nz; ++iz) {
            Rectangle rect = gang.getZonePlotBounds(iz);
            xmin = Math.min(xmin, rect.x);
            ymin = Math.min(ymin, rect.y);
            xmax = Math.max(xmax, rect.x + rect.width);
            ymax = Math.max(ymax, rect.y + rect.height);
        }
        return xmax >= xmin && ymax >= ymin ? new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin) : null;
    }

    public static <T> T[] singletonArray(T object) {
        Object[] array = (Object[])Array.newInstance(object.getClass(), 1);
        array[0] = object;
        return array;
    }

    public static <P> P[] createProfileArray(SurfaceFactory<P, ?> surfFact, int length) {
        P profile = surfFact.createProfile(new ConfigMap());
        Object[] array = (Object[])Array.newInstance(profile.getClass(), length);
        return array;
    }

    public static <P, A> A[] createAspectArray(SurfaceFactory<P, A> surfFact, int length) {
        ConfigMap config = new ConfigMap();
        P profile = surfFact.createProfile(config);
        A aspect = surfFact.createAspect(profile, config, null);
        Object[] array = (Object[])Array.newInstance(aspect.getClass(), length);
        return array;
    }

    public static Picture toPicture(final Icon icon) {
        return new Picture(){

            @Override
            public int getPictureWidth() {
                return icon.getIconWidth();
            }

            @Override
            public int getPictureHeight() {
                return icon.getIconHeight();
            }

            @Override
            public void paintPicture(Graphics2D g2) {
                icon.paintIcon(null, g2, 0, 0);
            }
        };
    }

    @Slow
    public static Range[] readCoordinateRanges(PlotLayer[] layers, int nDataDim, boolean[] logFlags, DataStore dataStore) {
        Range[] ranges = new Range[nDataDim];
        for (int idim = 0; idim < nDataDim; ++idim) {
            ranges[idim] = new Range();
        }
        SubCloud[] subClouds = PlotUtil.arrayConcat(SubCloud.createSubClouds(layers, true), SubCloud.createPartialSubClouds(layers, true));
        PointCloud cloud = new PointCloud(subClouds);
        for (double[] dpos : cloud.createDataPosIterable(dataStore)) {
            for (int idim = 0; idim < nDataDim; ++idim) {
                ranges[idim].submit(dpos[idim]);
            }
        }
        boolean[] lflags = logFlags == null ? new boolean[nDataDim] : logFlags;
        for (int il = 0; il < layers.length; ++il) {
            layers[il].extendCoordinateRanges(ranges, lflags, dataStore);
        }
        for (int idim = 0; idim < nDataDim; ++idim) {
            PlotUtil.padRange(ranges[idim], logFlags[idim]);
        }
        return ranges;
    }

    public static void padRange(Range range, boolean logFlag) {
        double hi;
        double[] bounds = range.getBounds();
        double lo = bounds[0];
        if (lo < (hi = bounds[1])) {
            boolean hiNearZero;
            boolean loNearZero;
            double padFrac = 0.02;
            if (logFlag) {
                loNearZero = false;
                hiNearZero = false;
            } else {
                double ztol = 2.0 * padFrac;
                double zfrac = PlotUtil.unscaleValue(lo, hi, 0.0, logFlag);
                loNearZero = 0.0 - zfrac >= 0.0 && 0.0 - zfrac <= ztol;
                hiNearZero = zfrac - 1.0 >= 0.0 && zfrac - 1.0 <= ztol;
            }
            range.submit(loNearZero ? 0.0 : PlotUtil.scaleValue(lo, hi, 0.0 - padFrac, logFlag));
            range.submit(hiNearZero ? 0.0 : PlotUtil.scaleValue(lo, hi, 1.0 + padFrac, logFlag));
        }
    }

    public static void extendRange(Range range, BinList.Result binResult) {
        Iterator<Long> it = binResult.indexIterator();
        while (it.hasNext()) {
            range.submit(binResult.getBinValue(it.next()));
        }
    }

    @Slow
    public static IndicatedRow getClosestRow(Surface surface, DataGeom geom, int iPosCoord, TupleSequence tseq, Point2D point) {
        double[] dpos = new double[surface.getDataDimCount()];
        Point2D.Double gp = new Point2D.Double();
        long bestIndex = -1L;
        double bestDist2 = Double.POSITIVE_INFINITY;
        while (tseq.next()) {
            double dist2;
            if (!geom.readDataPos(tseq, iPosCoord, dpos) || !surface.dataToGraphics(dpos, true, gp) || !((dist2 = gp.distanceSq(point)) < bestDist2)) continue;
            bestDist2 = dist2;
            bestIndex = tseq.getRowIndex();
        }
        return Thread.currentThread().isInterrupted() || bestIndex < 0L ? null : new IndicatedRow(bestIndex, Math.sqrt(bestDist2));
    }

    @Slow
    public static Icon createPlotIcon(PlotPlacement placer, PlotLayer[] layers, Map<AuxScale, Range> auxRanges, DataStore dataStore, PaperType paperType, boolean cached, Collection<Object> storedPlans) {
        Surface surface = placer.getSurface();
        int nl = layers.length;
        logger_.info("Layers: " + nl + ", Paper: " + paperType);
        Drawing[] drawings = new Drawing[nl];
        Object[] plans = new Object[nl];
        HashSet<Object> knownPlans = new HashSet<Object>();
        if (storedPlans != null) {
            knownPlans.addAll(storedPlans);
        }
        for (int il = 0; il < nl; ++il) {
            drawings[il] = layers[il].createDrawing(surface, auxRanges, paperType);
            plans[il] = drawings[il].calculatePlan(knownPlans.toArray(), dataStore);
            knownPlans.add(plans[il]);
        }
        if (storedPlans != null) {
            storedPlans.clear();
            storedPlans.addAll(new HashSet<Object>(Arrays.asList(plans)));
        }
        Icon dataIcon = paperType.createDataIcon(surface, drawings, plans, dataStore, cached);
        if (logger_.isLoggable(REPORT_LEVEL)) {
            for (int il = 0; il < nl; ++il) {
                String rtxt;
                ReportMap report = drawings[il].getReport(plans[il]);
                if (report == null || (rtxt = report.toString(false)).length() <= 0) continue;
                String msg = new StringBuffer().append("Layer ").append(il).append(": ").append(rtxt).toString();
                logger_.log(REPORT_LEVEL, msg);
            }
        }
        return placer.createPlotIcon(dataIcon);
    }

    public static int getButtonChangedIndex(MouseEvent evt) {
        int iButt = evt.getButton();
        int exmods = evt.getModifiersEx();
        if (iButt == 3) {
            return 3;
        }
        if (iButt == 2) {
            return 2;
        }
        if (iButt == 0) {
            return 0;
        }
        assert (iButt == 1);
        if ((exmods & 0x80) != 0) {
            return 3;
        }
        if ((exmods & 0x40) != 0) {
            return 2;
        }
        return 1;
    }

    public static int getButtonDownIndex(MouseEvent evt) {
        int exmods = evt.getModifiersEx();
        if ((exmods & 0x1000) != 0) {
            return 3;
        }
        if ((exmods & 0x800) != 0) {
            return 2;
        }
        if ((exmods & 0x400) != 0) {
            if ((exmods & 0x80) != 0) {
                return 3;
            }
            if ((exmods & 0x40) != 0) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static double toZoom(double unitFactor, int wheelrot) {
        return Math.pow(unitFactor, -wheelrot);
    }

    public static double toZoom(double unitFactor, Point p0, Point p1, Boolean isY) {
        int dx = p1.x - p0.x;
        int dy = -p1.y + p0.y;
        int npix = isY == null ? dx + dy : (isY != false ? dy : dx);
        return Math.pow(unitFactor, (double)npix / 24.0);
    }

    public static double scaleValue(double min, double max, double frac, boolean isLog) {
        return isLog ? min * Math.pow(max / min, frac) : min + (max - min) * frac;
    }

    public static double unscaleValue(double min, double max, double point, boolean isLog) {
        return isLog ? (Math.log(point) - Math.log(min)) / (Math.log(max) - Math.log(min)) : (point - min) / (max - min);
    }

    public static double[] scaleRange(double min, double max, Subrange subrange, boolean isLog) {
        return new double[]{PlotUtil.scaleValue(min, max, subrange.getLow(), isLog), PlotUtil.scaleValue(min, max, subrange.getHigh(), isLog)};
    }

    public static boolean approxEquals(double v0, double v1) {
        if (v0 == 0.0) {
            return v1 == 0.0;
        }
        double r = v1 / v0;
        return r >= 0.9999 && r <= 1.0001;
    }

    public static String formatNumber(double value, String baseFmt, int nFracDigits) {
        DecimalFormat fmt = new DecimalFormat(baseFmt);
        fmt.setMaximumFractionDigits(nFracDigits);
        fmt.setMinimumFractionDigits(nFracDigits);
        return fmt.format(value);
    }

    public static String formatNumber(double value, double epsilon) {
        epsilon = Math.abs(epsilon);
        double aval = Math.abs(value);
        int nsf = Math.max(0, (int)Math.round(-Math.log10(epsilon / aval)));
        if (aval >= 1000000.0 || aval <= 1.0E-4) {
            return PlotUtil.formatNumber(value, "0.#E0", nsf);
        }
        if (epsilon >= 0.9) {
            return Long.toString(Math.round(value));
        }
        int ndp = (int)Math.round(Math.max(0.0, -Math.log10(epsilon)));
        return ndp == 0 ? Long.toString(Math.round(value)) : PlotUtil.formatNumber(value, "0.0", ndp);
    }

    public static double roundNumber(double x, double epsilon) {
        if (Double.isNaN(x)) {
            return x;
        }
        try {
            return Double.parseDouble(PlotUtil.formatNumber(x, epsilon));
        }
        catch (NumberFormatException e) {
            assert (false) : PlotUtil.formatNumber(x, epsilon) + " -> " + e;
            return x;
        }
    }

    public static ConfigMap configLimits(ConfigKey<Double> minKey, ConfigKey<Double> maxKey, double min, double max, int npix) {
        double epsilon = (max - min) / (double)npix;
        ConfigMap config = new ConfigMap();
        config.put(minKey, PlotUtil.roundNumber(min, epsilon));
        config.put(maxKey, PlotUtil.roundNumber(max, epsilon));
        return config;
    }

    public static Rectangle subtractInsets(Rectangle base, Insets insets) {
        return new Rectangle(base.x + insets.left, base.y + insets.top, base.width - insets.left - insets.right, base.height - insets.top - insets.bottom);
    }

    static {
        logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2");
        EMPTY_TUPLE_SEQUENCE = new TupleSequence(){

            @Override
            public boolean next() {
                return false;
            }

            @Override
            public long getRowIndex() {
                return -1L;
            }

            @Override
            public Object getObjectValue(int icol) {
                throw new IllegalStateException();
            }

            @Override
            public double getDoubleValue(int icol) {
                throw new IllegalStateException();
            }

            @Override
            public int getIntValue(int icol) {
                throw new IllegalStateException();
            }

            @Override
            public boolean getBooleanValue(int icol) {
                throw new IllegalStateException();
            }
        };
        LATEX_PDF_EXPORTER = PdfGraphicExporter.createExternalFontExporter(PlotUtil.class.getResource(LATEX_FONT_PATHS));
        REPORT_LEVEL = Level.INFO;
    }
}

