/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.SubCloud;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;

@Equality
public class PointCloud {
    private final int ndim_;
    private final SubCloud[] subClouds_;

    public PointCloud(SubCloud[] subClouds) {
        this.subClouds_ = subClouds;
        this.ndim_ = subClouds.length > 0 ? subClouds[0].getDataGeom().getDataDimCount() : 0;
    }

    public PointCloud(SubCloud subCloud) {
        this(new SubCloud[]{subCloud});
    }

    public Iterable<double[]> createDataPosIterable(final DataStore dataStore) {
        return new Iterable<double[]>(){

            @Override
            public Iterator<double[]> iterator() {
                return new DataPosIterator(dataStore);
            }
        };
    }

    public SubCloud[] getSubClouds() {
        return this.subClouds_;
    }

    public int hashCode() {
        int code = 74433;
        code = 23 * code + PointCloud.unorderedHashCode(this.subClouds_);
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof PointCloud) {
            PointCloud other = (PointCloud)o;
            assert (PointCloud.unorderedEquals(this.subClouds_, other.subClouds_) == PointCloud.unorderedEquals(other.subClouds_, this.subClouds_));
            return PointCloud.unorderedEquals(this.subClouds_, other.subClouds_);
        }
        return false;
    }

    private static int unorderedHashCode(Object[] array) {
        int code = 0;
        for (int i = 0; i < array.length; ++i) {
            code += array[i].hashCode();
        }
        return code;
    }

    private static boolean unorderedEquals(Object[] array1, Object[] array2) {
        if (Arrays.equals(array1, array2)) {
            return true;
        }
        if (array1.length != array2.length) {
            return false;
        }
        ArrayList<Object> l2 = new ArrayList<Object>(Arrays.asList(array2));
        for (Object item : array1) {
            if (l2.remove(item)) continue;
            return false;
        }
        assert (l2.isEmpty());
        assert (PointCloud.unorderedHashCode(array1) == PointCloud.unorderedHashCode(array2));
        return true;
    }

    private class DataPosIterator
    implements Iterator<double[]> {
        private final DataStore dataStore_;
        private final Iterator<SubCloud> cloudIt_;
        private final double[] dpos_;
        private final double[] dpos1_;
        private final Point gp_;
        private DataGeom geom_;
        private int iPosCoord_;
        private TupleSequence tseq_;
        private boolean hasNext_;

        DataPosIterator(DataStore dataStore) {
            this.dataStore_ = dataStore;
            this.cloudIt_ = Arrays.asList(PointCloud.this.subClouds_).iterator();
            this.dpos_ = new double[PointCloud.this.ndim_];
            this.dpos1_ = new double[PointCloud.this.ndim_];
            this.gp_ = new Point();
            this.tseq_ = PlotUtil.EMPTY_TUPLE_SEQUENCE;
            this.hasNext_ = this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext_;
        }

        @Override
        public double[] next() {
            if (this.hasNext_) {
                System.arraycopy(this.dpos_, 0, this.dpos1_, 0, PointCloud.this.ndim_);
                this.hasNext_ = this.advance();
                return this.dpos1_;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean advance() {
            while (this.tseq_.next()) {
                if (!this.geom_.readDataPos(this.tseq_, this.iPosCoord_, this.dpos_)) continue;
                return true;
            }
            if (this.cloudIt_.hasNext()) {
                SubCloud cloud = this.cloudIt_.next();
                this.geom_ = cloud.getDataGeom();
                this.iPosCoord_ = cloud.getPosCoordIndex();
                this.tseq_ = this.dataStore_.getTupleSequence(cloud.getDataSpec());
                return this.advance();
            }
            return false;
        }
    }
}

