/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.util.ArrayList;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.BasicTicker;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.Orientation;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Tick;
import uk.ac.starlink.ttools.plot2.Ticker;

public abstract class PrefixTicker
implements Ticker {
    private final boolean logFlag_;
    private final BasicTicker basicTicker_;

    public PrefixTicker(boolean logFlag) {
        this.logFlag_ = logFlag;
        this.basicTicker_ = new BasicTicker(logFlag){

            @Override
            public BasicTicker.Rule createRule(double dlo, double dhi, double approxMajorCount, int adjust) {
                return PrefixTicker.this.createRule(dlo, dhi, approxMajorCount, adjust);
            }
        };
    }

    public abstract Rule createRule(double var1, double var3, double var5, int var7);

    @Override
    public Tick[] getTicks(double dlo, double dhi, boolean withMinor, Captioner captioner, Orientation orient, int npix, double crowding) {
        Rule rule = this.getRule(dlo, dhi, captioner, orient, npix, crowding);
        Tick[] majors = this.getMajorTicks(rule, dlo, dhi);
        return withMinor ? PlotUtil.arrayConcat(majors, BasicTicker.getMinorTicks(rule, dlo, dhi)) : majors;
    }

    private Rule getRule(double dlo, double dhi, Captioner captioner, Orientation orient, int npix, double crowding) {
        Rule rule;
        Tick[] majors;
        if (dhi <= dlo) {
            throw new IllegalArgumentException("Bad range: " + dlo + " .. " + dhi);
        }
        double approxMajorCount = (double)Math.max(1, npix / 80) * crowding;
        Axis axis = Axis.createAxis(0, npix, dlo, dhi, this.logFlag_, false);
        int adjust = 0;
        while (BasicTicker.overlaps(majors = this.getMajorTicks(rule = this.createRule(dlo, dhi, approxMajorCount, adjust), dlo, dhi), axis, captioner, orient) && adjust-- > -5) {
        }
        return rule;
    }

    private Tick[] getMajorTicks(Rule rule, double dlo, double dhi) {
        ArrayList<Tick> list = new ArrayList<Tick>();
        String lastPrefix = "";
        boolean usedPrefix = false;
        long index = rule.floorIndex(dlo) - 1L;
        while (rule.indexToValue(index) <= dhi) {
            double major = rule.indexToValue(index);
            String prefix = rule.indexToPrefix(index);
            String string = prefix = prefix == null ? "" : prefix;
            if (major >= dlo && major <= dhi) {
                String suffix = rule.indexToLabel(index);
                boolean pre = !prefix.equals(lastPrefix);
                usedPrefix = usedPrefix || pre;
                list.add(new Tick(major, pre ? prefix + suffix : suffix));
            }
            lastPrefix = prefix;
            ++index;
        }
        Tick[] ticks = list.toArray(new Tick[0]);
        if (lastPrefix.length() > 0 && !usedPrefix && ticks.length > 0) {
            int imid = 0;
            Tick tick = ticks[imid];
            ticks[imid] = new Tick(tick.getValue(), lastPrefix + tick.getLabel());
        }
        return ticks;
    }

    public static interface Rule
    extends BasicTicker.Rule {
        public String indexToPrefix(long var1);

        @Override
        public String indexToLabel(long var1);
    }
}

