/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.Shaders;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.BasicTicker;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.Orientation;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Scaler;
import uk.ac.starlink.ttools.plot2.Scaling;
import uk.ac.starlink.ttools.plot2.Tick;

public class ShadeAxis {
    private final Shader shader_;
    private final Scaling scaling_;
    private final double dlo_;
    private final double dhi_;
    private final String label_;
    private final Captioner captioner_;
    private final double crowding_;
    private final int rampWidth_;
    private static final Orientation ORIENTATION = Orientation.ANTI_Y;

    public ShadeAxis(Shader shader, Scaling scaling, double dlo, double dhi, String label, Captioner captioner, double crowding, int rampWidth) {
        this.shader_ = shader;
        this.scaling_ = scaling;
        this.dlo_ = dlo;
        this.dhi_ = dhi;
        this.label_ = label;
        this.captioner_ = captioner;
        this.crowding_ = crowding;
        this.rampWidth_ = rampWidth;
    }

    @Equality
    public Icon createAxisIcon(Rectangle rampBounds) {
        return this.createShaderAxisIcon(rampBounds);
    }

    public Insets getRampInsets(Rectangle rampBounds) {
        return this.createShaderAxisIcon(rampBounds).getInsets();
    }

    public int getEndPadding() {
        return (this.captioner_.getCaptionBounds((String)"0").height + 1) / 2;
    }

    public int getRampWidth() {
        return this.rampWidth_;
    }

    public double getDataLow() {
        return this.dlo_;
    }

    public double getDataHigh() {
        return this.dhi_;
    }

    public String getLabel() {
        return this.label_;
    }

    public double getCrowding() {
        return this.crowding_;
    }

    private ShaderIcon createShaderAxisIcon(Rectangle rampBounds) {
        Tick[] ticks = (this.scaling_.isLogLike() ? BasicTicker.LOG : BasicTicker.LINEAR).getTicks(this.dlo_, this.dhi_, false, this.captioner_, ORIENTATION, rampBounds.height, this.crowding_);
        return new ShaderIcon(this.shader_, this.scaling_, this.dlo_, this.dhi_, this.label_, this.captioner_, rampBounds, ticks);
    }

    @Equality
    private static class ShaderIcon
    implements Icon {
        private final Shader shader_;
        private final Scaling scaling_;
        private final double dlo_;
        private final double dhi_;
        private final String label_;
        private final Captioner captioner_;
        private final Rectangle box_;
        private final Tick[] ticks_;
        private final Axis axis_;

        public ShaderIcon(Shader shader, Scaling scaling, double dlo, double dhi, String label, Captioner captioner, Rectangle rampBounds, Tick[] ticks) {
            this.shader_ = shader;
            this.scaling_ = scaling;
            this.dlo_ = dlo;
            this.dhi_ = dhi;
            this.label_ = label;
            this.captioner_ = captioner;
            this.box_ = rampBounds;
            this.ticks_ = ticks;
            this.axis_ = Axis.createAxis(this.box_.y, this.box_.y + this.box_.height, dlo, dhi, scaling.isLogLike(), false);
        }

        @Override
        public int getIconWidth() {
            return this.box_.width;
        }

        @Override
        public int getIconHeight() {
            return this.box_.height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            Color color0 = g2.getColor();
            Shader baseShader = Shaders.DFLT_GRID_SHADER;
            float[] baseRgba = Color.BLACK.getRGBComponents(null);
            int nx = this.box_.width;
            float[][] baseRgbas = new float[nx][4];
            for (int ix = 0; ix < nx; ++ix) {
                baseRgbas[ix] = (float[])baseRgba.clone();
                baseShader.adjustRgba(baseRgbas[ix], (float)ix / (float)(nx - 1));
            }
            Scaler scaler = this.scaling_.createScaler(this.dlo_, this.dhi_);
            for (int iy = 0; iy < this.box_.height; ++iy) {
                int gy = this.box_.y + iy;
                int hy = this.box_.y + (this.box_.height - iy);
                double dval = this.axis_.graphicsToData((double)gy + 0.5);
                float frac = (float)scaler.scaleValue(dval);
                if (this.shader_.isAbsolute()) {
                    float[] rgba = (float[])baseRgbas[0].clone();
                    this.shader_.adjustRgba(rgba, frac);
                    g.setColor(new Color(rgba[0], rgba[1], rgba[2], rgba[3]));
                    g.fillRect(this.box_.x, hy, nx, 1);
                    continue;
                }
                for (int ix = 0; ix < nx; ++ix) {
                    float[] rgba = (float[])baseRgbas[ix].clone();
                    this.shader_.adjustRgba(rgba, frac);
                    g.setColor(new Color(rgba[0], rgba[1], rgba[2], rgba[3]));
                    g.fillRect(this.box_.x + ix, hy, 1, 1);
                }
            }
            g2.setColor(Color.BLACK);
            int fw = 1;
            int bx = this.box_.x;
            int by = this.box_.y + 1;
            g2.fillRect(bx, by, fw, this.box_.height);
            g2.fillRect(bx, by + this.box_.height - fw, this.box_.width, fw);
            g2.fillRect(bx, by, this.box_.width, fw);
            g2.fillRect(bx + this.box_.width - fw, by, fw, this.box_.height);
            AffineTransform trans0 = g2.getTransform();
            g2.translate(this.box_.x + this.box_.width, this.box_.y + this.box_.height);
            g2.rotate(-1.5707963267948966);
            this.axis_.drawLabels(this.ticks_, this.label_, this.captioner_, ORIENTATION, false, g2);
            g2.setColor(color0);
            g2.setTransform(trans0);
        }

        public Insets getInsets() {
            Rectangle bounds = this.axis_.getLabelBounds(this.ticks_, this.label_, this.captioner_, ORIENTATION, false);
            bounds = AffineTransform.getRotateInstance(-1.5707963267948966).createTransformedShape(bounds).getBounds();
            int bottom = Math.max(0, bounds.y + bounds.height - this.box_.height);
            int top = Math.max(0, -bounds.y);
            int left = 0;
            int right = Math.max(0, bounds.x + bounds.width);
            return new Insets(top, left, bottom, right);
        }

        public boolean equals(Object o) {
            if (o instanceof ShaderIcon) {
                ShaderIcon other = (ShaderIcon)o;
                return this.shader_.equals(other.shader_) && this.scaling_ == other.scaling_ && this.dlo_ == other.dlo_ && this.dhi_ == other.dhi_ && PlotUtil.equals(this.label_, other.label_) && this.captioner_.equals(other.captioner_) && this.box_.equals(other.box_) && Arrays.equals(this.ticks_, other.ticks_);
            }
            return false;
        }

        public int hashCode() {
            int code = 271223;
            code = 23 * code + this.shader_.hashCode();
            code = 23 * code + this.scaling_.hashCode();
            code = 23 * code + Float.floatToIntBits((float)this.dlo_);
            code = 23 * code + Float.floatToIntBits((float)this.dhi_);
            code = 23 * code + PlotUtil.hashCode(this.label_);
            code = 23 * code + this.captioner_.hashCode();
            code = 23 * code + this.box_.hashCode();
            code = 23 * code + Arrays.hashCode(this.ticks_);
            return code;
        }
    }
}

