/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import uk.ac.starlink.ttools.plot2.Gang;
import uk.ac.starlink.ttools.plot2.Ganger;
import uk.ac.starlink.ttools.plot2.GangerFactory;
import uk.ac.starlink.ttools.plot2.Padding;
import uk.ac.starlink.ttools.plot2.PlotPlacement;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ShadeAxis;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.ZoneContent;

public class SingleGanger<P, A>
implements Ganger<P, A> {
    private final Padding padding_;
    public static final GangerFactory FACTORY = new GangerFactory(){

        @Override
        public boolean isMultiZone() {
            return false;
        }

        public Ganger createGanger(Padding padding) {
            return new SingleGanger(padding);
        }
    };

    public SingleGanger() {
        this(null);
    }

    public SingleGanger(Padding padding) {
        this.padding_ = padding == null ? new Padding() : padding;
    }

    @Override
    public Gang createGang(Rectangle[] zonePlotBounds) {
        if (zonePlotBounds.length == 1) {
            return new SingleGang(zonePlotBounds[0]);
        }
        throw new IllegalArgumentException("Zone count not 1");
    }

    @Override
    public Gang createGang(Rectangle extBounds, SurfaceFactory<P, A> surfFact, int nz, ZoneContent[] contents, P[] profiles, A[] aspects, ShadeAxis[] shadeAxes, boolean withScroll) {
        if (nz != 1) {
            throw new IllegalArgumentException("Not single zone");
        }
        ZoneContent content = contents[0];
        Rectangle plotBounds = PlotPlacement.calculateDataBounds(extBounds, this.padding_, surfFact, profiles[0], aspects[0], withScroll, content.getLegend(), content.getLegendPosition(), content.getTitle(), shadeAxes[0]);
        return new SingleGang(plotBounds);
    }

    @Override
    public Gang createApproxGang(Rectangle extBounds, int nz) {
        if (nz == 1) {
            Insets insets = this.padding_.overrideInsets(new Insets(0, 0, 0, 0));
            Rectangle plotBounds = PlotUtil.subtractInsets(extBounds, insets);
            return new SingleGang(plotBounds);
        }
        throw new IllegalArgumentException("Not single zone");
    }

    @Override
    public A[] adjustAspects(A[] oldAspects, int iz) {
        return oldAspects;
    }

    @Override
    public P[] adjustProfiles(P[] oldProfiles) {
        return oldProfiles;
    }

    private static class SingleGang
    implements Gang {
        private final Rectangle plotBounds_;

        SingleGang(Rectangle plotBounds) {
            this.plotBounds_ = new Rectangle(plotBounds);
        }

        @Override
        public int getZoneCount() {
            return 1;
        }

        public Rectangle getGangPlotBounds() {
            return this.plotBounds_;
        }

        @Override
        public Rectangle getZonePlotBounds(int iz) {
            if (iz == 0) {
                return this.plotBounds_;
            }
            throw new IllegalArgumentException();
        }

        @Override
        public int getNavigationZoneIndex(Point pos) {
            return 0;
        }
    }
}

