/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2;

import uk.ac.starlink.ttools.plot2.Equality;

@Equality
public class Subrange {
    private final double lo_;
    private final double hi_;

    public Subrange(double lo, double hi) {
        if (!(lo <= hi)) {
            throw new IllegalArgumentException("Bad range: " + lo + ", " + hi);
        }
        this.lo_ = lo;
        this.hi_ = hi;
    }

    public Subrange() {
        this(0.0, 1.0);
    }

    public double getLow() {
        return this.lo_;
    }

    public double getHigh() {
        return this.hi_;
    }

    public boolean equals(Object o) {
        if (o instanceof Subrange) {
            Subrange other = (Subrange)o;
            return this.lo_ == other.lo_ && this.hi_ == other.hi_;
        }
        return false;
    }

    public int hashCode() {
        return Float.floatToIntBits((float)this.lo_) + Float.floatToIntBits((float)this.hi_);
    }

    public String toString() {
        return "(" + this.lo_ + "," + this.hi_ + ")";
    }

    public static boolean isIdentity(Subrange subrange) {
        return subrange.getLow() == 0.0 && subrange.getHigh() == 1.0;
    }
}

