/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import uk.ac.starlink.ttools.gui.ColorComboBox;
import uk.ac.starlink.ttools.plot2.config.ChoiceConfigKey;
import uk.ac.starlink.ttools.plot2.config.ChooserColorSpecifier;
import uk.ac.starlink.ttools.plot2.config.ComboBoxSpecifier;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.MultiSpecifierPanel;
import uk.ac.starlink.ttools.plot2.config.NamedColorSet;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.config.ToggleSpecifier;

public class ColorConfigKey
extends ChoiceConfigKey<Color> {
    private final boolean allowHide_;
    public static final Map<String, Color> SRON5_COLORS = Collections.unmodifiableMap(ColorConfigKey.createSron5Colors());
    public static final Map<String, Color> SRON7_COLORS = Collections.unmodifiableMap(ColorConfigKey.createSron7Colors());
    public static final Map<String, Color> SRONBRIGHT_COLORS = Collections.unmodifiableMap(ColorConfigKey.createSronBrightColors());
    public static final Map<String, Color> CLASSIC_COLORS = Collections.unmodifiableMap(ColorConfigKey.createClassicColors());
    private static final Map<String, Color> STANDARD_COLORS = CLASSIC_COLORS;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2.config");
    public static final String COLORNAME_RED = "red";
    public static final String COLORNAME_BLACK = "black";
    public static final String COLORNAME_GREY = "grey";
    public static final String COLORNAME_LIGHTGREY = "light_grey";
    private static final Pattern RGB_REGEX = Pattern.compile("(?:0x|#|)([0-9a-fA-F]{6})");
    private static final NamedColorSet NAMED_COLORS = NamedColorSet.CSS;

    public ColorConfigKey(ConfigMeta meta, String dfltName, boolean allowHide) {
        this(meta, dfltName, allowHide, STANDARD_COLORS);
    }

    public ColorConfigKey(ConfigMeta meta, String dfltName, boolean allowHide, Map<String, Color> colorOpts) {
        super(meta, Color.class, ColorConfigKey.getColorByName(colorOpts, dfltName), allowHide);
        this.allowHide_ = allowHide;
        this.getOptionMap().putAll(colorOpts);
    }

    @Override
    public Color decodeString(String sval) {
        return ColorConfigKey.decodeColorName(sval);
    }

    @Override
    public String stringifyValue(Color color) {
        return String.format("%06x", color.getRGB() & 0xFFFFFF);
    }

    @Override
    public Specifier<Color> createSpecifier() {
        Color[] colors = this.getOptionMap().values().toArray(new Color[0]);
        ArrayList specifiers = new ArrayList();
        specifiers.add(new ComboBoxSpecifier((JComboBox)((Object)new ColorComboBox(colors))));
        specifiers.add(new ChooserColorSpecifier(colors[0]));
        MultiSpecifierPanel<Color> basic = new MultiSpecifierPanel<Color>(false, colors[0], specifiers);
        return this.allowHide_ ? new ToggleSpecifier<Object>(basic, null, "Hide") : basic;
    }

    public static ConfigMeta createColorMeta(String shortName, String longName, String theItem) {
        ConfigMeta meta = new ConfigMeta(shortName, longName);
        meta.setStringUsage("<rrggbb>|red|blue|...");
        meta.setShortDescription("Color of " + theItem);
        StringBuffer nameList = new StringBuffer();
        for (String name : STANDARD_COLORS.keySet()) {
            if (nameList.length() > 0) {
                nameList.append(", ");
            }
            nameList.append("<code>").append(name).append("</code>");
        }
        meta.setXmlDescription(new String[]{"<p>The color of " + theItem + ",", "given by name or as a hexadecimal RGB value.", "</p>", "<p>The standard plotting colour names are", nameList.toString() + ".", "However, many other common colour names (too many to list here)", "are also understood.", "The list currently contains those colour names understood", "by most web browsers,", "from <code>AliceBlue</code> to <code>YellowGreen</code>,", "listed e.g. in the", "<em>Extended color keywords</em> section of", "the <webref url='http://www.w3c.org/TR/css3-color#svg-color'>CSS3</webref> standard.", "</p>", "<p>Alternatively, a six-digit hexadecimal number <em>RRGGBB</em>", "may be supplied,", "optionally prefixed by \"<code>#</code>\" or \"<code>0x</code>\",", "giving red, green and blue intensities,", "e.g.  \"<code>ff00ff</code>\", \"<code>#ff00ff</code>\"", "or \"<code>0xff00ff</code>\" for magenta.", "</p>"});
        return meta;
    }

    public static Color decodeColorName(String sval) {
        Matcher rgbMatcher = RGB_REGEX.matcher(sval);
        if (rgbMatcher.matches()) {
            int rgb = Integer.parseInt(rgbMatcher.group(1), 16);
            return new Color(rgb);
        }
        Color named = NAMED_COLORS.getColor(sval);
        if (named != null) {
            return named;
        }
        return null;
    }

    public static Color[] getPlottingColors() {
        LinkedHashMap<String, Color> map = new LinkedHashMap<String, Color>(STANDARD_COLORS);
        map.remove(COLORNAME_LIGHTGREY);
        map.remove(COLORNAME_BLACK);
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!Color.WHITE.equals(entry.getValue())) continue;
            it.remove();
        }
        return map.values().toArray(new Color[0]);
    }

    private static Color getColorByName(Map<String, Color> map, String name) {
        if (map.containsKey(name)) {
            return map.get(name);
        }
        Map.Entry<String, Color> entry = map.entrySet().iterator().next();
        if (name != null) {
            logger_.warning("Unknown colour \"" + name + "\"" + " - use default \"" + entry.getKey() + "\"");
        }
        return entry.getValue();
    }

    public static Map<String, Color> createClassicColors() {
        LinkedHashMap<String, Color> map = new LinkedHashMap<String, Color>();
        map.put(COLORNAME_RED, new Color(0xF00000));
        map.put("blue", new Color(240));
        map.put("green", Color.green.darker());
        map.put(COLORNAME_GREY, Color.gray);
        map.put("magenta", Color.magenta);
        map.put("cyan", Color.cyan.darker());
        map.put("orange", Color.orange);
        map.put("pink", Color.pink);
        map.put("yellow", Color.yellow);
        map.put(COLORNAME_BLACK, Color.black);
        map.put(COLORNAME_LIGHTGREY, Color.lightGray);
        map.put("white", Color.white);
        return map;
    }

    public static Map<String, Color> createSron5Colors() {
        LinkedHashMap<String, Color> map = new LinkedHashMap<String, Color>();
        map.put(COLORNAME_RED, new Color(14229792));
        map.put("orange", new Color(14916663));
        map.put("green", new Color(8239220));
        map.put("blue", new Color(5414327));
        map.put("indigo", new Color(4210838));
        map.put(COLORNAME_GREY, Color.GRAY);
        map.put(COLORNAME_BLACK, Color.BLACK);
        map.put(COLORNAME_LIGHTGREY, Color.LIGHT_GRAY);
        return map;
    }

    public static Map<String, Color> createSron7Colors() {
        LinkedHashMap<String, Color> map = new LinkedHashMap<String, Color>();
        map.put(COLORNAME_RED, new Color(14229792));
        map.put("blue", new Color(5480118));
        map.put("green", new Color(7189384));
        map.put("yellow", new Color(13285443));
        map.put("orange", new Color(15172914));
        map.put("indigo", new Color(4153518));
        map.put("violet", new Color(7871617));
        map.put(COLORNAME_GREY, new Color(0x808080));
        map.put(COLORNAME_BLACK, Color.BLACK);
        map.put(COLORNAME_LIGHTGREY, new Color(0xC0C0C0));
        return map;
    }

    public static Map<String, Color> createSronBrightColors() {
        LinkedHashMap<String, Color> map = new LinkedHashMap<String, Color>();
        map.put(COLORNAME_RED, new Color(0xEE3333));
        map.put("blue", new Color(0x3366AA));
        map.put("green", new Color(0x66AA55));
        map.put("yellow", new Color(0xCCCC55));
        map.put("purple", new Color(0x992288));
        map.put("orange", new Color(0xEE7722));
        map.put("cyan", new Color(0x11AA99));
        map.put(COLORNAME_GREY, new Color(0x777777));
        map.put(COLORNAME_BLACK, Color.BLACK);
        map.put(COLORNAME_LIGHTGREY, new Color(0xDDDDDD));
        return map;
    }
}

