/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.config.SpecifierPanel;
import uk.ac.starlink.util.gui.ComboBoxBumper;
import uk.ac.starlink.util.gui.CustomComboBoxRenderer;
import uk.ac.starlink.util.gui.ShrinkWrapper;

public class ComboBoxSpecifier<V>
extends SpecifierPanel<V> {
    private final JComboBox comboBox_;
    private final boolean allowAny_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2.config");

    public ComboBoxSpecifier(JComboBox comboBox, boolean customStringify, boolean allowAny) {
        super(comboBox.isEditable());
        this.comboBox_ = comboBox;
        this.allowAny_ = allowAny;
        if (customStringify) {
            this.comboBox_.setRenderer(new CustomComboBoxRenderer(){

                public Object mapValue(Object value) {
                    Object val = value;
                    return ComboBoxSpecifier.this.stringify(val);
                }
            });
        }
    }

    public ComboBoxSpecifier(JComboBox comboBox) {
        this(comboBox, false, true);
    }

    public ComboBoxSpecifier(Collection<V> options) {
        this(new JComboBox<Object>(options.toArray()), true, true);
        this.comboBox_.setSelectedIndex(0);
    }

    public ComboBoxSpecifier(V[] options) {
        this(Arrays.asList(options));
    }

    public String stringify(V value) {
        return value == null ? null : value.toString();
    }

    @Override
    protected JComponent createComponent() {
        final Box line = Box.createHorizontalBox();
        line.add((Component)new ShrinkWrapper((Component)this.comboBox_));
        line.add(Box.createHorizontalStrut(5));
        line.add((Component)new ComboBoxBumper(this.comboBox_));
        this.comboBox_.addActionListener(this.getActionForwarder());
        line.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    ComboBoxSpecifier.this.comboBox_.setEnabled(line.isEnabled());
                }
            }
        });
        return line;
    }

    @Override
    public V getSpecifiedValue() {
        Object value = this.comboBox_.getSelectedItem();
        return (V)value;
    }

    @Override
    public void setSpecifiedValue(V value) {
        boolean tmpEditable;
        boolean bl = tmpEditable = this.allowAny_ && !this.comboBox_.isEditable();
        if (tmpEditable) {
            this.comboBox_.setEditable(true);
        }
        this.comboBox_.setSelectedItem(value);
        if (tmpEditable) {
            this.comboBox_.setEditable(false);
        }
        if (!PlotUtil.equals(this.comboBox_.getSelectedItem(), value)) {
            assert (!this.allowAny_);
            logger_.warning("Attempt to set unlisted value " + value + " failed");
        }
    }

    @Override
    public void submitReport(ReportMap report) {
    }

    public JComboBox getComboBox() {
        return this.comboBox_;
    }
}

