/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;

@Equality
public class ConfigMap {
    private final Map<ConfigKey<?>, Object> map_ = new ConcurrentHashMap(8, 0.75f, 1);
    private static final Object NULL_VALUE = new Object(){

        public String toString() {
            return "<null>";
        }
    };

    public ConfigMap() {
    }

    public ConfigMap(ConfigMap copy) {
        this();
        this.map_.putAll(copy.map_);
    }

    public <T> void put(ConfigKey<T> key, T value) {
        this.map_.put(key, value == null ? NULL_VALUE : value);
    }

    public void putAll(ConfigMap config) {
        this.map_.putAll(config.map_);
    }

    public <T> T get(ConfigKey<T> key) {
        Object value = this.map_.get(key);
        if (value == null) {
            return key.getDefaultValue();
        }
        if (value == NULL_VALUE) {
            return null;
        }
        return key.cast(value);
    }

    public Set<ConfigKey<?>> keySet() {
        return this.map_.keySet();
    }

    public boolean equals(Object o) {
        return o instanceof ConfigMap && ((Object)this.map_).equals(((ConfigMap)o).map_);
    }

    public int hashCode() {
        return ((Object)this.map_).hashCode();
    }

    public String toString() {
        return this.map_.toString();
    }
}

