/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.DoubleConfigKey;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.config.TextFieldSpecifier;

public class DoubleArrayConfigKey
extends ConfigKey<double[]> {
    public DoubleArrayConfigKey(ConfigMeta meta, double[] dflt) {
        super(meta, double[].class, dflt == null ? null : (double[])dflt.clone());
        if (meta.getStringUsage() == null) {
            meta.setStringUsage("<n>,<n>,...");
        }
    }

    @Override
    public String valueToString(double[] dvals) {
        StringBuffer sbuf = new StringBuffer();
        if (dvals != null) {
            for (int i = 0; i < dvals.length; ++i) {
                if (i > 0) {
                    sbuf.append(",");
                }
                sbuf.append(DoubleConfigKey.doubleToString(dvals[i]));
            }
        }
        return sbuf.toString();
    }

    @Override
    public double[] stringToValue(String txt) throws ConfigException {
        if (txt == null || txt.trim().length() == 0) {
            return new double[0];
        }
        String[] txts = txt.split(",", -1);
        int n = txts.length;
        double[] dvals = new double[n];
        for (int i = 0; i < n; ++i) {
            dvals[i] = DoubleConfigKey.stringToDouble(txts[i], this);
        }
        return dvals;
    }

    @Override
    public Specifier<double[]> createSpecifier() {
        return new TextFieldSpecifier<double[]>(this, new double[0]);
    }
}

