/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import uk.ac.starlink.ttools.plot2.ReportKey;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.ConversionSpecifier;
import uk.ac.starlink.ttools.plot2.config.SliderSpecifier;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.config.SpecifierPanel;
import uk.ac.starlink.util.gui.ShrinkWrapper;

public abstract class IntegerConfigKey
extends ConfigKey<Integer> {
    private final int dflt_;

    protected IntegerConfigKey(ConfigMeta meta, int dflt) {
        super(meta, Integer.class, new Integer(dflt));
        if (meta.getStringUsage() == null) {
            meta.setStringUsage("<int-value>");
        }
        this.dflt_ = dflt;
    }

    @Override
    public Integer stringToValue(String txt) throws ConfigException {
        try {
            return Integer.decode(txt);
        }
        catch (NumberFormatException e) {
            throw new ConfigException(this, "\"" + txt + "\" not an integer", e);
        }
    }

    @Override
    public String valueToString(Integer value) {
        return value.toString();
    }

    public static IntegerConfigKey createSpinnerKey(ConfigMeta meta, int dflt, final int lo, final int hi) {
        return new IntegerConfigKey(meta, dflt){

            @Override
            public Specifier<Integer> createSpecifier() {
                return new SpinnerSpecifier(lo, hi, 1);
            }
        };
    }

    public static IntegerConfigKey createSpinnerPairKey(ConfigMeta meta, int dflt, final int posLimit, final int negLimit, final String posLabel, final String negLabel, final ReportKey<Integer> posReportKey, final ReportKey<Integer> negReportKey) {
        return new IntegerConfigKey(meta, dflt){

            @Override
            public Specifier<Integer> createSpecifier() {
                return new SpinnerPairSpecifier(posLimit, negLimit, posLabel, negLabel, posReportKey, negReportKey);
            }
        };
    }

    public static IntegerConfigKey createSliderKey(ConfigMeta meta, final int dflt, final double lo, final double hi, final boolean log) {
        return new IntegerConfigKey(meta, dflt){

            @Override
            public Specifier<Integer> createSpecifier() {
                SliderSpecifier slidey = new SliderSpecifier(lo, hi, log, dflt);
                return new ConversionSpecifier<Double, Integer>((Specifier)slidey){

                    @Override
                    protected Integer inToOut(Double dVal) {
                        if (dVal == null) {
                            return null;
                        }
                        double dval = dVal;
                        return Double.isNaN(dval) ? null : new Integer((int)Math.round(dval));
                    }

                    @Override
                    protected Double outToIn(Integer iVal) {
                        return iVal == null ? null : Double.valueOf(iVal.doubleValue());
                    }
                };
            }
        };
    }

    private static class SpinnerPairSpecifier
    extends SpecifierPanel<Integer> {
        private final JSpinner posSpinner_;
        private final JSpinner negSpinner_;
        private final JRadioButton posButt_;
        private final JRadioButton negButt_;
        private final ReportKey<Integer> posReportKey_;
        private final ReportKey<Integer> negReportKey_;
        private final JLabel reportLabel_;

        public SpinnerPairSpecifier(int posLimit, int negLimit, String posLabel, String negLabel, ReportKey<Integer> posReportKey, ReportKey<Integer> negReportKey) {
            super(false);
            this.posSpinner_ = new JSpinner(new SpinnerNumberModel(0, 0, posLimit, 1));
            this.negSpinner_ = new JSpinner(new SpinnerNumberModel(-1, negLimit, -1, 1));
            this.posButt_ = new JRadioButton(posLabel);
            this.negButt_ = new JRadioButton(negLabel);
            this.posReportKey_ = posReportKey;
            this.negReportKey_ = negReportKey;
            this.reportLabel_ = new JLabel();
            this.reportLabel_.setFont(this.posSpinner_.getFont());
            ButtonGroup bgrp = new ButtonGroup();
            bgrp.add(this.posButt_);
            bgrp.add(this.negButt_);
            this.posButt_.setSelected(true);
        }

        @Override
        protected JComponent createComponent() {
            this.posSpinner_.addChangeListener(this.getChangeForwarder());
            this.negSpinner_.addChangeListener(this.getChangeForwarder());
            ActionListener radioListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SpinnerPairSpecifier.this.updateState();
                    SpinnerPairSpecifier.this.getActionForwarder().actionPerformed(evt);
                }
            };
            this.posButt_.addActionListener(radioListener);
            this.negButt_.addActionListener(radioListener);
            Box line = Box.createHorizontalBox();
            line.add(this.posButt_);
            line.add((Component)new ShrinkWrapper((Component)this.posSpinner_));
            line.add(Box.createHorizontalStrut(5));
            line.add(this.negButt_);
            line.add((Component)new ShrinkWrapper((Component)this.negSpinner_));
            if (this.posReportKey_ != null) {
                line.add(Box.createHorizontalStrut(10));
                line.add(this.reportLabel_);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpinnerPairSpecifier.this.updateState();
                }
            });
            return line;
        }

        @Override
        public Integer getSpecifiedValue() {
            int value = this.posButt_.isSelected() ? ((Number)this.posSpinner_.getValue()).intValue() : ((Number)this.negSpinner_.getValue()).intValue();
            return new Integer(value);
        }

        @Override
        public void setSpecifiedValue(Integer value) {
            if (value >= 0) {
                this.posButt_.setSelected(true);
                this.posSpinner_.setValue(new Integer(value));
            } else {
                this.negButt_.setSelected(true);
                this.negSpinner_.setValue(new Integer(value));
            }
            this.fireAction();
        }

        @Override
        public void submitReport(ReportMap report) {
            if (report != null) {
                Integer posLevel = report.get(this.posReportKey_);
                Integer negLevel = report.get(this.negReportKey_);
                if (!this.posButt_.isSelected() && posLevel != null) {
                    this.setSpinnerValue(this.posSpinner_, posLevel);
                }
                if (!this.negButt_.isSelected() && negLevel != null) {
                    this.setSpinnerValue(this.negSpinner_, negLevel);
                }
                if (posLevel != null) {
                    this.reportLabel_.setText(posLevel.toString());
                }
            }
        }

        private void setSpinnerValue(JSpinner spinner, int value) {
            SpinnerModel model = spinner.getModel();
            if (model instanceof SpinnerNumberModel) {
                SpinnerNumberModel nModel = (SpinnerNumberModel)model;
                double step = nModel.getStepSize().doubleValue();
                Comparable<?> min = nModel.getMinimum();
                Comparable<?> max = nModel.getMaximum();
                if ((step == 1.0 || step == -1.0) && min instanceof Number && max instanceof Number) {
                    int imin = ((Number)((Object)min)).intValue();
                    int imax = ((Number)((Object)max)).intValue();
                    if (value >= imin && value <= imax) {
                        spinner.setValue(new Integer(value));
                    }
                }
            }
        }

        private void updateState() {
            JComponent comp = this.getComponent();
            boolean isEnabled = comp == null || comp.isEnabled();
            this.posSpinner_.setEnabled(isEnabled && this.posButt_.isSelected());
            this.negSpinner_.setEnabled(isEnabled && this.negButt_.isSelected());
        }
    }

    private static class SpinnerSpecifier
    extends SpecifierPanel<Integer> {
        private final JSpinner spinner_;

        SpinnerSpecifier(int lo, int hi, int step) {
            super(false);
            this.spinner_ = new JSpinner(new SpinnerNumberModel(lo, lo, hi, step));
        }

        @Override
        protected JComponent createComponent() {
            Box box = new Box(0){

                @Override
                public void setEnabled(boolean enabled) {
                    super.setEnabled(enabled);
                    SpinnerSpecifier.this.spinner_.setEnabled(enabled);
                }
            };
            box.add((Component)new ShrinkWrapper((Component)this.spinner_));
            this.spinner_.addChangeListener(this.getChangeForwarder());
            return box;
        }

        @Override
        public Integer getSpecifiedValue() {
            return new Integer(((Number)this.spinner_.getValue()).intValue());
        }

        @Override
        public void setSpecifiedValue(Integer value) {
            this.spinner_.setValue(value);
            this.fireAction();
        }

        @Override
        public void submitReport(ReportMap report) {
        }
    }
}

