/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import uk.ac.starlink.ttools.gui.MarkStyleSelectors;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.ttools.plot.ErrorModeSelection;
import uk.ac.starlink.ttools.plot.ErrorRenderer;
import uk.ac.starlink.ttools.plot2.config.ComboBoxSpecifier;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.config.Specifier;

public class MultiPointConfigKey
extends OptionConfigKey<ErrorRenderer> {
    private final ErrorRenderer[] renderers_;
    private final ErrorMode[] modes_;

    public MultiPointConfigKey(ConfigMeta meta, ErrorRenderer[] renderers, ErrorMode[] modes) {
        super(meta, ErrorRenderer.class, renderers, MultiPointConfigKey.chooseDefault(renderers));
        this.renderers_ = renderers;
        this.modes_ = modes;
    }

    @Override
    public String getXmlDescription(ErrorRenderer renderer) {
        return null;
    }

    public ErrorMode[] getErrorModes() {
        return this.modes_;
    }

    @Override
    public Specifier<ErrorRenderer> createSpecifier() {
        int naxis = this.modes_.length;
        ErrorModeSelection[] modeSelections = new ErrorModeSelection[naxis];
        for (int ia = 0; ia < naxis; ++ia) {
            final ErrorMode mode = this.modes_[ia];
            modeSelections[ia] = new ErrorModeSelection(){

                @Override
                public ErrorMode getErrorMode() {
                    return mode;
                }

                @Override
                public void addActionListener(ActionListener listener) {
                }

                @Override
                public void removeActionListener(ActionListener listener) {
                }
            };
        }
        JComboBox rendererComboBox = MarkStyleSelectors.createErrorSelector(this.renderers_, (ErrorRenderer)this.getDefaultValue(), modeSelections);
        return new ComboBoxSpecifier<ErrorRenderer>(rendererComboBox){

            @Override
            public String stringify(ErrorRenderer value) {
                return MultiPointConfigKey.this.valueToString(value);
            }
        };
    }

    private static ErrorRenderer chooseDefault(ErrorRenderer[] renderers) {
        for (int ir = 0; ir < renderers.length; ++ir) {
            ErrorRenderer rend = renderers[ir];
            if (rend == null || rend == ErrorRenderer.NONE) continue;
            return rend;
        }
        assert (false);
        return ErrorRenderer.DEFAULT;
    }
}

