/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class NamedColorChooserPanel
extends AbstractColorChooserPanel {
    private final Map<String, Color> colorMap_;
    private final JColorChooser chooser_;

    public NamedColorChooserPanel(Map<String, Color> colorMap, JColorChooser chooser) {
        this.colorMap_ = colorMap;
        this.chooser_ = chooser;
    }

    @Override
    protected void buildChooser() {
        final JList<String> list = new JList<String>(this.colorMap_.keySet().toArray(new String[0]));
        final ColorIcon icon = new ColorIcon(24, 12);
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
                Color color = (Color)NamedColorChooserPanel.this.colorMap_.get(value);
                if (c instanceof JLabel && color != null) {
                    icon.setColor(color);
                    ((JLabel)c).setIcon(icon);
                }
                return c;
            }
        });
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                Color color;
                if (!evt.getValueIsAdjusting() && (color = (Color)NamedColorChooserPanel.this.colorMap_.get(list.getSelectedValue())) != null) {
                    NamedColorChooserPanel.this.chooser_.getSelectionModel().setSelectedColor(color);
                }
            }
        });
        this.setLayout(new BorderLayout());
        Dimension size = this.chooser_.getPreferredSize();
        JComponent preview = this.chooser_.getPreviewPanel();
        if (preview != null) {
            size.height -= preview.getPreferredSize().height;
        }
        this.setPreferredSize(size);
        this.add((Component)new JScrollPane(list, 22, 31), "Center");
    }

    @Override
    public String getDisplayName() {
        return "Names";
    }

    @Override
    public int getMnemonic() {
        return 78;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void updateChooser() {
    }

    private static class ColorIcon
    implements Icon {
        private final int width_;
        private final int height_;
        private Color color_;

        ColorIcon(int width, int height) {
            this.width_ = width;
            this.height_ = height;
        }

        public void setColor(Color color) {
            this.color_ = color;
        }

        @Override
        public int getIconWidth() {
            return this.width_;
        }

        @Override
        public int getIconHeight() {
            return this.height_;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.color_ != null) {
                Color color0 = g.getColor();
                g.setColor(this.color_);
                g.fillRect(x, y, this.width_, this.height_);
                g.setColor(color0);
            }
        }
    }
}

