/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.awt.Color;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class NamedColorSet {
    private final Map<String, Color> origMap_;
    private final Map<String, Color> normMap_;
    private static final Map<String, Color> CSS_MAP = NamedColorSet.createCssMap();
    public static final NamedColorSet CSS = NamedColorSet.createCssColorSet(CSS_MAP);
    public static final NamedColorSet CSS_DARK = NamedColorSet.createCssColorSet(NamedColorSet.filterDark(CSS_MAP));

    public NamedColorSet(Map<String, Color> map) {
        this.origMap_ = map;
        this.normMap_ = new HashMap<String, Color>(map.size());
        for (Map.Entry<String, Color> entry : this.origMap_.entrySet()) {
            this.normMap_.put(this.toKey(entry.getKey()), entry.getValue());
        }
    }

    public Map<String, Color> getMap() {
        return this.origMap_;
    }

    public Color getColor(String name) {
        return this.normMap_.get(this.toKey(name));
    }

    public abstract String toKey(String var1);

    private static Map<String, Color> createCssMap() {
        LinkedHashMap<String, Color> map = new LinkedHashMap<String, Color>();
        NamedColorSet.putColor(map, 0xF0F8FF, "AliceBlue");
        NamedColorSet.putColor(map, 16444375, "AntiqueWhite");
        NamedColorSet.putColor(map, 65535, "Aqua");
        NamedColorSet.putColor(map, 8388564, "Aquamarine");
        NamedColorSet.putColor(map, 0xF0FFFF, "Azure");
        NamedColorSet.putColor(map, 16119260, "Beige");
        NamedColorSet.putColor(map, 16770244, "Bisque");
        NamedColorSet.putColor(map, 0, "Black");
        NamedColorSet.putColor(map, 16772045, "BlanchedAlmond");
        NamedColorSet.putColor(map, 255, "Blue");
        NamedColorSet.putColor(map, 9055202, "BlueViolet");
        NamedColorSet.putColor(map, 0xA52A2A, "Brown");
        NamedColorSet.putColor(map, 14596231, "Burlywood");
        NamedColorSet.putColor(map, 6266528, "CadetBlue");
        NamedColorSet.putColor(map, 0x7FFF00, "Chartreuse");
        NamedColorSet.putColor(map, 13789470, "Chocolate");
        NamedColorSet.putColor(map, 16744272, "Coral");
        NamedColorSet.putColor(map, 6591981, "CornflowerBlue");
        NamedColorSet.putColor(map, 16775388, "Cornsilk");
        NamedColorSet.putColor(map, 14423100, "Crimson");
        NamedColorSet.putColor(map, 65535, "Cyan");
        NamedColorSet.putColor(map, 139, "DarkBlue");
        NamedColorSet.putColor(map, 35723, "DarkCyan");
        NamedColorSet.putColor(map, 12092939, "DarkGoldenrod");
        NamedColorSet.putColor(map, 0xA9A9A9, "DarkGray");
        NamedColorSet.putColor(map, 25600, "DarkGreen");
        NamedColorSet.putColor(map, 12433259, "DarkKhaki");
        NamedColorSet.putColor(map, 0x8B008B, "DarkMagenta");
        NamedColorSet.putColor(map, 5597999, "DarkOliveGreen");
        NamedColorSet.putColor(map, 16747520, "DarkOrange");
        NamedColorSet.putColor(map, 10040012, "DarkOrchid");
        NamedColorSet.putColor(map, 0x8B0000, "DarkRed");
        NamedColorSet.putColor(map, 15308410, "DarkSalmon");
        NamedColorSet.putColor(map, 9419919, "DarkSeagreen");
        NamedColorSet.putColor(map, 4734347, "DarkSlateBlue");
        NamedColorSet.putColor(map, 0x2F4F4F, "DarkSlateGray");
        NamedColorSet.putColor(map, 52945, "DarkTurquoise");
        NamedColorSet.putColor(map, 9699539, "DarkViolet");
        NamedColorSet.putColor(map, 16716947, "DeepPink");
        NamedColorSet.putColor(map, 49151, "DeepSkyBlue");
        NamedColorSet.putColor(map, 0x696969, "DimGray");
        NamedColorSet.putColor(map, 2003199, "DodgerBlue");
        NamedColorSet.putColor(map, 0xB22222, "FireBrick");
        NamedColorSet.putColor(map, 0xFFFAF0, "FloralWhite");
        NamedColorSet.putColor(map, 0x228B22, "ForestGreen");
        NamedColorSet.putColor(map, 0xFF00FF, "Fuchsia");
        NamedColorSet.putColor(map, 0xDCDCDC, "Gainsboro");
        NamedColorSet.putColor(map, 0xF8F8FF, "Ghostwhite");
        NamedColorSet.putColor(map, 16766720, "Gold");
        NamedColorSet.putColor(map, 14329120, "Goldenrod");
        NamedColorSet.putColor(map, 0x808080, "Gray");
        NamedColorSet.putColor(map, 32768, "Green");
        NamedColorSet.putColor(map, 11403055, "GreenYellow");
        NamedColorSet.putColor(map, 0xF0FFF0, "Honeydew");
        NamedColorSet.putColor(map, 16738740, "HotPink");
        NamedColorSet.putColor(map, 0xCD5C5C, "IndianRed");
        NamedColorSet.putColor(map, 4915330, "Indigo");
        NamedColorSet.putColor(map, 0xFFFFF0, "Ivory");
        NamedColorSet.putColor(map, 15787660, "Khaki");
        NamedColorSet.putColor(map, 15132410, "Lavender");
        NamedColorSet.putColor(map, 0xFFF0F5, "LavenderBlush");
        NamedColorSet.putColor(map, 8190976, "LawnGreen");
        NamedColorSet.putColor(map, 16775885, "LemonChiffon");
        NamedColorSet.putColor(map, 11393254, "LightBlue");
        NamedColorSet.putColor(map, 0xF08080, "LightCoral");
        NamedColorSet.putColor(map, 0xE0FFFF, "LightCyan");
        NamedColorSet.putColor(map, 16448210, "LightGoldenrodYellow");
        NamedColorSet.putColor(map, 0x90EE90, "LightGreen");
        NamedColorSet.putColor(map, 0xD3D3D3, "LightGrey");
        NamedColorSet.putColor(map, 16758465, "LightPink");
        NamedColorSet.putColor(map, 16752762, "LightSalmon");
        NamedColorSet.putColor(map, 2142890, "LightSeagreen");
        NamedColorSet.putColor(map, 8900346, "LightSkyBlue");
        NamedColorSet.putColor(map, 0x778899, "LightSlateGray");
        NamedColorSet.putColor(map, 11584734, "LightSteelBlue");
        NamedColorSet.putColor(map, 0xFFFFE0, "LightYellow");
        NamedColorSet.putColor(map, 65280, "Lime");
        NamedColorSet.putColor(map, 3329330, "LimeGreen");
        NamedColorSet.putColor(map, 16445670, "Linen");
        NamedColorSet.putColor(map, 0xFF00FF, "Magenta");
        NamedColorSet.putColor(map, 0x800000, "Maroon");
        NamedColorSet.putColor(map, 6737322, "MediumAquamarine");
        NamedColorSet.putColor(map, 205, "MediumBlue");
        NamedColorSet.putColor(map, 12211667, "MediumOrchid");
        NamedColorSet.putColor(map, 9662683, "MediumPurple");
        NamedColorSet.putColor(map, 3978097, "MediumSeaGreen");
        NamedColorSet.putColor(map, 8087790, "MediumSlateBlue");
        NamedColorSet.putColor(map, 64154, "MediumSpringGreen");
        NamedColorSet.putColor(map, 4772300, "MediumTurquoise");
        NamedColorSet.putColor(map, 13047173, "MediumVioletRed");
        NamedColorSet.putColor(map, 1644912, "MidnightBlue");
        NamedColorSet.putColor(map, 0xF5FFFA, "MintCream");
        NamedColorSet.putColor(map, 16770273, "MistyRose");
        NamedColorSet.putColor(map, 16770229, "Moccasin");
        NamedColorSet.putColor(map, 16768685, "NavajoWhite");
        NamedColorSet.putColor(map, 128, "Navy");
        NamedColorSet.putColor(map, 16643558, "OldLace");
        NamedColorSet.putColor(map, 0x808000, "Olive");
        NamedColorSet.putColor(map, 7048739, "OliveDrab");
        NamedColorSet.putColor(map, 16753920, "Orange");
        NamedColorSet.putColor(map, 16729344, "OrangeRed");
        NamedColorSet.putColor(map, 14315734, "Orchid");
        NamedColorSet.putColor(map, 0xEEE8AA, "PaleGoldenrod");
        NamedColorSet.putColor(map, 10025880, "PaleGreen");
        NamedColorSet.putColor(map, 0xAFEEEE, "PaleTurquoise");
        NamedColorSet.putColor(map, 14381203, "PaleVioletRed");
        NamedColorSet.putColor(map, 16773077, "PapayaWhip");
        NamedColorSet.putColor(map, 16767673, "PeachPuff");
        NamedColorSet.putColor(map, 13468991, "Peru");
        NamedColorSet.putColor(map, 16761035, "Pink");
        NamedColorSet.putColor(map, 0xDDA0DD, "Plum");
        NamedColorSet.putColor(map, 11591910, "PowderBlue");
        NamedColorSet.putColor(map, 0x800080, "Purple");
        NamedColorSet.putColor(map, 0xFF0000, "Red");
        NamedColorSet.putColor(map, 12357519, "RosyBrown");
        NamedColorSet.putColor(map, 4286945, "RoyalBlue");
        NamedColorSet.putColor(map, 9127187, "SaddleBrown");
        NamedColorSet.putColor(map, 16416882, "Salmon");
        NamedColorSet.putColor(map, 16426080, "SandyBrown");
        NamedColorSet.putColor(map, 3050327, "SeaGreen");
        NamedColorSet.putColor(map, 0xFFF5EE, "SeaShell");
        NamedColorSet.putColor(map, 10506797, "Sienna");
        NamedColorSet.putColor(map, 0xC0C0C0, "Silver");
        NamedColorSet.putColor(map, 8900331, "SkyBlue");
        NamedColorSet.putColor(map, 6970061, "SlateBlue");
        NamedColorSet.putColor(map, 7372944, "SlateGray");
        NamedColorSet.putColor(map, 0xFFFAFA, "Snow");
        NamedColorSet.putColor(map, 65407, "SpringGreen");
        NamedColorSet.putColor(map, 4620980, "SteelBlue");
        NamedColorSet.putColor(map, 13808780, "Tan");
        NamedColorSet.putColor(map, 32896, "Teal");
        NamedColorSet.putColor(map, 14204888, "Thistle");
        NamedColorSet.putColor(map, 16737095, "Tomato");
        NamedColorSet.putColor(map, 4251856, "Turquoise");
        NamedColorSet.putColor(map, 0xEE82EE, "Violet");
        NamedColorSet.putColor(map, 16113331, "Wheat");
        NamedColorSet.putColor(map, 0xFFFFFF, "White");
        NamedColorSet.putColor(map, 0xF5F5F5, "WhiteSmoke");
        NamedColorSet.putColor(map, 0xFFFF00, "Yellow");
        NamedColorSet.putColor(map, 10145074, "YellowGreen");
        return map;
    }

    private static Map<String, Color> filterDark(Map<String, Color> map) {
        map = new LinkedHashMap<String, Color>(map);
        Iterator<Color> it = map.values().iterator();
        while (it.hasNext()) {
            Color color = it.next();
            if (color.getRed() <= 192 || color.getGreen() <= 192 || color.getBlue() <= 192 || Color.WHITE.equals(color)) continue;
            it.remove();
        }
        return map;
    }

    private static void putColor(Map<String, Color> map, int rgb, String name) {
        map.put(name, new Color(rgb));
    }

    private static NamedColorSet createCssColorSet(Map<String, Color> map) {
        return new NamedColorSet((Map)Collections.unmodifiableMap(map)){

            @Override
            public String toKey(String name) {
                if (name != null) {
                    name = name.toLowerCase().replaceAll("[ _-]", "").replaceAll("grey", "gray");
                }
                return name;
            }
        };
    }
}

