/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.SpecifierPanel;

public class TextFieldSpecifier<V>
extends SpecifierPanel<V> {
    private final ConfigKey<V> key_;
    private final JTextField txtField_;
    private V badValue_;

    public TextFieldSpecifier(ConfigKey<V> key, V badValue) {
        super(true);
        this.key_ = key;
        this.badValue_ = badValue;
        this.txtField_ = new JTextField();
        V dflt = key.getDefaultValue();
        if (dflt != null) {
            this.txtField_.setText(key.valueToString(dflt));
        }
    }

    @Override
    protected JComponent createComponent() {
        this.txtField_.addActionListener(this.getActionForwarder());
        return this.txtField_;
    }

    @Override
    public V getSpecifiedValue() {
        try {
            return this.key_.stringToValue(this.txtField_.getText());
        }
        catch (ConfigException e) {
            JOptionPane.showMessageDialog(this.txtField_, e.getMessage(), "Bad Value", 0);
            this.txtField_.setText("");
            return null;
        }
    }

    @Override
    public void setSpecifiedValue(V value) {
        this.txtField_.setText(this.key_.valueToString(value));
        this.fireAction();
    }

    @Override
    public void submitReport(ReportMap report) {
    }
}

