/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.Slow;
import uk.ac.starlink.ttools.plot2.data.CachedColumn;
import uk.ac.starlink.ttools.plot2.data.CachedColumnFactory;
import uk.ac.starlink.ttools.plot2.data.CachedReader;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.DataStoreFactory;
import uk.ac.starlink.ttools.plot2.data.SimpleDataStoreFactory;
import uk.ac.starlink.ttools.plot2.data.StorageType;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.data.UserDataReader;

public class CachedDataStoreFactory
implements DataStoreFactory {
    private final CachedColumnFactory colFact_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2");

    public CachedDataStoreFactory(CachedColumnFactory colFact) {
        this.colFact_ = colFact;
    }

    @Override
    public DataStore readDataStore(DataSpec[] dataSpecs, DataStore prevStore) throws IOException, InterruptedException {
        CacheData gotData;
        CacheSpec needSpec = CachedDataStoreFactory.createCacheSpec(dataSpecs);
        CacheSpec makeSpec = needSpec.subtract((gotData = prevStore instanceof CacheData ? (CacheData)prevStore : new CacheData()).getSpec());
        if (makeSpec.isEmpty()) {
            return prevStore;
        }
        CacheData oldData = gotData.retain(needSpec);
        CacheData makeData = makeSpec.readData(this.colFact_);
        CacheData useData = makeData.add(oldData);
        return useData;
    }

    private static CacheSpec createCacheSpec(DataSpec[] dataSpecs) {
        HashSet<MaskSpec> mSet = new HashSet<MaskSpec>();
        HashSet<CoordSpec> cSet = new HashSet<CoordSpec>();
        for (int is = 0; is < dataSpecs.length; ++is) {
            DataSpec dspec = dataSpecs[is];
            if (dspec == null) continue;
            mSet.add(new MaskSpec(dspec));
            int nc = dspec.getCoordCount();
            for (int ic = 0; ic < nc; ++ic) {
                cSet.add(new CoordSpec(dspec, ic));
            }
        }
        return new CacheSpec(mSet, cSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    private static CacheData readCacheData(StarTable table, Set<MaskSpec> maskSet, Set<CoordSpec> coordSet, CachedColumnFactory colFact) throws IOException, InterruptedException {
        int ic;
        int im;
        MaskSpec[] masks = maskSet.toArray(new MaskSpec[0]);
        CoordSpec[] coords = coordSet.toArray(new CoordSpec[0]);
        int nm = masks.length;
        int nc = coords.length;
        long nrow = table.getRowCount();
        CachedColumn[] maskCols = new CachedColumn[nm];
        CachedColumn[] coordCols = new CachedColumn[nc];
        for (int im2 = 0; im2 < nm; ++im2) {
            maskCols[im2] = colFact.createColumn(StorageType.BOOLEAN, nrow);
        }
        for (int ic2 = 0; ic2 < nc; ++ic2) {
            coordCols[ic2] = colFact.createColumn(coords[ic2].getStorageType(), nrow);
        }
        RowSequence rseq = table.getRowSequence();
        try {
            long irow = 0L;
            while (rseq.next()) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                for (im = 0; im < nm; ++im) {
                    boolean include = masks[im].readFlag(rseq, irow);
                    maskCols[im].add(include);
                }
                for (ic = 0; ic < nc; ++ic) {
                    Object value = coords[ic].readValue(rseq, irow);
                    coordCols[ic].add(value);
                }
                ++irow;
            }
        }
        finally {
            rseq.close();
        }
        for (int im3 = 0; im3 < nm; ++im3) {
            maskCols[im3].endAdd();
        }
        for (int ic3 = 0; ic3 < nc; ++ic3) {
            coordCols[ic3].endAdd();
        }
        HashMap<MaskSpec, CachedColumn> mMap = new HashMap<MaskSpec, CachedColumn>();
        HashMap<CoordSpec, CachedColumn> cMap = new HashMap<CoordSpec, CachedColumn>();
        for (im = 0; im < nm; ++im) {
            mMap.put(masks[im], maskCols[im]);
        }
        for (ic = 0; ic < nc; ++ic) {
            cMap.put(coords[ic], coordCols[ic]);
        }
        return new CacheData(mMap, cMap);
    }

    private static String itemCount(Collection collection, String word) {
        int count = collection.size();
        StringBuilder sbuf = new StringBuilder().append(count).append(' ').append(word);
        if (count != 1) {
            sbuf.append('s');
        }
        return sbuf.toString();
    }

    private static class CachedTupleSequence
    implements TupleSequence {
        private final int ncol_;
        private final long nrow_;
        private final CachedReader maskRdr_;
        private final CachedReader[] colRdrs_;
        private long irow_ = -1L;

        CachedTupleSequence(CachedColumn mask, CachedColumn[] cols) {
            this.ncol_ = cols.length;
            this.nrow_ = mask.getRowCount();
            this.maskRdr_ = mask.createReader();
            this.colRdrs_ = new CachedReader[this.ncol_];
            for (int ic = 0; ic < this.ncol_; ++ic) {
                this.colRdrs_[ic] = cols[ic].createReader();
            }
        }

        @Override
        public boolean next() {
            while (++this.irow_ < this.nrow_) {
                if (!this.maskRdr_.getBooleanValue(this.irow_)) continue;
                return true;
            }
            return false;
        }

        @Override
        public long getRowIndex() {
            return this.irow_;
        }

        @Override
        public Object getObjectValue(int icol) {
            return this.colRdrs_[icol].getObjectValue(this.irow_);
        }

        @Override
        public double getDoubleValue(int icol) {
            return this.colRdrs_[icol].getDoubleValue(this.irow_);
        }

        @Override
        public int getIntValue(int icol) {
            return this.colRdrs_[icol].getIntValue(this.irow_);
        }

        @Override
        public boolean getBooleanValue(int icol) {
            return this.colRdrs_[icol].getBooleanValue(this.irow_);
        }
    }

    @Equality
    private static class CoordSpec {
        final UserDataReader dataReader_;
        final StarTable table_;
        final int icoord_;
        final Coord coord_;
        final Object coordId_;
        final DomainMapper[] mappers_;

        CoordSpec(DataSpec dataSpec, int icoord) {
            this.dataReader_ = dataSpec.createUserDataReader();
            this.icoord_ = icoord;
            this.table_ = dataSpec.getSourceTable();
            this.coordId_ = dataSpec.getCoordId(icoord);
            this.coord_ = dataSpec.getCoord(icoord);
            this.mappers_ = SimpleDataStoreFactory.getUserCoordMappers(dataSpec, icoord);
        }

        StorageType getStorageType() {
            return this.coord_.getStorageType();
        }

        Object readValue(RowSequence rseq, long irow) throws IOException {
            Object[] userCoords = this.dataReader_.getUserCoordValues(rseq, irow, this.icoord_);
            Object value = this.coord_.inputToStorage(userCoords, this.mappers_);
            assert (value != null);
            return value;
        }

        public boolean equals(Object o) {
            if (o instanceof CoordSpec) {
                CoordSpec other = (CoordSpec)o;
                return other.table_.equals(this.table_) && other.coordId_.equals(this.coordId_);
            }
            return false;
        }

        public int hashCode() {
            return this.table_.hashCode() * 37 + this.coordId_.hashCode();
        }

        public String toString() {
            return String.valueOf(this.coordId_);
        }
    }

    @Equality
    private static class MaskSpec {
        final UserDataReader dataReader_;
        final StarTable table_;
        final Object maskId_;

        MaskSpec(DataSpec dataSpec) {
            this.dataReader_ = dataSpec.createUserDataReader();
            this.table_ = dataSpec.getSourceTable();
            this.maskId_ = dataSpec.getMaskId();
        }

        boolean readFlag(RowSequence rseq, long irow) throws IOException {
            return this.dataReader_.getMaskFlag(rseq, irow);
        }

        public boolean equals(Object o) {
            if (o instanceof MaskSpec) {
                MaskSpec other = (MaskSpec)o;
                return other.table_.equals(this.table_) && other.maskId_.equals(this.maskId_);
            }
            return false;
        }

        public int hashCode() {
            return this.table_.hashCode() * 23 + this.maskId_.hashCode();
        }

        public String toString() {
            return String.valueOf(this.maskId_);
        }
    }

    private static class CacheData
    implements DataStore {
        private final Map<MaskSpec, CachedColumn> mMap_;
        private final Map<CoordSpec, CachedColumn> cMap_;

        CacheData(Map<MaskSpec, CachedColumn> mMap, Map<CoordSpec, CachedColumn> cMap) {
            this.mMap_ = new HashMap<MaskSpec, CachedColumn>(mMap);
            this.cMap_ = new HashMap<CoordSpec, CachedColumn>(cMap);
        }

        CacheData(CacheData cloned) {
            this(cloned.mMap_, cloned.cMap_);
        }

        CacheData() {
            this(new HashMap<MaskSpec, CachedColumn>(), new HashMap<CoordSpec, CachedColumn>());
        }

        CacheSpec getSpec() {
            return new CacheSpec(this.mMap_.keySet(), this.cMap_.keySet());
        }

        CacheData add(CacheData other) {
            CacheData result = new CacheData(this.mMap_, this.cMap_);
            result.mMap_.putAll(other.mMap_);
            result.cMap_.putAll(other.cMap_);
            return result;
        }

        CacheData retain(CacheSpec spec) {
            CacheData result = new CacheData(this.mMap_, this.cMap_);
            result.mMap_.keySet().retainAll(spec.mSet_);
            result.cMap_.keySet().retainAll(spec.cSet_);
            return result;
        }

        CachedColumn getMask(DataSpec dataSpec) {
            return this.mMap_.get(new MaskSpec(dataSpec));
        }

        CachedColumn getColumn(DataSpec dataSpec, int icoord) {
            return this.cMap_.get(new CoordSpec(dataSpec, icoord));
        }

        CachedColumn[] getColumns(DataSpec dataSpec) {
            int ncol = dataSpec.getCoordCount();
            CachedColumn[] cols = new CachedColumn[ncol];
            for (int ic = 0; ic < ncol; ++ic) {
                cols[ic] = this.getColumn(dataSpec, ic);
                if (cols[ic] != null) continue;
                return null;
            }
            return cols;
        }

        @Override
        public boolean hasData(DataSpec spec) {
            return this.getMask(spec) != null && this.getColumns(spec) != null;
        }

        @Override
        public TupleSequence getTupleSequence(DataSpec spec) {
            return new CachedTupleSequence(this.getMask(spec), this.getColumns(spec));
        }
    }

    private static class CacheSpec {
        private final Set<MaskSpec> mSet_;
        private final Set<CoordSpec> cSet_;

        CacheSpec(Set<MaskSpec> mSet, Set<CoordSpec> cSet) {
            this.mSet_ = new HashSet<MaskSpec>(mSet);
            this.cSet_ = new HashSet<CoordSpec>(cSet);
        }

        CacheSpec subtract(CacheSpec other) {
            CacheSpec result = new CacheSpec(this.mSet_, this.cSet_);
            result.mSet_.removeAll(other.mSet_);
            result.cSet_.removeAll(other.cSet_);
            return result;
        }

        boolean isEmpty() {
            return this.mSet_.isEmpty() && this.cSet_.isEmpty();
        }

        @Slow
        CacheData readData(CachedColumnFactory colFact) throws IOException, InterruptedException {
            Level level = Level.INFO;
            if (logger_.isLoggable(level)) {
                String msg = "Caching plot data: " + CachedDataStoreFactory.itemCount(this.getTables(), "table") + ", " + CachedDataStoreFactory.itemCount(this.mSet_, "mask") + ", " + CachedDataStoreFactory.itemCount(this.cSet_, "coord");
                logger_.log(level, msg);
            }
            CacheData data = new CacheData();
            for (StarTable table : this.getTables()) {
                CacheData tData = CachedDataStoreFactory.readCacheData(table, this.getMasks(table), this.getCoords(table), colFact);
                data = data.add(tData);
            }
            return data;
        }

        private Set<StarTable> getTables() {
            HashSet<StarTable> tSet = new HashSet<StarTable>();
            for (MaskSpec mask : this.mSet_) {
                tSet.add(mask.table_);
            }
            for (CoordSpec coord : this.cSet_) {
                tSet.add(coord.table_);
            }
            return tSet;
        }

        private Set<MaskSpec> getMasks(StarTable table) {
            HashSet<MaskSpec> tmSet = new HashSet<MaskSpec>();
            for (MaskSpec mask : this.mSet_) {
                if (!mask.table_.equals(table)) continue;
                tmSet.add(mask);
            }
            return tmSet;
        }

        private Set<CoordSpec> getCoords(StarTable table) {
            HashSet<CoordSpec> tcSet = new HashSet<CoordSpec>();
            for (CoordSpec coord : this.cSet_) {
                if (!coord.table_.equals(table)) continue;
                tcSet.add(coord);
            }
            return tcSet;
        }

        public String toString() {
            return "Masks: " + this.mSet_ + "; Columns: " + this.cSet_;
        }
    }
}

