/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.util.IntList;

public abstract class CoordGroup {
    private CoordGroup() {
    }

    public abstract int getPositionCount();

    public abstract Coord[] getExtraCoords();

    public abstract int getPosCoordIndex(int var1, DataGeom var2);

    public abstract int getExtraCoordIndex(int var1, DataGeom var2);

    public abstract int[] getRangeCoordIndices(DataGeom var1);

    public abstract boolean isSinglePartialPosition();

    public static CoordGroup createSinglePositionCoordGroup() {
        return new BasicCoordGroup(1, new Coord[0]);
    }

    public static CoordGroup createCoordGroup(int npos, Coord[] extras) {
        return new BasicCoordGroup(npos, extras);
    }

    public static CoordGroup createPartialCoordGroup(Coord[] coords, boolean[] rangeCoordFlags) {
        return new PartialPosCoordGroup(coords, rangeCoordFlags);
    }

    public static CoordGroup createEmptyCoordGroup() {
        return new BasicCoordGroup(0, new Coord[0]);
    }

    private static int getPosCoordCount(DataGeom geom) {
        return geom.getPosCoords().length;
    }

    private static class PartialPosCoordGroup
    extends CoordGroup {
        final Coord[] coords_;
        final int[] rangeCoordIndices_;

        PartialPosCoordGroup(Coord[] coords, boolean[] rangeCoordFlags) {
            this.coords_ = coords;
            IntList ilist = new IntList();
            for (int i = 0; i < coords.length; ++i) {
                if (!rangeCoordFlags[i]) continue;
                ilist.add(i);
            }
            this.rangeCoordIndices_ = ilist.toIntArray();
        }

        @Override
        public int getPositionCount() {
            return 0;
        }

        @Override
        public Coord[] getExtraCoords() {
            return this.coords_;
        }

        @Override
        public int getPosCoordIndex(int ipos, DataGeom geom) {
            return -1;
        }

        @Override
        public int getExtraCoordIndex(int iExtra, DataGeom geom) {
            return iExtra;
        }

        @Override
        public int[] getRangeCoordIndices(DataGeom geom) {
            return this.rangeCoordIndices_;
        }

        @Override
        public boolean isSinglePartialPosition() {
            return true;
        }
    }

    private static class BasicCoordGroup
    extends CoordGroup {
        final int npos_;
        final Coord[] extraCoords_;

        BasicCoordGroup(int npos, Coord[] extraCoords) {
            this.npos_ = npos;
            this.extraCoords_ = extraCoords;
        }

        @Override
        public int getPositionCount() {
            return this.npos_;
        }

        @Override
        public Coord[] getExtraCoords() {
            return this.extraCoords_;
        }

        @Override
        public int getPosCoordIndex(int ipos, DataGeom geom) {
            return CoordGroup.getPosCoordCount(geom) * ipos;
        }

        @Override
        public int getExtraCoordIndex(int iExtra, DataGeom geom) {
            return CoordGroup.getPosCoordCount(geom) * this.npos_ + iExtra;
        }

        @Override
        public int[] getRangeCoordIndices(DataGeom geom) {
            int[] ixs = new int[CoordGroup.getPosCoordCount(geom) * this.npos_];
            for (int i = 0; i < ixs.length; ++i) {
                ixs[i] = i;
            }
            return ixs;
        }

        @Override
        public boolean isSinglePartialPosition() {
            return false;
        }
    }
}

