/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.SingleCoord;
import uk.ac.starlink.ttools.plot2.data.StorageType;
import uk.ac.starlink.ttools.plot2.data.Tuple;

public abstract class FloatingArrayCoord
extends SingleCoord {
    private FloatingArrayCoord(InputMeta meta, boolean isRequired, boolean isDouble) {
        super(meta, isRequired, Object.class, isDouble ? StorageType.DOUBLE_ARRAY : StorageType.FLOAT_ARRAY, null);
    }

    public abstract double[] readArrayCoord(Tuple var1, int var2);

    public abstract int getArrayCoordLength(Tuple var1, int var2);

    public static Class[] getAcceptableClasses() {
        return new Class[]{double[].class, float[].class, long[].class, int[].class, short[].class, byte[].class};
    }

    public static FloatingArrayCoord createCoord(InputMeta meta, boolean isRequired) {
        if (PlotUtil.storeFullPrecision()) {
            return new FloatingArrayCoord(meta, isRequired, true){

                @Override
                public Object inputToStorage(Object[] values, DomainMapper[] mappers) {
                    double[] da;
                    Object a = values[0];
                    if (a instanceof double[]) {
                        da = (double[])a;
                    } else if (a instanceof float[]) {
                        float[] fa = (float[])a;
                        int n = fa.length;
                        da = new double[n];
                        for (int i = 0; i < n; ++i) {
                            da[i] = fa[i];
                        }
                    } else if (a instanceof long[]) {
                        long[] la = (long[])a;
                        int n = la.length;
                        da = new double[n];
                        for (int i = 0; i < n; ++i) {
                            da[i] = la[i];
                        }
                    } else if (a instanceof int[]) {
                        int[] ia = (int[])a;
                        int n = ia.length;
                        da = new double[n];
                        for (int i = 0; i < n; ++i) {
                            da[i] = ia[i];
                        }
                    } else if (a instanceof short[]) {
                        short[] sa = (short[])a;
                        int n = sa.length;
                        da = new double[n];
                        for (int i = 0; i < n; ++i) {
                            da[i] = sa[i];
                        }
                    } else if (a instanceof byte[]) {
                        byte[] ba = (byte[])a;
                        int n = ba.length;
                        da = new double[n];
                        for (int i = 0; i < n; ++i) {
                            da[i] = ba[i];
                        }
                    } else {
                        da = new double[]{};
                    }
                    return da;
                }

                @Override
                public int getArrayCoordLength(Tuple tuple, int icol) {
                    return ((double[])tuple.getObjectValue(icol)).length;
                }

                @Override
                public double[] readArrayCoord(Tuple tuple, int icol) {
                    double[] dval = (double[])tuple.getObjectValue(icol);
                    return dval;
                }
            };
        }
        return new FloatingArrayCoord(meta, isRequired, true){

            @Override
            public Object inputToStorage(Object[] values, DomainMapper[] mappers) {
                float[] fa;
                Object a = values[0];
                if (a instanceof float[]) {
                    fa = (float[])a;
                } else if (a instanceof double[]) {
                    double[] da = (double[])a;
                    int n = da.length;
                    fa = new float[n];
                    for (int i = 0; i < n; ++i) {
                        fa[i] = (float)da[i];
                    }
                } else if (a instanceof long[]) {
                    long[] la = (long[])a;
                    int n = la.length;
                    fa = new float[n];
                    for (int i = 0; i < n; ++i) {
                        fa[i] = la[i];
                    }
                } else if (a instanceof int[]) {
                    int[] ia = (int[])a;
                    int n = ia.length;
                    fa = new float[n];
                    for (int i = 0; i < n; ++i) {
                        fa[i] = ia[i];
                    }
                } else if (a instanceof short[]) {
                    short[] sa = (short[])a;
                    int n = sa.length;
                    fa = new float[n];
                    for (int i = 0; i < n; ++i) {
                        fa[i] = sa[i];
                    }
                } else if (a instanceof byte[]) {
                    byte[] ba = (byte[])a;
                    int n = ba.length;
                    fa = new float[n];
                    for (int i = 0; i < n; ++i) {
                        fa[i] = ba[i];
                    }
                } else {
                    fa = new float[]{};
                }
                return fa;
            }

            @Override
            public int getArrayCoordLength(Tuple tuple, int icol) {
                return ((float[])tuple.getObjectValue(icol)).length;
            }

            @Override
            public double[] readArrayCoord(Tuple tuple, int icol) {
                float[] fval = (float[])tuple.getObjectValue(icol);
                int n = fval.length;
                double[] dval = new double[n];
                for (int i = 0; i < n; ++i) {
                    dval[i] = fval[i];
                }
                return dval;
            }
        };
    }
}

